/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.doris.analysis.ColumnDef;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;

public class KeysDesc
implements Writable {
    private KeysType type;
    private List<String> keysColumnNames;

    public KeysDesc() {
        this.type = KeysType.AGG_KEYS;
        this.keysColumnNames = Lists.newArrayList();
    }

    public KeysDesc(KeysType type, List<String> keysColumnNames) {
        this.type = type;
        this.keysColumnNames = keysColumnNames;
    }

    public KeysType getKeysType() {
        return this.type;
    }

    public int keysColumnSize() {
        return this.keysColumnNames.size();
    }

    public boolean containsCol(String colName) {
        return this.keysColumnNames.contains(colName);
    }

    public void analyze(List<ColumnDef> cols) throws AnalysisException {
        int i;
        if (this.type == null) {
            throw new AnalysisException("Keys type is null.");
        }
        if (this.keysColumnNames == null || this.keysColumnNames.size() == 0) {
            throw new AnalysisException("The number of key columns is 0.");
        }
        if (this.keysColumnNames.size() > cols.size()) {
            throw new AnalysisException("The number of key columns should be less than the number of columns.");
        }
        for (i = 0; i < this.keysColumnNames.size(); ++i) {
            String name = cols.get(i).getName();
            if (!this.keysColumnNames.get(i).equalsIgnoreCase(name)) {
                throw new AnalysisException("Key columns should be a ordered prefix of the schema.");
            }
            if (cols.get(i).getAggregateType() == null) continue;
            throw new AnalysisException("Key column[" + name + "] should not specify aggregate type.");
        }
        for (i = this.keysColumnNames.size(); i < cols.size(); ++i) {
            if (this.type == KeysType.AGG_KEYS) {
                if (cols.get(i).getAggregateType() != null) continue;
                throw new AnalysisException(this.type.name() + " table should specify aggregate type for non-key column[" + cols.get(i).getName() + "]");
            }
            if (cols.get(i).getAggregateType() == null) continue;
            throw new AnalysisException(this.type.name() + " table should not specify aggregate type for non-key column[" + cols.get(i).getName() + "]");
        }
    }

    public String toSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.type.name()).append("(");
        int i = 0;
        for (String columnName : this.keysColumnNames) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("`").append(columnName).append("`");
            ++i;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static KeysDesc read(DataInput in) throws IOException {
        KeysDesc desc = new KeysDesc();
        desc.readFields(in);
        return desc;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.type.name());
        int count = this.keysColumnNames.size();
        out.writeInt(count);
        for (String colName : this.keysColumnNames) {
            Text.writeString((DataOutput)out, (String)colName);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.type = KeysType.valueOf(Text.readString((DataInput)in));
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            this.keysColumnNames.add(Text.readString((DataInput)in));
        }
    }
}

