/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import org.apache.doris.thrift.TJoinOp;

public enum JoinOperator {
    INNER_JOIN("INNER JOIN", TJoinOp.INNER_JOIN),
    LEFT_OUTER_JOIN("LEFT OUTER JOIN", TJoinOp.LEFT_OUTER_JOIN),
    LEFT_SEMI_JOIN("LEFT SEMI JOIN", TJoinOp.LEFT_SEMI_JOIN),
    LEFT_ANTI_JOIN("LEFT ANTI JOIN", TJoinOp.LEFT_ANTI_JOIN),
    RIGHT_SEMI_JOIN("RIGHT SEMI JOIN", TJoinOp.RIGHT_SEMI_JOIN),
    RIGHT_ANTI_JOIN("RIGHT ANTI JOIN", TJoinOp.RIGHT_ANTI_JOIN),
    RIGHT_OUTER_JOIN("RIGHT OUTER JOIN", TJoinOp.RIGHT_OUTER_JOIN),
    FULL_OUTER_JOIN("FULL OUTER JOIN", TJoinOp.FULL_OUTER_JOIN),
    CROSS_JOIN("CROSS JOIN", TJoinOp.CROSS_JOIN),
    NULL_AWARE_LEFT_ANTI_JOIN("NULL AWARE LEFT ANTI JOIN", TJoinOp.NULL_AWARE_LEFT_ANTI_JOIN);

    private final String description;
    private final TJoinOp thriftJoinOp;

    private JoinOperator(String description, TJoinOp thriftJoinOp) {
        this.description = description;
        this.thriftJoinOp = thriftJoinOp;
    }

    public String toString() {
        return this.description;
    }

    public TJoinOp toThrift() {
        return this.thriftJoinOp;
    }

    public boolean isOuterJoin() {
        return this == LEFT_OUTER_JOIN || this == RIGHT_OUTER_JOIN || this == FULL_OUTER_JOIN;
    }

    public boolean isSemiAntiJoin() {
        return this == LEFT_SEMI_JOIN || this == RIGHT_SEMI_JOIN || this == LEFT_ANTI_JOIN || this == RIGHT_ANTI_JOIN;
    }

    public boolean isSemiJoin() {
        return this == LEFT_SEMI_JOIN || this == LEFT_ANTI_JOIN || this == RIGHT_SEMI_JOIN || this == RIGHT_ANTI_JOIN || this == NULL_AWARE_LEFT_ANTI_JOIN;
    }

    public boolean isLeftSemiJoin() {
        return this == LEFT_SEMI_JOIN;
    }

    public boolean isInnerJoin() {
        return this == INNER_JOIN;
    }

    public boolean isAntiJoin() {
        return this == LEFT_ANTI_JOIN || this == RIGHT_ANTI_JOIN || this == NULL_AWARE_LEFT_ANTI_JOIN;
    }

    public boolean isCrossJoin() {
        return this == CROSS_JOIN;
    }

    public boolean isFullOuterJoin() {
        return this == FULL_OUTER_JOIN;
    }

    public boolean isLeftOuterJoin() {
        return this == LEFT_OUTER_JOIN;
    }

    public boolean isRightOuterJoin() {
        return this == RIGHT_OUTER_JOIN;
    }
}

