/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;

public class JobName {
    private String jobName;
    private String dbName;

    public JobName(String dbName, String jobName) {
        this.dbName = dbName;
        this.jobName = jobName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getName() {
        return this.jobName;
    }

    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.dbName)) {
            if (Strings.isNullOrEmpty((String)analyzer.getDefaultDb())) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
            this.dbName = analyzer.getDefaultDb();
        }
        this.dbName = ClusterNamespace.getFullName(analyzer.getClusterName(), this.dbName);
    }

    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("`").append(this.dbName).append("`.`").append(this.jobName).append("`");
        return sb.toString();
    }
}

