/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.Predicate;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.FunctionSet;
import org.apache.doris.catalog.ScalarFunction;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IsNullPredicate
extends Predicate {
    private static final Logger LOG = LogManager.getLogger(IsNullPredicate.class);
    private static final String IS_NULL = "is_null_pred";
    private static final String IS_NOT_NULL = "is_not_null_pred";
    private final boolean isNotNull;

    public static void initBuiltins(FunctionSet functionSet) {
        for (Type type : Type.getSupportedTypes()) {
            String isNullSymbol;
            if (type.isNull()) continue;
            if (type == Type.BOOLEAN) {
                isNullSymbol = "_ZN5doris15IsNullPredicate7is_nullIN9doris_udf10BooleanValEEES3_PNS2_15FunctionContextERKT_";
            } else {
                String udfType = Function.getUdfType(type.getPrimitiveType());
                isNullSymbol = "_ZN5doris15IsNullPredicate7is_nullIN9doris_udf" + udfType.length() + udfType + "EEENS2_10BooleanValEPNS2_15FunctionContextERKT_";
            }
            functionSet.addBuiltinBothScalaAndVectorized(ScalarFunction.createBuiltinOperator(IS_NULL, isNullSymbol, Lists.newArrayList((Object[])new Type[]{type}), Type.BOOLEAN));
            String isNotNullSymbol = isNullSymbol.replace("7is_null", "11is_not_null");
            functionSet.addBuiltinBothScalaAndVectorized(ScalarFunction.createBuiltinOperator(IS_NOT_NULL, isNotNullSymbol, Lists.newArrayList((Object[])new Type[]{type}), Type.BOOLEAN));
        }
    }

    public IsNullPredicate(Expr e, boolean isNotNull) {
        this.isNotNull = isNotNull;
        Preconditions.checkNotNull((Object)e);
        this.children.add(e);
    }

    protected IsNullPredicate(IsNullPredicate other) {
        super(other);
        this.isNotNull = other.isNotNull;
    }

    public boolean isNotNull() {
        return this.isNotNull;
    }

    @Override
    public Expr clone() {
        return new IsNullPredicate(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return ((IsNullPredicate)obj).isNotNull == this.isNotNull;
    }

    @Override
    public String toSqlImpl() {
        return ((Expr)this.getChild(0)).toSql() + (this.isNotNull ? " IS NOT NULL" : " IS NULL");
    }

    public boolean isSlotRefChildren() {
        return this.children.get(0) instanceof SlotRef;
    }

    @Override
    public void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        super.analyzeImpl(analyzer);
        this.fn = this.isNotNull ? this.getBuiltinFunction(analyzer, IS_NOT_NULL, this.collectChildReturnTypes(), Function.CompareMode.IS_INDISTINGUISHABLE) : this.getBuiltinFunction(analyzer, IS_NULL, this.collectChildReturnTypes(), Function.CompareMode.IS_INDISTINGUISHABLE);
        Preconditions.checkState((this.fn != null ? 1 : 0) != 0, (Object)"tupleisNull fn == NULL");
        this.selectivity = 0.1;
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.FUNCTION_CALL;
    }

    @Override
    public Expr negate() {
        return new IsNullPredicate((Expr)this.getChild(0), !this.isNotNull);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public Expr getResultValue() throws AnalysisException {
        this.recursiveResetChildrenResult();
        Expr childValue = (Expr)this.getChild(0);
        if (!(childValue instanceof LiteralExpr)) {
            return this;
        }
        return childValue instanceof NullLiteral ? new BoolLiteral(!this.isNotNull) : new BoolLiteral(this.isNotNull);
    }
}

