/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.doris.analysis.DecimalLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FloatLiteral;
import org.apache.doris.analysis.LargeIntLiteral;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.MaxLiteral;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.NotImplementedException;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;
import org.apache.doris.thrift.TIntLiteral;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntLiteral
extends LiteralExpr {
    private static final Logger LOG = LogManager.getLogger(IntLiteral.class);
    public static final long TINY_INT_MIN = -128L;
    public static final long TINY_INT_MAX = 127L;
    public static final long SMALL_INT_MIN = -32768L;
    public static final long SMALL_INT_MAX = 32767L;
    public static final long INT_MIN = Integer.MIN_VALUE;
    public static final long INT_MAX = Integer.MAX_VALUE;
    public static final long BIG_INT_MIN = Long.MIN_VALUE;
    public static final long BIG_INT_MAX = Long.MAX_VALUE;
    private long value;

    private IntLiteral() {
    }

    public IntLiteral(long value) {
        this.init(value);
        this.analysisDone();
    }

    public IntLiteral(long longValue, Type type) throws AnalysisException {
        this.checkValueValid(longValue, type);
        this.value = longValue;
        this.type = type;
        this.analysisDone();
    }

    public IntLiteral(String value, Type type) throws AnalysisException {
        long longValue = -1L;
        try {
            longValue = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid number format: " + value);
        }
        this.checkValueValid(longValue, type);
        this.value = longValue;
        this.type = type;
        this.analysisDone();
    }

    protected IntLiteral(IntLiteral other) {
        super(other);
        this.value = other.value;
    }

    @Override
    public void checkValueValid() throws AnalysisException {
        this.checkValueValid(this.value, this.type);
    }

    private void checkValueValid(long longValue, Type type) throws AnalysisException {
        boolean valid = true;
        switch (type.getPrimitiveType()) {
            case TINYINT: {
                if (longValue >= -128L && longValue <= 127L) break;
                valid = false;
                break;
            }
            case SMALLINT: {
                if (longValue >= -32768L && longValue <= 32767L) break;
                valid = false;
                break;
            }
            case INT: {
                if (longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) break;
                valid = false;
                break;
            }
            case BIGINT: {
                if (longValue >= Long.MIN_VALUE) break;
                valid = false;
                break;
            }
            default: {
                valid = false;
            }
        }
        if (!valid) {
            throw new AnalysisException("Number out of range[" + longValue + "]. type: " + type);
        }
    }

    @Override
    public Expr clone() {
        return new IntLiteral(this);
    }

    private void init(long value) {
        this.value = value;
        if (this.value <= 127L && this.value >= -128L) {
            this.type = Type.TINYINT;
        } else if (this.value <= 32767L && this.value >= -32768L) {
            this.type = Type.SMALLINT;
        } else if (this.value <= Integer.MAX_VALUE && this.value >= Integer.MIN_VALUE) {
            this.type = Type.INT;
        } else if (this.value <= Long.MAX_VALUE && this.value >= Long.MIN_VALUE) {
            this.type = Type.BIGINT;
        } else {
            Preconditions.checkState((boolean)false, (Object)value);
        }
    }

    public static IntLiteral createMinValue(Type type) {
        long value = 0L;
        switch (type.getPrimitiveType()) {
            case TINYINT: {
                value = -128L;
                break;
            }
            case SMALLINT: {
                value = -32768L;
                break;
            }
            case INT: {
                value = Integer.MIN_VALUE;
                break;
            }
            case BIGINT: {
                value = Long.MIN_VALUE;
                break;
            }
            default: {
                Preconditions.checkState((boolean)false);
            }
        }
        return new IntLiteral(value);
    }

    @Override
    public boolean isMinValue() {
        switch (this.type.getPrimitiveType()) {
            case TINYINT: {
                return this.value == -128L;
            }
            case SMALLINT: {
                return this.value == -32768L;
            }
            case INT: {
                return this.value == Integer.MIN_VALUE;
            }
            case BIGINT: {
                return this.value == Long.MIN_VALUE;
            }
        }
        return false;
    }

    @Override
    public ByteBuffer getHashValue(PrimitiveType type) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        switch (type) {
            case TINYINT: {
                buffer.put((byte)this.value);
                break;
            }
            case SMALLINT: {
                buffer.putShort((short)this.value);
                break;
            }
            case INT: {
                buffer.putInt((int)this.value);
                break;
            }
            case BIGINT: {
                buffer.putLong(this.value);
                break;
            }
        }
        buffer.flip();
        return buffer;
    }

    @Override
    public int compareLiteral(LiteralExpr expr) {
        if (expr instanceof NullLiteral) {
            return 1;
        }
        if (expr instanceof StringLiteral) {
            return ((StringLiteral)expr).compareLiteral(this);
        }
        if (expr == MaxLiteral.MAX_VALUE) {
            return -1;
        }
        if (this.value == expr.getLongValue()) {
            return 0;
        }
        return this.value > expr.getLongValue() ? 1 : -1;
    }

    @Override
    public Object getRealValue() {
        return this.getLongValue();
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        return Long.toString(this.value);
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public String toSqlImpl() {
        return this.getStringValue();
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.INT_LITERAL;
        msg.int_literal = new TIntLiteral(this.value);
    }

    @Override
    protected Expr uncheckedCastTo(Type targetType) throws AnalysisException {
        if (!targetType.isNumericType()) {
            return super.uncheckedCastTo(targetType);
        }
        if (targetType.isFixedPointType()) {
            if (!targetType.isScalarType(PrimitiveType.LARGEINT)) {
                if (!this.type.equals(targetType)) {
                    IntLiteral intLiteral = new IntLiteral(this);
                    intLiteral.setType(targetType);
                    return intLiteral;
                }
                return this;
            }
            return new LargeIntLiteral(Long.toString(this.value));
        }
        if (targetType.isFloatingPointType()) {
            return new FloatLiteral(new Double(this.value), targetType);
        }
        if (targetType.isDecimalV2()) {
            return new DecimalLiteral(new BigDecimal(this.value));
        }
        return this;
    }

    @Override
    public void swapSign() throws NotImplementedException {
        this.value = -this.value;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.value);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.value = in.readLong();
    }

    public static IntLiteral read(DataInput in) throws IOException {
        IntLiteral literal = new IntLiteral();
        literal.readFields(in);
        return literal;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Long.hashCode(this.value);
    }
}

