/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.Config;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class InstallPluginStmt
extends DdlStmt {
    private String pluginPath;
    private Map<String, String> properties;

    public InstallPluginStmt(String pluginPath, Map<String, String> properties) {
        this.pluginPath = pluginPath;
        this.properties = properties;
    }

    public String getPluginPath() {
        return this.pluginPath;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getMd5sum() {
        return this.properties == null ? null : this.properties.get("md5sum");
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (!Config.plugin_enable) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_OPERATION_DISABLED, "INSTALL PLUGIN", "Please enable it by setting 'plugin_enable' = 'true'");
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSTALL PLUGIN FROM ").append("\"" + this.pluginPath + "\"");
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append("\nPROPERTIES (");
            sb.append(new PrintableMap<String, String>(this.properties, " = ", true, true, true));
            sb.append(")");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.FORWARD_WITH_SYNC;
    }
}

