/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.DefaultValueExpr;
import org.apache.doris.analysis.DescriptorTable;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.InsertSource;
import org.apache.doris.analysis.InsertTarget;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.BrokerTable;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MysqlTable;
import org.apache.doris.catalog.OdbcTable;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.DataSink;
import org.apache.doris.planner.ExportSink;
import org.apache.doris.planner.OlapTableSink;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.rewrite.ExprRewriter;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.thrift.TUniqueId;
import org.apache.doris.transaction.TransactionState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InsertStmt
extends DdlStmt {
    private static final Logger LOG = LogManager.getLogger(InsertStmt.class);
    public static final String SHUFFLE_HINT = "SHUFFLE";
    public static final String NOSHUFFLE_HINT = "NOSHUFFLE";
    public static final String STREAMING = "STREAMING";
    private final TableName tblName;
    private final PartitionNames targetPartitionNames;
    private List<Long> targetPartitionIds;
    private final List<String> targetColumnNames;
    private QueryStmt queryStmt;
    private final List<String> planHints;
    private Boolean isRepartition;
    private boolean isStreaming = false;
    private String label = null;
    private boolean isUserSpecifiedLabel = false;
    private Map<Long, Integer> indexIdToSchemaHash = null;
    private ArrayList<Expr> resultExprs = Lists.newArrayList();
    private Map<String, Expr> exprByName = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
    private Table targetTable;
    private Database db;
    private long transactionId;
    private TupleDescriptor olapTuple;
    private DataSink dataSink;
    private DataPartition dataPartition;
    private List<Column> targetColumns = Lists.newArrayList();
    private boolean isTransactionBegin = false;
    private boolean isValuesOrConstantSelect = false;

    public boolean isValuesOrConstantSelect() {
        return this.isValuesOrConstantSelect;
    }

    public InsertStmt(InsertTarget target, String label, List<String> cols, InsertSource source, List<String> hints) {
        this.tblName = target.getTblName();
        this.targetPartitionNames = target.getPartitionNames();
        this.label = label;
        this.queryStmt = source.getQueryStmt();
        this.planHints = hints;
        this.targetColumnNames = cols;
        if (!Strings.isNullOrEmpty((String)label)) {
            this.isUserSpecifiedLabel = true;
        }
        this.isValuesOrConstantSelect = this.queryStmt instanceof SelectStmt && ((SelectStmt)this.queryStmt).getTableRefs().isEmpty();
    }

    public InsertStmt(TableName name, QueryStmt queryStmt) {
        this.tblName = name;
        this.targetPartitionNames = null;
        this.targetColumnNames = null;
        this.queryStmt = queryStmt;
        this.planHints = null;
    }

    public TupleDescriptor getOlapTuple() {
        return this.olapTuple;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(Table targetTable) {
        this.targetTable = targetTable;
    }

    public Map<Long, Integer> getIndexIdToSchemaHash() {
        return this.indexIdToSchemaHash;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public Boolean isRepartition() {
        return this.isRepartition;
    }

    public String getDb() {
        return this.tblName.getDb();
    }

    public String getTbl() {
        return this.tblName.getTbl();
    }

    public void getTables(Analyzer analyzer, Map<Long, Table> tableMap, Set<String> parentViewNameSet) throws AnalysisException {
        this.queryStmt.getTables(analyzer, tableMap, parentViewNameSet);
        this.tblName.analyze(analyzer);
        String dbName = this.tblName.getDb();
        String tableName = this.tblName.getTbl();
        Database db = analyzer.getCatalog().getDbOrAnalysisException(dbName);
        Table table = db.getTableOrAnalysisException(this.tblName.getTbl());
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), dbName, tableName, PrivPredicate.LOAD)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "LOAD", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), dbName + ": " + tableName);
        }
        tableMap.put(table.getId(), table);
    }

    public QueryStmt getQueryStmt() {
        return this.queryStmt;
    }

    public void setQueryStmt(QueryStmt queryStmt) {
        this.queryStmt = queryStmt;
    }

    @Override
    public void foldConstant(ExprRewriter rewriter) throws AnalysisException {
        Preconditions.checkState((boolean)this.isAnalyzed());
        this.queryStmt.foldConstant(rewriter);
    }

    @Override
    public void rewriteExprs(ExprRewriter rewriter) throws AnalysisException {
        Preconditions.checkState((boolean)this.isAnalyzed());
        this.queryStmt.rewriteExprs(rewriter);
    }

    @Override
    public boolean isExplain() {
        return this.queryStmt.isExplain();
    }

    public boolean isStreaming() {
        return this.isStreaming;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isUserSpecifiedLabel() {
        return this.isUserSpecifiedLabel;
    }

    public DataSink getDataSink() {
        return this.dataSink;
    }

    public Database getDbObj() {
        return this.db;
    }

    public boolean isTransactionBegin() {
        return this.isTransactionBegin;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (this.targetTable == null) {
            this.tblName.analyze(analyzer);
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.tblName.getDb(), this.tblName.getTbl(), PrivPredicate.LOAD)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "LOAD", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), this.tblName.getDb() + ": " + this.tblName.getTbl());
        }
        if (this.targetPartitionNames != null) {
            this.targetPartitionNames.analyze(analyzer);
        }
        this.analyzeTargetTable(analyzer);
        this.analyzeSubquery(analyzer);
        this.analyzePlanHints(analyzer);
        if (analyzer.getContext().isTxnModel()) {
            return;
        }
        this.createDataSink();
        this.db = analyzer.getCatalog().getDbOrAnalysisException(this.tblName.getDb());
        long timeoutSecond = ConnectContext.get().getSessionVariable().getQueryTimeoutS();
        if (Strings.isNullOrEmpty((String)this.label)) {
            this.label = "insert_" + DebugUtil.printId(analyzer.getContext().queryId());
        }
        if (!this.isExplain() && !this.isTransactionBegin) {
            if (this.targetTable instanceof OlapTable) {
                TransactionState.LoadJobSourceType sourceType = TransactionState.LoadJobSourceType.INSERT_STREAMING;
                MetricRepo.COUNTER_LOAD_ADD.increase(1L);
                this.transactionId = Catalog.getCurrentGlobalTransactionMgr().beginTransaction(this.db.getId(), Lists.newArrayList((Object[])new Long[]{this.targetTable.getId()}), this.label, new TransactionState.TxnCoordinator(TransactionState.TxnSourceType.FE, FrontendOptions.getLocalHostAddress()), sourceType, timeoutSecond);
            }
            this.isTransactionBegin = true;
        }
        if (!this.isExplain() && this.targetTable instanceof OlapTable) {
            OlapTableSink sink = (OlapTableSink)this.dataSink;
            TUniqueId loadId = analyzer.getContext().queryId();
            int sendBatchParallelism = analyzer.getContext().getSessionVariable().getSendBatchParallelism();
            sink.init(loadId, this.transactionId, this.db.getId(), timeoutSecond, sendBatchParallelism, false);
        }
    }

    private void analyzeTargetTable(Analyzer analyzer) throws AnalysisException {
        if (this.targetTable == null) {
            this.targetTable = analyzer.getTableOrAnalysisException(this.tblName);
        }
        if (this.targetTable instanceof OlapTable) {
            OlapTable olapTable = (OlapTable)this.targetTable;
            if (this.targetPartitionNames != null) {
                this.targetPartitionIds = Lists.newArrayList();
                if (olapTable.getPartitionInfo().getType() == PartitionType.UNPARTITIONED) {
                    ErrorReport.reportAnalysisException(ErrorCode.ERR_PARTITION_CLAUSE_NO_ALLOWED, new Object[0]);
                }
                for (String partName : this.targetPartitionNames.getPartitionNames()) {
                    Partition part = olapTable.getPartition(partName, this.targetPartitionNames.isTemp());
                    if (part == null) {
                        ErrorReport.reportAnalysisException(ErrorCode.ERR_UNKNOWN_PARTITION, partName, this.targetTable.getName());
                    }
                    this.targetPartitionIds.add(part.getId());
                }
            }
            DescriptorTable descTable = analyzer.getDescTbl();
            this.olapTuple = descTable.createTupleDescriptor();
            for (Column col : olapTable.getFullSchema()) {
                SlotDescriptor slotDesc = descTable.addSlotDescriptor(this.olapTuple);
                slotDesc.setIsMaterialized(true);
                slotDesc.setType(col.getType());
                slotDesc.setColumn(col);
                if (col.isAllowNull()) {
                    slotDesc.setIsNullable(true);
                    continue;
                }
                slotDesc.setIsNullable(false);
            }
            this.indexIdToSchemaHash = olapTable.getIndexIdToSchemaHash();
        } else if (this.targetTable instanceof MysqlTable || this.targetTable instanceof OdbcTable) {
            if (this.targetPartitionNames != null) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_PARTITION_CLAUSE_NO_ALLOWED, new Object[0]);
            }
        } else if (this.targetTable instanceof BrokerTable) {
            BrokerTable brokerTable;
            if (this.targetPartitionNames != null) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_PARTITION_CLAUSE_NO_ALLOWED, new Object[0]);
            }
            if (!(brokerTable = (BrokerTable)this.targetTable).isWritable()) {
                throw new AnalysisException("table " + brokerTable.getName() + "is not writable. path should be an dir");
            }
        } else {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_NON_INSERTABLE_TABLE, new Object[]{this.targetTable.getName(), this.targetTable.getType()});
        }
    }

    private void checkColumnCoverage(Set<String> mentionedCols, List<Column> baseColumns) throws AnalysisException {
        for (Column col : baseColumns) {
            if (mentionedCols.contains(col.getName()) || col.getDefaultValue() != null || col.isAllowNull()) continue;
            ErrorReport.reportAnalysisException(ErrorCode.ERR_COL_NOT_MENTIONED, col.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void analyzeSubquery(Analyzer analyzer) throws UserException {
        TreeSet mentionedColumns = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        if (this.targetColumnNames == null) {
            for (Column column : this.targetTable.getBaseSchema(false)) {
                mentionedColumns.add(column.getName());
                this.targetColumns.add(column);
            }
        } else {
            for (String string : this.targetColumnNames) {
                Column col = this.targetTable.getColumn(string);
                if (col == null) {
                    ErrorReport.reportAnalysisException(ErrorCode.ERR_BAD_FIELD_ERROR, string, this.targetTable.getName());
                }
                if (!mentionedColumns.add(string)) {
                    ErrorReport.reportAnalysisException(ErrorCode.ERR_FIELD_SPECIFIED_TWICE, string);
                }
                this.targetColumns.add(col);
            }
            for (Column column : this.targetTable.getBaseSchema()) {
                if (column.getType().isHllType() && !mentionedColumns.contains(column.getName())) {
                    throw new AnalysisException(" hll column " + column.getName() + " mush in insert into columns");
                }
                if (!column.getType().isBitmapType() || mentionedColumns.contains(column.getName())) continue;
                throw new AnalysisException(" object column " + column.getName() + " mush in insert into columns");
            }
        }
        ArrayList origColIdxsForExtendCols = Lists.newArrayList();
        block3: for (Column column : this.targetTable.getFullSchema()) {
            if (column.isNameWithPrefix("__doris_shadow_")) {
                String origName = Column.removeNamePrefix(column.getName());
                for (int i = 0; i < this.targetColumns.size(); ++i) {
                    if (!this.targetColumns.get(i).nameEquals(origName, false)) continue;
                    origColIdxsForExtendCols.add(new Pair<Integer, Object>(i, null));
                    this.targetColumns.add(column);
                    break;
                }
            }
            if (!column.isNameWithPrefix("mv_")) continue;
            SlotRef refColumn = column.getRefColumn();
            if (refColumn == null) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_BAD_FIELD_ERROR, column.getName(), this.targetTable.getName());
            }
            String origName = refColumn.getColumnName();
            for (int originColumnIdx = 0; originColumnIdx < this.targetColumns.size(); ++originColumnIdx) {
                if (!this.targetColumns.get(originColumnIdx).nameEquals(origName, false)) continue;
                origColIdxsForExtendCols.add(new Pair<Integer, Column>(originColumnIdx, column));
                this.targetColumns.add(column);
                continue block3;
            }
        }
        this.queryStmt.setFromInsert(true);
        this.queryStmt.analyze(analyzer);
        if (mentionedColumns.size() != ((ArrayList)this.queryStmt.getResultExprs()).size()) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_WRONG_VALUE_COUNT, new Object[0]);
        }
        this.checkColumnCoverage(mentionedColumns, this.targetTable.getBaseSchema());
        if (this.isValuesOrConstantSelect) {
            List<Object> rows;
            SelectStmt selectStmt = (SelectStmt)this.queryStmt;
            if (selectStmt.getValueList() != null) {
                rows = selectStmt.getValueList().getRows();
                for (int rowIdx = 0; rowIdx < rows.size(); ++rowIdx) {
                    this.analyzeRow(analyzer, this.targetColumns, rows, rowIdx, origColIdxsForExtendCols);
                }
                ((ArrayList)selectStmt.getResultExprs()).clear();
                selectStmt.getBaseTblResultExprs().clear();
                for (int i = 0; i < selectStmt.getValueList().getFirstRow().size(); ++i) {
                    ((ArrayList)selectStmt.getResultExprs()).add(selectStmt.getValueList().getFirstRow().get(i));
                    selectStmt.getBaseTblResultExprs().add(selectStmt.getValueList().getFirstRow().get(i));
                }
            } else {
                rows = Lists.newArrayList();
                rows.add(Lists.newArrayList((Iterable)selectStmt.getResultExprs()));
                this.analyzeRow(analyzer, this.targetColumns, rows, 0, origColIdxsForExtendCols);
                ((ArrayList)selectStmt.getResultExprs()).clear();
                for (Expr expr : (ArrayList)rows.get(0)) {
                    ((ArrayList)selectStmt.getResultExprs()).add(expr);
                }
            }
            this.isStreaming = true;
        } else {
            void var4_14;
            if (!origColIdxsForExtendCols.isEmpty()) {
                for (Pair entry : origColIdxsForExtendCols) {
                    if (entry.second == null) {
                        ((ArrayList)this.queryStmt.getResultExprs()).add((Expr)((ArrayList)this.queryStmt.getResultExprs()).get((Integer)entry.first));
                        continue;
                    }
                    ExprSubstitutionMap smap = new ExprSubstitutionMap();
                    smap.getLhs().add(((Column)entry.second).getRefColumn());
                    smap.getRhs().add((Expr)((ArrayList)this.queryStmt.getResultExprs()).get((Integer)entry.first));
                    Expr e = Expr.substituteList(Lists.newArrayList((Object[])new Expr[]{((Column)entry.second).getDefineExpr()}), smap, analyzer, false).get(0);
                    ((ArrayList)this.queryStmt.getResultExprs()).add(e);
                }
            }
            boolean bl = false;
            while (var4_14 < this.targetColumns.size()) {
                Column column;
                column = this.targetColumns.get((int)var4_14);
                Expr expr = (Expr)((ArrayList)this.queryStmt.getResultExprs()).get((int)var4_14);
                ((ArrayList)this.queryStmt.getResultExprs()).set((int)var4_14, expr.checkTypeCompatibility(column.getType()));
                ++var4_14;
            }
        }
        if (!origColIdxsForExtendCols.isEmpty()) {
            if (((ArrayList)this.queryStmt.getResultExprs()).size() != this.queryStmt.getBaseTblResultExprs().size()) {
                for (Pair entry : origColIdxsForExtendCols) {
                    if (entry.second == null) {
                        this.queryStmt.getBaseTblResultExprs().add(this.queryStmt.getBaseTblResultExprs().get((Integer)entry.first));
                        continue;
                    }
                    ExprSubstitutionMap smap = new ExprSubstitutionMap();
                    smap.getLhs().add(((Column)entry.second).getRefColumn());
                    smap.getRhs().add((Expr)((ArrayList)this.queryStmt.getResultExprs()).get((Integer)entry.first));
                    Expr e = Expr.substituteList(Lists.newArrayList((Object[])new Expr[]{((Column)entry.second).getDefineExpr()}), smap, analyzer, false).get(0);
                    this.queryStmt.getBaseTblResultExprs().add(e);
                }
            }
            if (((ArrayList)this.queryStmt.getResultExprs()).size() != ((ArrayList)this.queryStmt.getColLabels()).size()) {
                for (Pair entry : origColIdxsForExtendCols) {
                    ((ArrayList)this.queryStmt.getColLabels()).add((String)((ArrayList)this.queryStmt.getColLabels()).get((Integer)entry.first));
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            for (Expr expr : this.queryStmt.getResultExprs()) {
                LOG.debug("final result expr: {}, {}", (Object)expr, (Object)System.identityHashCode(expr));
            }
            for (Expr expr : this.queryStmt.getBaseTblResultExprs()) {
                LOG.debug("final base table result expr: {}, {}", (Object)expr, (Object)System.identityHashCode(expr));
            }
            for (String colLabel : this.queryStmt.getColLabels()) {
                LOG.debug("final col label: {}", (Object)colLabel);
            }
        }
    }

    private void analyzeRow(Analyzer analyzer, List<Column> targetColumns, List<ArrayList<Expr>> rows, int rowIdx, List<Pair<Integer, Column>> origColIdxsForExtendCols) throws AnalysisException {
        if (rows.get(rowIdx).size() != targetColumns.size() - origColIdxsForExtendCols.size()) {
            throw new AnalysisException("Column count doesn't match value count at row " + (rowIdx + 1));
        }
        ArrayList row = rows.get(rowIdx);
        if (!origColIdxsForExtendCols.isEmpty()) {
            ArrayList extentedRow = Lists.newArrayList();
            extentedRow.addAll(row);
            for (Pair<Integer, Column> entry : origColIdxsForExtendCols) {
                if (entry == null) continue;
                if (entry.second == null) {
                    extentedRow.add((Expr)extentedRow.get((Integer)entry.first));
                    continue;
                }
                ExprSubstitutionMap smap = new ExprSubstitutionMap();
                smap.getLhs().add(((Column)entry.second).getRefColumn());
                smap.getRhs().add((Expr)extentedRow.get((Integer)entry.first));
                extentedRow.add(Expr.substituteList(Lists.newArrayList((Object[])new Expr[]{((Column)entry.second).getDefineExpr()}), smap, analyzer, false).get(0));
            }
            row = extentedRow;
            rows.set(rowIdx, row);
        }
        for (int i = 0; i < row.size(); ++i) {
            Expr expr = row.get(i);
            Column col = targetColumns.get(i);
            if (expr instanceof DefaultValueExpr) {
                if (targetColumns.get(i).getDefaultValue() == null) {
                    throw new AnalysisException("Column has no default value, column=" + targetColumns.get(i).getName());
                }
                expr = new StringLiteral(targetColumns.get(i).getDefaultValue());
            }
            expr.analyze(analyzer);
            row.set(i, expr.checkTypeCompatibility(col.getType()));
        }
    }

    private void analyzePlanHints(Analyzer analyzer) throws AnalysisException {
        if (this.planHints == null) {
            return;
        }
        for (String hint : this.planHints) {
            if (SHUFFLE_HINT.equalsIgnoreCase(hint)) {
                if (!this.targetTable.isPartitioned()) {
                    ErrorReport.reportAnalysisException(ErrorCode.ERR_INSERT_HINT_NOT_SUPPORT, new Object[0]);
                }
                if (this.isRepartition != null && !this.isRepartition.booleanValue()) {
                    ErrorReport.reportAnalysisException(ErrorCode.ERR_PLAN_HINT_CONFILT, hint);
                }
                this.isRepartition = Boolean.TRUE;
                continue;
            }
            if (NOSHUFFLE_HINT.equalsIgnoreCase(hint)) {
                if (!this.targetTable.isPartitioned()) {
                    ErrorReport.reportAnalysisException(ErrorCode.ERR_INSERT_HINT_NOT_SUPPORT, new Object[0]);
                }
                if (this.isRepartition != null && this.isRepartition.booleanValue()) {
                    ErrorReport.reportAnalysisException(ErrorCode.ERR_PLAN_HINT_CONFILT, hint);
                }
                this.isRepartition = Boolean.FALSE;
                continue;
            }
            if (STREAMING.equalsIgnoreCase(hint)) {
                this.isStreaming = true;
                continue;
            }
            ErrorReport.reportAnalysisException(ErrorCode.ERR_UNKNOWN_PLAN_HINT, hint);
        }
    }

    public void prepareExpressions() throws UserException {
        ArrayList selectList = Expr.cloneList(this.queryStmt.getResultExprs());
        int numCols = this.targetColumns.size();
        for (int i = 0; i < numCols; ++i) {
            Column col = this.targetColumns.get(i);
            Expr expr = ((Expr)selectList.get(i)).checkTypeCompatibility(col.getType());
            selectList.set(i, expr);
            this.exprByName.put(col.getName(), expr);
        }
        for (Column col : this.targetTable.getFullSchema()) {
            if (this.exprByName.containsKey(col.getName())) {
                this.resultExprs.add(this.exprByName.get(col.getName()));
                continue;
            }
            if (col.getDefaultValue() == null) {
                Preconditions.checkState((boolean)col.isAllowNull());
                this.resultExprs.add(NullLiteral.create(col.getType()));
                continue;
            }
            if (col.getDefaultValueExprDef() != null) {
                this.resultExprs.add(col.getDefaultValueExpr());
                continue;
            }
            StringLiteral defaultValueExpr = new StringLiteral(col.getDefaultValue());
            this.resultExprs.add(defaultValueExpr.checkTypeCompatibility(col.getType()));
        }
    }

    private DataSink createDataSink() throws AnalysisException {
        if (this.dataSink != null) {
            return this.dataSink;
        }
        if (this.targetTable instanceof OlapTable) {
            this.dataSink = new OlapTableSink((OlapTable)this.targetTable, this.olapTuple, this.targetPartitionIds);
            this.dataPartition = this.dataSink.getOutputPartition();
        } else if (this.targetTable instanceof BrokerTable) {
            BrokerTable table = (BrokerTable)this.targetTable;
            BrokerDesc brokerDesc = new BrokerDesc(table.getBrokerName(), table.getBrokerProperties());
            this.dataSink = new ExportSink(table.getWritablePath(), table.getColumnSeparator(), table.getLineDelimiter(), brokerDesc);
            this.dataPartition = this.dataSink.getOutputPartition();
        } else {
            this.dataSink = DataSink.createDataSink(this.targetTable);
            this.dataPartition = DataPartition.UNPARTITIONED;
        }
        return this.dataSink;
    }

    public void complete() throws UserException {
        if (!this.isExplain() && this.targetTable instanceof OlapTable) {
            ((OlapTableSink)this.dataSink).complete();
            TransactionState txnState = Catalog.getCurrentGlobalTransactionMgr().getTransactionState(this.db.getId(), this.transactionId);
            if (txnState == null) {
                throw new DdlException("txn does not exist: " + this.transactionId);
            }
            txnState.addTableIndexes((OlapTable)this.targetTable);
        }
    }

    public ArrayList<Expr> getResultExprs() {
        return this.resultExprs;
    }

    public DataPartition getDataPartition() {
        return this.dataPartition;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.targetPartitionIds != null) {
            this.targetPartitionIds.clear();
        }
        this.queryStmt.reset();
        this.resultExprs.clear();
        this.exprByName.clear();
        this.dataSink = null;
        this.dataPartition = null;
        this.targetColumns.clear();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        if (this.isExplain()) {
            return RedirectStatus.NO_FORWARD;
        }
        return RedirectStatus.FORWARD_WITH_SYNC;
    }
}

