/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.doris.analysis.AnalyticInfo;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.analysis.ToSqlUtils;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.analysis.TupleIsNullPredicate;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.InlineView;
import org.apache.doris.catalog.View;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.rewrite.ExprRewriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InlineViewRef
extends TableRef {
    private static final Logger LOG = LogManager.getLogger(InlineViewRef.class);
    private final View view;
    private List<String> explicitColLabels;
    private QueryStmt queryStmt;
    private Analyzer inlineViewAnalyzer;
    private final ArrayList<TupleId> materializedTupleIds = Lists.newArrayList();
    protected final ExprSubstitutionMap sMap;
    protected final ExprSubstitutionMap baseTblSmap;

    public InlineViewRef(String alias, QueryStmt queryStmt) {
        super(null, alias);
        this.queryStmt = queryStmt;
        this.view = null;
        this.sMap = new ExprSubstitutionMap();
        this.baseTblSmap = new ExprSubstitutionMap();
    }

    public InlineViewRef(String alias, QueryStmt queryStmt, List<String> colLabels) {
        this(alias, queryStmt);
        this.explicitColLabels = Lists.newArrayList(colLabels);
    }

    public InlineViewRef(View view, TableRef origTblRef) {
        super(origTblRef.getName(), origTblRef.getExplicitAlias());
        this.queryStmt = view.getQueryStmt().clone();
        if (view.isLocalView()) {
            this.queryStmt.reset();
        }
        this.view = view;
        this.sMap = new ExprSubstitutionMap();
        this.baseTblSmap = new ExprSubstitutionMap();
        this.setJoinAttrs(origTblRef);
        this.explicitColLabels = view.getColLabels();
        if (this.hasExplicitAlias()) {
            return;
        }
        this.aliases_ = view.isLocalView() ? new String[]{view.getName()} : new String[]{this.name.toString(), view.getName()};
        if (origTblRef.getLateralViewRefs() != null) {
            this.lateralViewRefs = (ArrayList)origTblRef.getLateralViewRefs().clone();
        }
    }

    protected InlineViewRef(InlineViewRef other) {
        super(other);
        this.queryStmt = other.queryStmt.clone();
        this.view = other.view;
        this.inlineViewAnalyzer = other.inlineViewAnalyzer;
        if (other.explicitColLabels != null) {
            this.explicitColLabels = Lists.newArrayList(other.explicitColLabels);
        }
        this.materializedTupleIds.addAll(other.materializedTupleIds);
        this.sMap = other.sMap.clone();
        this.baseTblSmap = other.baseTblSmap.clone();
    }

    public List<String> getExplicitColLabels() {
        return this.explicitColLabels;
    }

    public List<String> getColLabels() {
        if (this.explicitColLabels != null) {
            return this.explicitColLabels;
        }
        return this.queryStmt.getColLabels();
    }

    @Override
    public void reset() {
        super.reset();
        this.queryStmt.reset();
        this.inlineViewAnalyzer = null;
        this.materializedTupleIds.clear();
        this.sMap.clear();
        this.baseTblSmap.clear();
    }

    @Override
    public TableRef clone() {
        return new InlineViewRef(this);
    }

    public void setNeedToSql(boolean needToSql) {
        this.queryStmt.setNeedToSql(needToSql);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        if (this.isAnalyzed) {
            return;
        }
        if (this.view == null && !this.hasExplicitAlias()) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_DERIVED_MUST_HAVE_ALIAS, new Object[0]);
        }
        this.inlineViewAnalyzer = new Analyzer(analyzer);
        this.queryStmt.analyze(this.inlineViewAnalyzer);
        this.correlatedTupleIds_.addAll(this.queryStmt.getCorrelatedTupleIds(this.inlineViewAnalyzer));
        this.queryStmt.getMaterializedTupleIds(this.materializedTupleIds);
        if (this.view != null && !this.hasExplicitAlias() && !this.view.isLocalView()) {
            this.name = analyzer.getFqTableName(this.name);
            this.aliases_ = new String[]{this.name.toString(), this.view.getName()};
        }
        this.desc = analyzer.registerTableRef(this);
        this.isAnalyzed = true;
        if (this.materializedTupleIds.isEmpty()) {
            Preconditions.checkState((boolean)(this.queryStmt instanceof SelectStmt));
            Preconditions.checkState((boolean)((SelectStmt)this.queryStmt).getTableRefs().isEmpty());
            this.desc.setIsMaterialized(true);
            this.materializedTupleIds.add(this.desc.getId());
        }
        for (int i = 0; i < this.getColLabels().size(); ++i) {
            String colName = this.getColLabels().get(i);
            SlotDescriptor slotDesc = analyzer.registerColumnRef(this.getAliasAsName(), colName);
            Expr colExpr = (Expr)((ArrayList)this.queryStmt.getResultExprs()).get(i);
            SlotRef slotRef = new SlotRef(slotDesc);
            this.sMap.put(slotRef, colExpr);
            this.baseTblSmap.put(slotRef, this.queryStmt.getBaseTblResultExprs().get(i));
            if (!this.createAuxPredicate(colExpr)) continue;
            analyzer.createAuxEquivPredicate(new SlotRef(slotDesc), colExpr.clone());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("inline view " + this.getUniqueAlias() + " smap: " + this.sMap.debugString());
            LOG.debug("inline view " + this.getUniqueAlias() + " baseTblSmap: " + this.baseTblSmap.debugString());
        }
        this.analyzeLateralViewRef(analyzer);
        this.analyzeJoin(analyzer);
    }

    public boolean createAuxPredicate(Expr e) {
        if (!(this.queryStmt instanceof SelectStmt) || !((SelectStmt)this.queryStmt).hasAnalyticInfo()) {
            return true;
        }
        AnalyticInfo analyticInfo = ((SelectStmt)this.queryStmt).getAnalyticInfo();
        return analyticInfo.getCommonPartitionExprs().contains(e);
    }

    @Override
    public TupleDescriptor createTupleDescriptor(Analyzer analyzer) throws AnalysisException {
        int numColLabels = this.getColLabels().size();
        Preconditions.checkState((numColLabels > 0 ? 1 : 0) != 0);
        TreeSet columnSet = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        ArrayList columnList = Lists.newArrayList();
        for (int i = 0; i < numColLabels; ++i) {
            Expr selectItemExpr = (Expr)((ArrayList)this.queryStmt.getResultExprs()).get(i);
            String colAlias = this.getColLabels().get(i);
            if (columnSet.contains(colAlias)) {
                throw new AnalysisException("Duplicated inline view column alias: '" + colAlias + "' in inline view '" + this.getAlias() + "'");
            }
            columnSet.add(colAlias);
            columnList.add(new Column(colAlias, selectItemExpr.getType(), false, null, selectItemExpr.isNullable(), null, ""));
        }
        InlineView inlineView = this.view != null ? new InlineView(this.view, (List<Column>)columnList) : new InlineView(this.getExplicitAlias(), (List<Column>)columnList);
        TupleDescriptor result = analyzer.getDescTbl().createTupleDescriptor();
        result.setIsMaterialized(false);
        result.setTable(inlineView);
        analyzer.registerInlineViewTupleId(result.getId());
        return result;
    }

    protected void makeOutputNullable(Analyzer analyzer) throws AnalysisException, UserException {
        try {
            this.makeOutputNullableHelper(analyzer, this.sMap);
            this.makeOutputNullableHelper(analyzer, this.baseTblSmap);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected void makeOutputNullableHelper(Analyzer analyzer, ExprSubstitutionMap smap) throws Exception {
        ArrayList rhsSlotRefs = Lists.newArrayList();
        Expr.collectList(smap.getRhs(), SlotRef.class, rhsSlotRefs);
        ExprSubstitutionMap nullSMap = new ExprSubstitutionMap();
        for (SlotRef rhsSlotRef : rhsSlotRefs) {
            nullSMap.put(rhsSlotRef.clone(), NullLiteral.create(rhsSlotRef.getType()));
        }
        for (int i = 0; i < smap.getRhs().size(); ++i) {
            ArrayList params = Lists.newArrayList();
            if (!this.requiresNullWrapping(analyzer, smap.getRhs().get(i), nullSMap)) continue;
            params.add(new TupleIsNullPredicate(this.materializedTupleIds));
            params.add(NullLiteral.create(smap.getRhs().get(i).getType()));
            params.add(smap.getRhs().get(i));
            FunctionCallExpr ifExpr = new FunctionCallExpr("if", (List<Expr>)params);
            ifExpr.analyze(analyzer);
            smap.getRhs().set(i, ifExpr);
        }
    }

    private boolean requiresNullWrapping(Analyzer analyzer, Expr expr, ExprSubstitutionMap nullSMap) throws UserException {
        if (expr.contains(TupleIsNullPredicate.class)) {
            return true;
        }
        return true;
    }

    @Override
    public void rewriteExprs(ExprRewriter rewriter, Analyzer analyzer) throws AnalysisException {
        super.rewriteExprs(rewriter, analyzer);
        this.queryStmt.rewriteExprs(rewriter);
    }

    @Override
    public List<TupleId> getMaterializedTupleIds() {
        Preconditions.checkState((boolean)this.isAnalyzed);
        Preconditions.checkState((this.materializedTupleIds.size() > 0 ? 1 : 0) != 0);
        return this.materializedTupleIds;
    }

    public QueryStmt getViewStmt() {
        return this.queryStmt;
    }

    public void setViewStmt(QueryStmt queryStmt) {
        this.queryStmt = queryStmt;
    }

    public Analyzer getAnalyzer() {
        Preconditions.checkState((boolean)this.isAnalyzed);
        return this.inlineViewAnalyzer;
    }

    public ExprSubstitutionMap getSmap() {
        Preconditions.checkState((boolean)this.isAnalyzed);
        return this.sMap;
    }

    public ExprSubstitutionMap getBaseTblSmap() {
        Preconditions.checkState((boolean)this.isAnalyzed);
        return this.baseTblSmap;
    }

    public boolean isLocalView() {
        return this.view == null || this.view.isLocalView();
    }

    public View getView() {
        return this.view;
    }

    public QueryStmt getQueryStmt() {
        return this.queryStmt;
    }

    @Override
    public String tableNameToSql() {
        if (this.view != null) {
            return super.tableNameToSql();
        }
        String aliasSql = null;
        String alias = this.getExplicitAlias();
        if (alias != null) {
            aliasSql = ToSqlUtils.getIdentSql(alias);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(this.queryStmt.toSql()).append(") ").append(aliasSql);
        return sb.toString();
    }
}

