/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.catalog.Type;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;
import org.apache.doris.thrift.TInfoFunc;

public class InformationFunction
extends Expr {
    private final String funcType;
    private long intValue;
    private String strValue;

    public InformationFunction(String funcType) {
        this.funcType = funcType;
    }

    protected InformationFunction(InformationFunction other) {
        super(other);
        this.funcType = other.funcType;
        this.intValue = other.intValue;
        this.strValue = other.strValue;
    }

    public String getStrValue() {
        return this.strValue;
    }

    public String getIntValue() {
        return String.valueOf(this.intValue);
    }

    public String getFuncType() {
        return this.funcType;
    }

    @Override
    public Expr clone() {
        return new InformationFunction(this);
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        if (this.funcType.equalsIgnoreCase("DATABASE") || this.funcType.equalsIgnoreCase("SCHEMA")) {
            this.type = Type.VARCHAR;
            this.strValue = ClusterNamespace.getNameFromFullName(analyzer.getDefaultDb());
        } else if (this.funcType.equalsIgnoreCase("USER")) {
            this.type = Type.VARCHAR;
            this.strValue = ConnectContext.get().getUserIdentity().toString();
        } else if (this.funcType.equalsIgnoreCase("CURRENT_USER")) {
            this.type = Type.VARCHAR;
            this.strValue = ConnectContext.get().getCurrentUserIdentity().toString();
        } else if (this.funcType.equalsIgnoreCase("CONNECTION_ID")) {
            this.type = Type.BIGINT;
            this.intValue = analyzer.getConnectId();
            this.strValue = "";
        }
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.INFO_FUNC;
        msg.info_func = new TInfoFunc(this.intValue, this.strValue);
    }

    @Override
    public String toSqlImpl() {
        return this.funcType + "()";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InformationFunction)) {
            return false;
        }
        if (!this.funcType.equals(((InformationFunction)obj).getFuncType())) {
            return false;
        }
        return !(this.type.equals(Type.VARCHAR) ? !this.strValue.equals(((InformationFunction)obj).getStrValue()) : this.type.equals(Type.BIGINT) && this.intValue != (long)Integer.parseInt(((InformationFunction)obj).getIntValue()));
    }
}

