/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.List;
import java.util.TreeSet;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.common.AnalysisException;

public class IndexDef {
    private String indexName;
    private boolean ifNotExists;
    private List<String> columns;
    private IndexType indexType;
    private String comment;

    public IndexDef(String indexName, boolean ifNotExists, List<String> columns, IndexType indexType, String comment) {
        this.indexName = indexName;
        this.ifNotExists = ifNotExists;
        this.columns = columns;
        this.indexType = indexType == null ? IndexType.BITMAP : indexType;
        this.comment = columns == null ? "" : comment;
    }

    public void analyze() throws AnalysisException {
        if (this.indexType == IndexType.BITMAP) {
            if (this.columns == null || this.columns.size() != 1) {
                throw new AnalysisException("bitmap index can only apply to a single column.");
            }
            if (Strings.isNullOrEmpty((String)this.indexName)) {
                throw new AnalysisException("index name cannot be blank.");
            }
            if (this.indexName.length() > 64) {
                throw new AnalysisException("index name too long, the index name length at most is 64.");
            }
            TreeSet<String> distinct = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            distinct.addAll(this.columns);
            if (this.columns.size() != distinct.size()) {
                throw new AnalysisException("columns of index has duplicated.");
            }
        }
    }

    public String toSql() {
        return this.toSql(null);
    }

    public String toSql(String tableName) {
        StringBuilder sb = new StringBuilder("INDEX ");
        sb.append(this.indexName);
        if (tableName != null && !tableName.isEmpty()) {
            sb.append(" ON ").append(tableName);
        }
        sb.append(" (");
        boolean first = true;
        for (String col : this.columns) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append("`" + col + "`");
        }
        sb.append(")");
        if (this.indexType != null) {
            sb.append(" USING ").append(this.indexType.toString());
        }
        if (this.comment != null) {
            sb.append(" COMMENT '" + this.comment + "'");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isSetIfNotExists() {
        return this.ifNotExists;
    }

    public void checkColumn(Column column, KeysType keysType) throws AnalysisException {
        if (this.indexType == IndexType.BITMAP) {
            String indexColName = column.getName();
            PrimitiveType colType = column.getDataType();
            if (!(colType.isDateType() || colType.isDecimalV2Type() || colType.isFixedPointType() || colType.isStringType() || colType == PrimitiveType.BOOLEAN)) {
                throw new AnalysisException((Object)((Object)colType) + " is not supported in bitmap index. invalid column: " + indexColName);
            }
            if (keysType == KeysType.AGG_KEYS && !column.isKey()) {
                throw new AnalysisException("BITMAP index only used in columns of DUP_KEYS/UNIQUE_KEYS table or key columns of AGG_KEYS table. invalid column: " + indexColName);
            }
        } else {
            throw new AnalysisException("Unsupported index type: " + (Object)((Object)this.indexType));
        }
    }

    public void checkColumns(List<Column> columns, KeysType keysType) throws AnalysisException {
        if (this.indexType == IndexType.BITMAP) {
            for (Column col : columns) {
                this.checkColumn(col, keysType);
            }
        }
    }

    public static enum IndexType {
        BITMAP;

    }
}

