/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.Predicate;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.Subquery;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.FunctionSet;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarFunction;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Reference;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;
import org.apache.doris.thrift.TExprOpcode;
import org.apache.doris.thrift.TInPredicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InPredicate
extends Predicate {
    private static final Logger LOG = LogManager.getLogger(InPredicate.class);
    private static final String IN_SET_LOOKUP = "in_set_lookup";
    private static final String NOT_IN_SET_LOOKUP = "not_in_set_lookup";
    private static final String IN_ITERATE = "in_iterate";
    private static final String NOT_IN_ITERATE = "not_in_iterate";
    private final boolean isNotIn;
    private static final String IN = "in";
    private static final String NOT_IN = "not_in";
    private static final NullLiteral NULL_LITERAL = new NullLiteral();

    public static void initBuiltins(FunctionSet functionSet) {
        for (Type type : Type.getSupportedTypes()) {
            if (type.isNull() || type.getPrimitiveType() == PrimitiveType.CHAR) continue;
            String typeString = Function.getUdfTypeName(type.getPrimitiveType());
            functionSet.addBuiltinBothScalaAndVectorized(ScalarFunction.createBuiltin(IN_ITERATE, Type.BOOLEAN, Lists.newArrayList((Object[])new Type[]{type, type}), true, "doris::InPredicate::in_iterate", null, null, false));
            functionSet.addBuiltinBothScalaAndVectorized(ScalarFunction.createBuiltin(NOT_IN_ITERATE, Type.BOOLEAN, Lists.newArrayList((Object[])new Type[]{type, type}), true, "doris::InPredicate::not_in_iterate", null, null, false));
            String prepareFn = "doris::InPredicate::set_lookup_prepare_" + typeString;
            String closeFn = "doris::InPredicate::set_lookup_close_" + typeString;
            functionSet.addBuiltin(ScalarFunction.createBuiltin(IN_SET_LOOKUP, Type.BOOLEAN, Lists.newArrayList((Object[])new Type[]{type, type}), true, "doris::InPredicate::in_set_lookup", prepareFn, closeFn, false));
            functionSet.addBuiltin(ScalarFunction.createBuiltin(NOT_IN_SET_LOOKUP, Type.BOOLEAN, Lists.newArrayList((Object[])new Type[]{type, type}), true, "doris::InPredicate::not_in_set_lookup", prepareFn, closeFn, false));
        }
    }

    public InPredicate(Expr compareExpr, List<Expr> inList, boolean isNotIn) {
        this.children.add(compareExpr);
        this.children.addAll(inList);
        this.isNotIn = isNotIn;
    }

    protected InPredicate(InPredicate other) {
        super(other);
        this.isNotIn = other.isNotIn();
    }

    public int getInElementNum() {
        return this.getChildren().size() - 1;
    }

    @Override
    public InPredicate clone() {
        return new InPredicate(this);
    }

    public InPredicate(Expr compareExpr, Expr subquery, boolean isNotIn) {
        Preconditions.checkNotNull((Object)compareExpr);
        Preconditions.checkNotNull((Object)subquery);
        this.children.add(compareExpr);
        this.children.add(subquery);
        this.isNotIn = isNotIn;
    }

    @Override
    public Expr negate() {
        return new InPredicate((Expr)this.getChild(0), this.children.subList(1, this.children.size()), !this.isNotIn);
    }

    public List<Expr> getListChildren() {
        return this.children.subList(1, this.children.size());
    }

    public boolean isNotIn() {
        return this.isNotIn;
    }

    public boolean isLiteralChildren() {
        for (int i = 1; i < this.children.size(); ++i) {
            if (this.children.get(i) instanceof LiteralExpr) continue;
            return false;
        }
        return true;
    }

    @Override
    public void vectorizedAnalyze(Analyzer analyzer) {
        super.vectorizedAnalyze(analyzer);
        PrimitiveType type = ((Expr)this.getChild(0)).getType().getPrimitiveType();
    }

    @Override
    public void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        super.analyzeImpl(analyzer);
        if (this.contains(Subquery.class)) {
            if (this.children.size() != 2 || !(this.getChild(1) instanceof Subquery)) {
                throw new AnalysisException("Unsupported IN predicate with a subquery: " + this.toSql());
            }
            Subquery subquery = (Subquery)this.getChild(1);
            if (!subquery.returnsScalarColumn()) {
                throw new AnalysisException("Subquery must return a single column: " + subquery.toSql());
            }
            List subqueryExprs = subquery.getStatement().getResultExprs();
            Expr compareExpr = (Expr)this.children.get(0);
            Expr subqueryExpr = (Expr)((ArrayList)subqueryExprs).get(0);
            analyzer.getCompatibleType(compareExpr.getType(), compareExpr, subqueryExpr);
        } else {
            analyzer.castAllToCompatibleType(this.children);
            this.vectorizedAnalyze(analyzer);
        }
        boolean allConstant = true;
        for (int i = 1; i < this.children.size(); ++i) {
            if (((Expr)this.children.get(i)).isConstant()) continue;
            allConstant = false;
            break;
        }
        boolean useSetLookup = allConstant;
        Type[] argTypes = new Type[]{((Expr)this.getChild((int)0)).type, ((Expr)this.getChild((int)1)).type};
        if (useSetLookup) {
            this.opcode = this.isNotIn ? TExprOpcode.FILTER_NOT_IN : TExprOpcode.FILTER_IN;
        } else {
            this.fn = this.getBuiltinFunction(analyzer, this.isNotIn ? NOT_IN_ITERATE : IN_ITERATE, argTypes, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
            this.opcode = this.isNotIn ? TExprOpcode.FILTER_NEW_NOT_IN : TExprOpcode.FILTER_NEW_IN;
        }
        Reference<SlotRef> slotRefRef = new Reference<SlotRef>();
        Reference<Integer> idxRef = new Reference<Integer>();
        if (this.isSingleColumnPredicate(slotRefRef, idxRef) && idxRef.getRef() == 0 && slotRefRef.getRef().getNumDistinctValues() > 0L) {
            this.selectivity = (double)(this.getChildren().size() - 1) / (double)slotRefRef.getRef().getNumDistinctValues();
            this.selectivity = Math.max(0.0, Math.min(1.0, this.selectivity));
        } else {
            this.selectivity = 0.1;
        }
    }

    public InPredicate union(InPredicate inPredicate) {
        Preconditions.checkState((boolean)inPredicate.isLiteralChildren());
        Preconditions.checkState((boolean)this.isLiteralChildren());
        Preconditions.checkState((boolean)((Expr)this.getChild(0)).equals(inPredicate.getChild(0)));
        ArrayList<Expr> unionChildren = new ArrayList<Expr>(this.getListChildren());
        unionChildren.removeAll(inPredicate.getListChildren());
        unionChildren.addAll(inPredicate.getListChildren());
        InPredicate union = new InPredicate((Expr)this.getChild(0), unionChildren, this.isNotIn);
        return union;
    }

    public InPredicate intersection(InPredicate inPredicate) {
        Preconditions.checkState((boolean)inPredicate.isLiteralChildren());
        Preconditions.checkState((boolean)this.isLiteralChildren());
        Preconditions.checkState((boolean)((Expr)this.getChild(0)).equals(inPredicate.getChild(0)));
        ArrayList<Expr> intersectChildren = new ArrayList<Expr>(this.getListChildren());
        intersectChildren.retainAll(inPredicate.getListChildren());
        InPredicate intersection = new InPredicate((Expr)this.getChild(0), intersectChildren, this.isNotIn);
        return intersection;
    }

    @Override
    protected void toThrift(TExprNode msg) {
        Preconditions.checkState((!this.contains(Subquery.class) ? 1 : 0) != 0);
        msg.in_predicate = new TInPredicate(this.isNotIn);
        msg.node_type = TExprNodeType.IN_PRED;
        msg.setOpcode(this.opcode);
        msg.setVectorOpcode(this.vectorOpcode);
    }

    @Override
    public String toSqlImpl() {
        StringBuilder strBuilder = new StringBuilder();
        String notStr = this.isNotIn ? "NOT " : "";
        strBuilder.append(((Expr)this.getChild(0)).toSql() + " " + notStr + "IN (");
        for (int i = 1; i < this.children.size(); ++i) {
            strBuilder.append(((Expr)this.getChild(i)).toSql());
            strBuilder.append(i + 1 != this.children.size() ? ", " : "");
        }
        strBuilder.append(")");
        return strBuilder.toString();
    }

    @Override
    public String toString() {
        return this.toSql();
    }

    @Override
    public Expr getResultValue() throws AnalysisException {
        this.recursiveResetChildrenResult();
        Expr leftChildValue = (Expr)this.getChild(0);
        if (!(leftChildValue instanceof LiteralExpr) || !this.isLiteralChildren()) {
            return this;
        }
        if (leftChildValue instanceof NullLiteral) {
            return leftChildValue;
        }
        List inListChildren = this.children.subList(1, this.children.size());
        boolean containsLeftChild = inListChildren.contains(leftChildValue);
        if (containsLeftChild) {
            return new BoolLiteral(!this.isNotIn);
        }
        if (inListChildren.contains(NULL_LITERAL)) {
            return new NullLiteral();
        }
        return new BoolLiteral(this.isNotIn);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            InPredicate expr = (InPredicate)obj;
            if (this.isNotIn == expr.isNotIn) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isNullable() {
        return this.hasNullableChild();
    }
}

