/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import org.apache.doris.analysis.Expr;

public class ImportColumnDesc {
    private String columnName;
    private Expr expr;

    public ImportColumnDesc(ImportColumnDesc other) {
        this.columnName = other.columnName;
        if (other.expr != null) {
            this.expr = other.expr.clone();
        }
    }

    public ImportColumnDesc(String column) {
        this.columnName = column;
    }

    public ImportColumnDesc(String column, Expr expr) {
        this.columnName = column;
        this.expr = expr;
    }

    public static ImportColumnDesc newDeleteSignImportColumnDesc(Expr expr) {
        return new ImportColumnDesc("__DORIS_DELETE_SIGN__", expr);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Expr getExpr() {
        return this.expr;
    }

    public void setExpr(Expr expr) {
        this.expr = expr;
    }

    public boolean isColumn() {
        return this.expr == null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.columnName);
        if (this.expr != null) {
            sb.append("=").append(this.expr.toSql());
        }
        return sb.toString();
    }
}

