/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.qe.ShowResultSetMetaData;

public class HelpStmt
extends ShowStmt {
    private static final ShowResultSetMetaData TOPIC_META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("name", ScalarType.createVarchar(64))).addColumn(new Column("description", ScalarType.createVarchar(1000))).addColumn(new Column("example", ScalarType.createVarchar(1000))).build();
    private static final ShowResultSetMetaData CATEGORY_META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("source_category_name", ScalarType.createVarchar(64))).addColumn(new Column("name", ScalarType.createVarchar(64))).addColumn(new Column("is_it_category", ScalarType.createVarchar(1))).build();
    private static final ShowResultSetMetaData KEYWORD_META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("name", ScalarType.createVarchar(64))).addColumn(new Column("is_it_category", ScalarType.createVarchar(1))).build();
    private String mask;

    public HelpStmt(String mask) {
        this.mask = mask;
    }

    public String getMask() {
        return this.mask;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.mask)) {
            throw new AnalysisException("Help empty info.");
        }
    }

    @Override
    public String toSql() {
        return "HELP " + this.mask;
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        return TOPIC_META_DATA;
    }

    public ShowResultSetMetaData getCategoryMetaData() {
        return CATEGORY_META_DATA;
    }

    public ShowResultSetMetaData getKeywordMetaData() {
        return KEYWORD_META_DATA;
    }
}

