/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.doris.analysis.ColumnDef;
import org.apache.doris.analysis.DistributionDesc;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.DistributionInfo;
import org.apache.doris.catalog.HashDistributionInfo;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.io.Text;

public class HashDistributionDesc
extends DistributionDesc {
    private int numBucket;
    private List<String> distributionColumnNames;

    public HashDistributionDesc() {
        this.type = DistributionInfo.DistributionInfoType.HASH;
        this.distributionColumnNames = Lists.newArrayList();
    }

    public HashDistributionDesc(int numBucket, List<String> distributionColumnNames) {
        this.type = DistributionInfo.DistributionInfoType.HASH;
        this.numBucket = numBucket;
        this.distributionColumnNames = distributionColumnNames;
    }

    public List<String> getDistributionColumnNames() {
        return this.distributionColumnNames;
    }

    public int getBuckets() {
        return this.numBucket;
    }

    @Override
    public void analyze(Set<String> colSet, List<ColumnDef> columnDefs) throws AnalysisException {
        if (this.numBucket <= 0) {
            throw new AnalysisException("Number of hash distribution should be larger than zero.");
        }
        if (this.distributionColumnNames == null || this.distributionColumnNames.size() == 0) {
            throw new AnalysisException("Number of hash column should be larger than zero.");
        }
        TreeSet distColSet = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (String columnName : this.distributionColumnNames) {
            if (!colSet.contains(columnName)) {
                throw new AnalysisException("Distribution column(" + columnName + ") doesn't exist.");
            }
            if (!distColSet.add(columnName)) {
                throw new AnalysisException("Duplicated distribution column " + columnName);
            }
            for (ColumnDef columnDef : columnDefs) {
                if (!columnDef.getName().equals(columnName) || !columnDef.getType().isScalarType(PrimitiveType.STRING)) continue;
                throw new AnalysisException("String Type should not be used in distribution column[" + columnDef.getName() + "].");
            }
        }
    }

    @Override
    public String toSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DISTRIBUTED BY HASH(");
        int i = 0;
        for (String columnName : this.distributionColumnNames) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("`").append(columnName).append("`");
            ++i;
        }
        stringBuilder.append(")\n");
        stringBuilder.append("BUCKETS ").append(this.numBucket);
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public DistributionInfo toDistributionInfo(List<Column> columns) throws DdlException {
        ArrayList distributionColumns = Lists.newArrayList();
        for (String colName : this.distributionColumnNames) {
            boolean find = false;
            for (Column column : columns) {
                if (!column.getName().equalsIgnoreCase(colName)) continue;
                if (!column.isKey() && column.getAggregationType() != AggregateType.NONE) {
                    throw new DdlException("Distribution column[" + colName + "] is not key column");
                }
                if (column.getType().isFloatingPointType()) {
                    throw new DdlException("Floating point type column can not be distribution column");
                }
                distributionColumns.add(column);
                find = true;
                break;
            }
            if (find) continue;
            throw new DdlException("Distribution column[" + colName + "] does not found");
        }
        HashDistributionInfo hashDistributionInfo = new HashDistributionInfo(this.numBucket, distributionColumns);
        return hashDistributionInfo;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.numBucket);
        int count = this.distributionColumnNames.size();
        out.writeInt(count);
        for (String colName : this.distributionColumnNames) {
            Text.writeString((DataOutput)out, (String)colName);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.numBucket = in.readInt();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            this.distributionColumnNames.add(Text.readString((DataInput)in));
        }
    }
}

