/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.GroupByClause;
import org.apache.doris.analysis.GroupingFunctionCallExpr;
import org.apache.doris.analysis.InlineViewRef;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.VirtualSlotRef;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;

public class GroupingInfo {
    public static final String COL_GROUPING_ID = "GROUPING_ID";
    public static final String GROUPING_PREFIX = "GROUPING_PREFIX_";
    private VirtualSlotRef groupingIDSlot;
    private TupleDescriptor virtualTuple;
    private Set<VirtualSlotRef> groupingSlots;
    private List<BitSet> groupingIdList;
    private GroupByClause.GroupingType groupingType;
    private BitSet bitSetAll;

    public GroupingInfo(Analyzer analyzer, GroupByClause groupByClause) throws AnalysisException {
        this.groupingType = groupByClause.getGroupingType();
        this.groupingSlots = new LinkedHashSet<VirtualSlotRef>();
        this.virtualTuple = analyzer.getDescTbl().createTupleDescriptor("VIRTUAL_TUPLE");
        this.groupingIDSlot = new VirtualSlotRef(COL_GROUPING_ID, Type.BIGINT, this.virtualTuple, new ArrayList<Expr>());
        this.groupingIDSlot.analyze(analyzer);
        this.groupingSlots.add(this.groupingIDSlot);
    }

    public Set<VirtualSlotRef> getGroupingSlots() {
        return this.groupingSlots;
    }

    public TupleDescriptor getVirtualTuple() {
        return this.virtualTuple;
    }

    public List<BitSet> getGroupingIdList() {
        return this.groupingIdList;
    }

    public VirtualSlotRef addGroupingSlots(List<Expr> realSlots, Analyzer analyzer) throws AnalysisException {
        String colName = realSlots.stream().map(expr -> expr.toSql()).collect(Collectors.joining("_"));
        colName = GROUPING_PREFIX + colName;
        VirtualSlotRef virtualSlot = new VirtualSlotRef(colName, Type.BIGINT, this.virtualTuple, realSlots);
        virtualSlot.analyze(analyzer);
        if (this.groupingSlots.contains(virtualSlot)) {
            for (VirtualSlotRef vs : this.groupingSlots) {
                if (!vs.equals(virtualSlot)) continue;
                return vs;
            }
        }
        this.groupingSlots.add(virtualSlot);
        return virtualSlot;
    }

    public void buildRepeat(ArrayList<Expr> groupingExprs, List<ArrayList<Expr>> groupingSetList) {
        this.groupingIdList = new ArrayList<BitSet>();
        this.bitSetAll = new BitSet();
        this.bitSetAll.set(0, groupingExprs.size(), true);
        switch (this.groupingType) {
            case CUBE: {
                for (int i = 0; i < 1 << groupingExprs.size(); ++i) {
                    BitSet bitSet = new BitSet();
                    for (int j = 0; j < groupingExprs.size(); ++j) {
                        if ((i & 1 << j) <= 0) continue;
                        bitSet.set(j, true);
                    }
                    this.groupingIdList.add(bitSet);
                }
                break;
            }
            case ROLLUP: {
                for (int i = 0; i <= groupingExprs.size(); ++i) {
                    BitSet bitSet = new BitSet();
                    bitSet.set(0, i);
                    this.groupingIdList.add(bitSet);
                }
                break;
            }
            case GROUPING_SETS: {
                for (ArrayList<Expr> list : groupingSetList) {
                    BitSet bitSet = new BitSet();
                    for (int i = 0; i < groupingExprs.size(); ++i) {
                        bitSet.set(i, list.contains(groupingExprs.get(i)));
                    }
                    if (this.groupingIdList.contains(bitSet)) continue;
                    this.groupingIdList.add(bitSet);
                }
                break;
            }
            default: {
                Preconditions.checkState((boolean)false);
            }
        }
        groupingExprs.addAll(this.groupingSlots);
    }

    public List<List<Long>> genGroupingList(ArrayList<Expr> groupingExprs) throws AnalysisException {
        ArrayList<List<Long>> groupingList = new ArrayList<List<Long>>();
        for (SlotRef slotRef : this.groupingSlots) {
            ArrayList<Long> glist = new ArrayList<Long>();
            for (BitSet bitSet : this.groupingIdList) {
                int i;
                long l = 0L;
                if (slotRef.getColumnName().equalsIgnoreCase(COL_GROUPING_ID)) {
                    BitSet newBitSet = new BitSet();
                    for (i = 0; i < this.bitSetAll.length(); ++i) {
                        newBitSet.set(i, bitSet.get(this.bitSetAll.length() - i - 1));
                    }
                    newBitSet.flip(0, this.bitSetAll.length());
                    newBitSet.and(this.bitSetAll);
                    for (i = 0; i < newBitSet.length(); ++i) {
                        l += newBitSet.get(i) ? 1L << i : 0L;
                    }
                } else {
                    int slotSize = ((VirtualSlotRef)slotRef).getRealSlots().size();
                    for (i = 0; i < slotSize; ++i) {
                        int j = groupingExprs.indexOf(((VirtualSlotRef)slotRef).getRealSlots().get(i));
                        if (j < 0 || j >= bitSet.size()) {
                            throw new AnalysisException("Column " + ((VirtualSlotRef)slotRef).getRealColumnName() + " in GROUP_ID() does not exist in GROUP BY clause.");
                        }
                        l += bitSet.get(j) ? 0L : 1L << slotSize - i - 1;
                    }
                }
                glist.add(l);
            }
            groupingList.add(glist);
        }
        return groupingList;
    }

    public void substituteGroupingFn(List<Expr> exprs, Analyzer analyzer) throws AnalysisException {
        if (this.groupingType == GroupByClause.GroupingType.GROUP_BY) {
            throw new AnalysisException("cannot use GROUPING functions without [grouping sets|rollup|cube] aclause or grouping sets only have one element.");
        }
        ListIterator<Expr> i = exprs.listIterator();
        while (i.hasNext()) {
            Expr expr = i.next();
            this.substituteGroupingFn(expr, analyzer);
        }
    }

    public void substituteGroupingFn(Expr expr, Analyzer analyzer) throws AnalysisException {
        if (expr instanceof GroupingFunctionCallExpr) {
            for (Expr child : expr.getChildren()) {
                InlineViewRef ref;
                int colIndex;
                if (!(child instanceof SlotRef)) {
                    throw new AnalysisException("grouping functions only support column in current version.");
                }
                if (((SlotRef)child).getDesc().getParent().getTable().getType() != Table.TableType.INLINE_VIEW || (colIndex = (ref = (InlineViewRef)((SlotRef)child).getDesc().getParent().getRef()).getColLabels().indexOf(((SlotRef)child).getColumnName())) == -1 || ((ArrayList)ref.getViewStmt().getResultExprs()).get(colIndex) instanceof SlotRef) continue;
                throw new AnalysisException("grouping functions only support column in current version.");
            }
            if (expr.getChildren().size() == 1 && expr.getChild(0) instanceof VirtualSlotRef) {
                return;
            }
            VirtualSlotRef vSlot = this.addGroupingSlots(((GroupingFunctionCallExpr)expr).getRealSlot(), analyzer);
            ((GroupingFunctionCallExpr)expr).resetChild(vSlot);
            expr.analyze(analyzer);
        } else if (expr.getChildren() != null && expr.getChildren().size() > 0) {
            for (Expr child : expr.getChildren()) {
                this.substituteGroupingFn(child, analyzer);
            }
        }
    }
}

