/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.FunctionName;
import org.apache.doris.analysis.FunctionParams;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.VirtualSlotRef;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroupingFunctionCallExpr
extends FunctionCallExpr {
    private static final Logger LOG = LogManager.getLogger(FunctionCallExpr.class);
    private boolean childrenReseted = false;
    private List<Expr> realChildren;

    public GroupingFunctionCallExpr(String functionName, List<Expr> params) {
        super(functionName, params);
        this.childrenReseted = false;
    }

    public GroupingFunctionCallExpr(FunctionName functionName, FunctionParams params) {
        super(functionName, params);
        this.childrenReseted = false;
    }

    public GroupingFunctionCallExpr(GroupingFunctionCallExpr other) {
        super(other);
        this.childrenReseted = other.childrenReseted;
        if (this.childrenReseted) {
            this.realChildren = Expr.cloneList(other.realChildren);
        }
    }

    @Override
    public Expr clone() {
        return new GroupingFunctionCallExpr(this);
    }

    @Override
    public void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        if (this.children.size() < 1) {
            throw new AnalysisException("GROUPING functions required at least one parameters");
        }
        for (Expr expr : this.children) {
            if (!(expr instanceof SlotRef)) continue;
        }
        Type[] childTypes = new Type[]{Type.BIGINT};
        this.fn = this.getBuiltinFunction(analyzer, this.getFnName().getFunction(), childTypes, Function.CompareMode.IS_IDENTICAL);
        this.type = this.fn.getReturnType();
    }

    public void resetChild(VirtualSlotRef virtualSlot) {
        ArrayList<VirtualSlotRef> newChildren = new ArrayList<VirtualSlotRef>();
        newChildren.add(virtualSlot);
        this.realChildren = new ArrayList<Expr>();
        this.realChildren.addAll(this.children);
        this.children = newChildren;
        this.childrenReseted = true;
    }

    @Override
    public Expr reset() {
        if (this.childrenReseted) {
            this.children = new ArrayList();
            this.children.addAll(this.realChildren);
        }
        this.childrenReseted = false;
        this.realChildren = null;
        return super.reset();
    }

    public List<Expr> getRealSlot() {
        if (this.childrenReseted) {
            ArrayList<Expr> result = new ArrayList<Expr>();
            for (Expr expr : this.realChildren) {
                result.add(expr);
            }
            return result;
        }
        if (this.isAnalyzed()) {
            ArrayList<Expr> result = new ArrayList<Expr>();
            for (Expr expr : this.children) {
                result.add(expr);
            }
            return result;
        }
        return null;
    }

    public List<Expr> getRealChildren() {
        return this.realChildren;
    }
}

