/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.doris.analysis.AnalyticExpr;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.ParseNode;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.Subquery;
import org.apache.doris.analysis.VirtualSlotRef;
import org.apache.doris.common.AnalysisException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroupByClause
implements ParseNode {
    private static final Logger LOG = LogManager.getLogger(GroupByClause.class);
    private static final int MAX_GROUPING_SETS_NUM = 64;
    private boolean analyzed_ = false;
    private boolean exprGenerated = false;
    private GroupingType groupingType;
    private ArrayList<Expr> groupingExprs;
    private ArrayList<Expr> oriGroupingExprs;
    private List<ArrayList<Expr>> groupingSetList;

    public GroupByClause(List<ArrayList<Expr>> groupingSetList, GroupingType type) {
        this.groupingType = type;
        this.groupingSetList = groupingSetList;
        Preconditions.checkState((type == GroupingType.GROUPING_SETS ? 1 : 0) != 0);
    }

    public GroupByClause(ArrayList<Expr> groupingExprs, GroupingType type) {
        this.groupingType = type;
        this.oriGroupingExprs = groupingExprs;
        this.groupingExprs = new ArrayList();
        this.groupingExprs.addAll(this.oriGroupingExprs);
        Preconditions.checkState((type != GroupingType.GROUPING_SETS ? 1 : 0) != 0);
    }

    protected GroupByClause(GroupByClause other) {
        this.groupingType = other.groupingType;
        this.groupingExprs = other.groupingExprs != null ? Expr.cloneAndResetList(other.groupingExprs) : null;
        ArrayList<Expr> arrayList = this.oriGroupingExprs = other.oriGroupingExprs != null ? Expr.cloneAndResetList(other.oriGroupingExprs) : null;
        if (other.groupingSetList != null) {
            this.groupingSetList = new ArrayList<ArrayList<Expr>>();
            for (List list : other.groupingSetList) {
                this.groupingSetList.add(Expr.cloneAndResetList(list));
            }
        }
    }

    public List<ArrayList<Expr>> getGroupingSetList() {
        return this.groupingSetList;
    }

    public GroupingType getGroupingType() {
        return this.groupingType;
    }

    public void reset() {
        this.groupingExprs = new ArrayList();
        this.analyzed_ = false;
        this.exprGenerated = false;
        if (this.oriGroupingExprs != null) {
            Expr.resetList(this.oriGroupingExprs);
            this.groupingExprs.addAll(this.oriGroupingExprs);
        }
        if (this.groupingSetList != null) {
            for (List list : this.groupingSetList) {
                for (Expr e : list) {
                    if (e == null) continue;
                    e.reset();
                }
            }
        }
    }

    public List<Expr> getOriGroupingExprs() {
        return this.oriGroupingExprs;
    }

    public void setOriGroupingExprs(ArrayList<Expr> list) {
        this.oriGroupingExprs = list;
    }

    public ArrayList<Expr> getGroupingExprs() {
        if (!this.exprGenerated) {
            try {
                this.genGroupingExprs();
            }
            catch (AnalysisException e) {
                LOG.error("gen grouping expr error:", (Throwable)e);
                return null;
            }
        }
        return this.groupingExprs;
    }

    public void setGroupingExpr(ArrayList<Expr> list) {
        this.groupingExprs = list;
    }

    public void genGroupingExprs() throws AnalysisException {
        LinkedHashSet<Expr> groupingExprSet;
        if (this.exprGenerated) {
            return;
        }
        if (CollectionUtils.isNotEmpty(this.groupingExprs)) {
            groupingExprSet = new LinkedHashSet<Expr>(this.groupingExprs);
            this.groupingExprs.clear();
            this.groupingExprs.addAll(groupingExprSet);
        }
        if (this.groupingType == GroupingType.CUBE || this.groupingType == GroupingType.ROLLUP) {
            if (CollectionUtils.isEmpty(this.groupingExprs)) {
                throw new AnalysisException("The expressions in GROUPING CUBE or ROLLUP can not be empty");
            }
        } else if (this.groupingType == GroupingType.GROUPING_SETS) {
            if (CollectionUtils.isEmpty(this.groupingSetList)) {
                throw new AnalysisException("The expressions in GROUPING SETS can not be empty");
            }
            groupingExprSet = new LinkedHashSet();
            for (ArrayList<Expr> list : this.groupingSetList) {
                groupingExprSet.addAll(list);
            }
            this.groupingExprs = new ArrayList<Expr>(groupingExprSet);
        }
        this.exprGenerated = true;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.analyzed_) {
            return;
        }
        this.genGroupingExprs();
        for (Expr expr : this.groupingExprs) {
            if (!expr.contains(Predicates.instanceOf(Subquery.class))) continue;
            throw new AnalysisException("Subqueries are not supported in the GROUP BY clause.");
        }
        for (Expr groupingExpr : this.groupingExprs) {
            groupingExpr.analyze(analyzer);
            if (groupingExpr.contains(Expr.isAggregatePredicate())) {
                throw new AnalysisException("GROUP BY expression must not contain aggregate functions: " + groupingExpr.toSql());
            }
            if (groupingExpr.contains(AnalyticExpr.class)) {
                throw new AnalysisException("GROUP BY expression must not contain analytic expressions: " + groupingExpr.toSql());
            }
            if (!groupingExpr.type.isOnlyMetricType()) continue;
            throw new AnalysisException("Doris hll and bitmap column must use with specific function, and don't support filter or group by.please run 'help hll' or 'help bitmap' in your mysql client.");
        }
        if (this.isGroupByExtension() && this.groupingExprs != null && this.groupingExprs.size() > 64) {
            throw new AnalysisException("Too many sets in GROUP BY clause, the max grouping sets item is 64");
        }
        this.analyzed_ = true;
    }

    public boolean isGroupByExtension() {
        return this.groupingType != GroupingType.GROUP_BY;
    }

    @Override
    public String toSql() {
        StringBuilder strBuilder = new StringBuilder();
        switch (this.groupingType) {
            case GROUP_BY: {
                if (this.oriGroupingExprs == null) break;
                for (int i = 0; i < this.oriGroupingExprs.size(); ++i) {
                    strBuilder.append(this.oriGroupingExprs.get(i).toSql());
                    strBuilder.append(i + 1 != this.oriGroupingExprs.size() ? ", " : "");
                }
                break;
            }
            case GROUPING_SETS: {
                if (this.groupingSetList == null) break;
                strBuilder.append("GROUPING SETS (");
                boolean first = true;
                for (List list : this.groupingSetList) {
                    if (first) {
                        strBuilder.append("(");
                        first = false;
                    } else {
                        strBuilder.append(", (");
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        strBuilder.append(((Expr)list.get(i)).toSql());
                        strBuilder.append(i + 1 != list.size() ? ", " : "");
                    }
                    strBuilder.append(")");
                }
                strBuilder.append(")");
                break;
            }
            case CUBE: {
                if (this.oriGroupingExprs == null) break;
                strBuilder.append("CUBE (");
                for (int i = 0; i < this.oriGroupingExprs.size(); ++i) {
                    strBuilder.append(this.oriGroupingExprs.get(i).toSql());
                    strBuilder.append(i + 1 != this.oriGroupingExprs.size() ? ", " : "");
                }
                strBuilder.append(")");
                break;
            }
            case ROLLUP: {
                if (this.oriGroupingExprs == null) break;
                strBuilder.append("ROLLUP (");
                for (int i = 0; i < this.oriGroupingExprs.size(); ++i) {
                    strBuilder.append(this.oriGroupingExprs.get(i).toSql());
                    strBuilder.append(i + 1 != this.oriGroupingExprs.size() ? ", " : "");
                }
                strBuilder.append(")");
                break;
            }
        }
        return strBuilder.toString();
    }

    public GroupByClause clone() {
        return new GroupByClause(this);
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.groupingExprs);
    }

    public void substituteGroupingExprs(Set<VirtualSlotRef> groupingSlots, ExprSubstitutionMap smap, Analyzer analyzer) {
        this.groupingExprs = Expr.substituteList(this.groupingExprs, smap, analyzer, true);
        for (VirtualSlotRef vs : groupingSlots) {
            vs.setRealSlots(Optional.ofNullable(Expr.substituteList(vs.getRealSlots(), smap, analyzer, true)).orElse(new ArrayList()).stream().map(e -> (SlotRef)e).collect(Collectors.toList()));
        }
    }

    public static enum GroupingType {
        GROUP_BY,
        GROUPING_SETS,
        ROLLUP,
        CUBE;

    }
}

