/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.ResourcePattern;
import org.apache.doris.analysis.TablePattern;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.AccessPrivilege;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PaloAuth;
import org.apache.doris.mysql.privilege.PaloPrivilege;
import org.apache.doris.mysql.privilege.PrivBitSet;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class GrantStmt
extends DdlStmt {
    private UserIdentity userIdent;
    private String role;
    private TablePattern tblPattern;
    private ResourcePattern resourcePattern;
    private List<PaloPrivilege> privileges;

    public GrantStmt(UserIdentity userIdent, String role, TablePattern tblPattern, List<AccessPrivilege> privileges) {
        this.userIdent = userIdent;
        this.role = role;
        this.tblPattern = tblPattern;
        this.resourcePattern = null;
        PrivBitSet privs = PrivBitSet.of(new PaloPrivilege[0]);
        for (AccessPrivilege accessPrivilege : privileges) {
            privs.or(accessPrivilege.toPaloPrivilege());
        }
        this.privileges = privs.toPrivilegeList();
    }

    public GrantStmt(UserIdentity userIdent, String role, ResourcePattern resourcePattern, List<AccessPrivilege> privileges) {
        this.userIdent = userIdent;
        this.role = role;
        this.tblPattern = null;
        this.resourcePattern = resourcePattern;
        PrivBitSet privs = PrivBitSet.of(new PaloPrivilege[0]);
        for (AccessPrivilege accessPrivilege : privileges) {
            privs.or(accessPrivilege.toPaloPrivilege());
        }
        this.privileges = privs.toPrivilegeList();
    }

    public UserIdentity getUserIdent() {
        return this.userIdent;
    }

    public TablePattern getTblPattern() {
        return this.tblPattern;
    }

    public ResourcePattern getResourcePattern() {
        return this.resourcePattern;
    }

    public boolean hasRole() {
        return !Strings.isNullOrEmpty((String)this.role);
    }

    public String getQualifiedRole() {
        return this.role;
    }

    public List<PaloPrivilege> getPrivileges() {
        return this.privileges;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        if (this.userIdent != null) {
            this.userIdent.analyze(analyzer.getClusterName());
        } else {
            FeNameFormat.checkRoleName(this.role, false, "Can not grant to role");
            this.role = ClusterNamespace.getFullName(analyzer.getClusterName(), this.role);
        }
        if (this.tblPattern != null) {
            this.tblPattern.analyze(analyzer.getClusterName());
        } else {
            if (!Config.enable_spark_load) {
                throw new AnalysisException("GRANT ON RESOURCE is coming soon");
            }
            this.resourcePattern.analyze();
        }
        if (this.privileges == null || this.privileges.isEmpty()) {
            throw new AnalysisException("No privileges in grant statement.");
        }
        if (this.tblPattern != null) {
            GrantStmt.checkPrivileges(analyzer, this.privileges, this.role, this.tblPattern);
        } else {
            GrantStmt.checkPrivileges(analyzer, this.privileges, this.role, this.resourcePattern);
        }
    }

    public static void checkPrivileges(Analyzer analyzer, List<PaloPrivilege> privileges, String role, TablePattern tblPattern) throws AnalysisException {
        if (tblPattern.getPrivLevel() != PaloAuth.PrivLevel.GLOBAL && (privileges.contains((Object)PaloPrivilege.ADMIN_PRIV) || privileges.contains((Object)PaloPrivilege.NODE_PRIV))) {
            throw new AnalysisException("ADMIN_PRIV and NODE_PRIV can only be granted on *.*");
        }
        if (privileges.contains((Object)PaloPrivilege.NODE_PRIV) && !Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.OPERATOR)) {
            throw new AnalysisException("Only the user with NODE_PRIV can grant NODE_PRIV to other user");
        }
        if (role != null) {
            if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.GRANT)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "GRANT");
            }
        } else if (tblPattern.getPrivLevel() == PaloAuth.PrivLevel.GLOBAL) {
            if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.GRANT)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "GRANT");
            }
        } else if (tblPattern.getPrivLevel() == PaloAuth.PrivLevel.DATABASE) {
            if (!Catalog.getCurrentCatalog().getAuth().checkDbPriv(ConnectContext.get(), tblPattern.getQualifiedDb(), PrivPredicate.GRANT)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "GRANT");
            }
        } else if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), tblPattern.getQualifiedDb(), tblPattern.getTbl(), PrivPredicate.GRANT)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "GRANT");
        }
    }

    public static void checkPrivileges(Analyzer analyzer, List<PaloPrivilege> privileges, String role, ResourcePattern resourcePattern) throws AnalysisException {
        if (privileges.contains((Object)PaloPrivilege.NODE_PRIV)) {
            throw new AnalysisException("Can not grant NODE_PRIV to any other users or roles");
        }
        if (resourcePattern.getPrivLevel() != PaloAuth.PrivLevel.GLOBAL && privileges.contains((Object)PaloPrivilege.ADMIN_PRIV)) {
            throw new AnalysisException("ADMIN_PRIV privilege can only be granted on resource *");
        }
        if (role != null) {
            if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.GRANT)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "GRANT");
            }
        } else if (resourcePattern.getPrivLevel() == PaloAuth.PrivLevel.GLOBAL) {
            if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.GRANT)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "GRANT");
            }
        } else if (!Catalog.getCurrentCatalog().getAuth().checkResourcePriv(ConnectContext.get(), resourcePattern.getResourceName(), PrivPredicate.GRANT)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "GRANT");
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("GRANT ").append(Joiner.on((String)", ").join(this.privileges));
        if (this.tblPattern != null) {
            sb.append(" ON ").append(this.tblPattern).append(" TO ");
        } else {
            sb.append(" ON RESOURCE '").append(this.resourcePattern).append("' TO ");
        }
        if (!Strings.isNullOrEmpty((String)this.role)) {
            sb.append(" ROLE '").append(this.role).append("'");
        } else {
            sb.append(this.userIdent);
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

