/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.doris.analysis.Expr;
import org.apache.doris.common.io.Writable;

public class FunctionParams
implements Writable {
    private boolean isStar;
    private List<Expr> exprs;
    private boolean isDistinct;

    public FunctionParams(boolean isDistinct, List<Expr> exprs) {
        this.isStar = false;
        this.isDistinct = isDistinct;
        this.exprs = exprs;
    }

    public FunctionParams(List<Expr> exprs) {
        this(false, exprs);
    }

    private FunctionParams() {
        this.exprs = null;
        this.isStar = true;
        this.isDistinct = false;
    }

    public static FunctionParams createStarParam() {
        return new FunctionParams();
    }

    public boolean isStar() {
        return this.isStar;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public List<Expr> exprs() {
        return this.exprs;
    }

    public void setIsDistinct(boolean v) {
        this.isDistinct = v;
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.isStar);
        out.writeBoolean(this.isDistinct);
        if (this.exprs != null) {
            out.writeBoolean(true);
            out.writeInt(this.exprs.size());
            for (Expr expr : this.exprs) {
                Expr.writeTo(expr, out);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.isStar = in.readBoolean();
        this.isDistinct = in.readBoolean();
        if (in.readBoolean()) {
            this.exprs = Lists.newArrayList();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.exprs.add(Expr.readIn(in));
            }
        }
    }

    public static FunctionParams read(DataInput in) throws IOException {
        FunctionParams params = new FunctionParams();
        params.readFields(in);
        return params;
    }

    public int hashCode() {
        int result = 31 * Boolean.hashCode(this.isStar) + Boolean.hashCode(this.isDistinct);
        if (this.exprs != null) {
            for (Expr expr : this.exprs) {
                result = 31 * result + Objects.hashCode(expr);
            }
        }
        return result;
    }
}

