/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.thrift.TFunctionName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FunctionName
implements Writable {
    private static final Logger LOG = LogManager.getLogger(FunctionName.class);
    private String db_;
    private String fn_;

    private FunctionName() {
    }

    public FunctionName(String db, String fn) {
        this.db_ = db;
        this.fn_ = fn.toLowerCase();
        if (this.db_ != null) {
            this.db_ = this.db_.toLowerCase();
        }
    }

    public FunctionName(String fn) {
        this.db_ = null;
        this.fn_ = fn.toLowerCase();
    }

    public FunctionName(TFunctionName thriftName) {
        this.db_ = thriftName.db_name.toLowerCase();
        this.fn_ = thriftName.function_name.toLowerCase();
    }

    public static FunctionName createBuiltinName(String fn) {
        FunctionName name = new FunctionName(fn);
        name.fn_ = fn;
        return name;
    }

    public static FunctionName fromThrift(TFunctionName fnName) {
        return new FunctionName(fnName.getDbName(), fnName.getFunctionName());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FunctionName)) {
            return false;
        }
        FunctionName o = (FunctionName)obj;
        if ((this.db_ == null || o.db_ == null) && this.db_ != o.db_) {
            if (this.db_ == null && o.db_ != null) {
                return false;
            }
            if (this.db_ != null && o.db_ == null) {
                return false;
            }
            if (!this.db_.equalsIgnoreCase(o.db_)) {
                return false;
            }
        }
        return this.fn_.equalsIgnoreCase(o.fn_);
    }

    public String getDb() {
        return this.db_;
    }

    public void setDb(String db) {
        this.db_ = db;
    }

    public String getFunction() {
        return this.fn_;
    }

    public boolean isFullyQualified() {
        return this.db_ != null;
    }

    public String toString() {
        if (this.db_ == null) {
            return this.fn_;
        }
        return this.db_ + "." + this.fn_;
    }

    public String analyzeDb(Analyzer analyzer) throws AnalysisException {
        String db = this.db_;
        if (db == null) {
            db = analyzer.getDefaultDb();
        } else {
            if (Strings.isNullOrEmpty((String)analyzer.getClusterName())) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NAME_NULL, new Object[0]);
            }
            db = ClusterNamespace.getFullName(analyzer.getClusterName(), db);
        }
        return db;
    }

    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.fn_.length() == 0) {
            throw new AnalysisException("Function name can not be empty.");
        }
        for (int i = 0; i < this.fn_.length(); ++i) {
            if (this.isValidCharacter(this.fn_.charAt(i))) continue;
            throw new AnalysisException("Function names must be all alphanumeric or underscore. Invalid name: " + this.fn_);
        }
        if (Character.isDigit(this.fn_.charAt(0))) {
            throw new AnalysisException("Function cannot start with a digit: " + this.fn_);
        }
        if (this.db_ == null) {
            this.db_ = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)this.db_)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            if (Strings.isNullOrEmpty((String)analyzer.getClusterName())) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NAME_NULL, new Object[0]);
            }
            this.db_ = ClusterNamespace.getFullName(analyzer.getClusterName(), this.db_);
        }
    }

    private boolean isValidCharacter(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public TFunctionName toThrift() {
        TFunctionName name = new TFunctionName(this.fn_);
        name.setDbName(this.db_);
        name.setFunctionName(this.fn_);
        return name;
    }

    public void write(DataOutput out) throws IOException {
        if (this.db_ != null) {
            out.writeBoolean(true);
            Text.writeString((DataOutput)out, (String)this.db_);
        } else {
            out.writeBoolean(false);
        }
        Text.writeString((DataOutput)out, (String)this.fn_);
    }

    public void readFields(DataInput in) throws IOException {
        if (in.readBoolean()) {
            this.db_ = Text.readString((DataInput)in);
        }
        this.fn_ = Text.readString((DataInput)in);
    }

    public static FunctionName read(DataInput in) throws IOException {
        FunctionName functionName = new FunctionName();
        functionName.readFields(in);
        return functionName;
    }

    public int hashCode() {
        return 31 * Objects.hashCode(this.db_) + Objects.hashCode(this.fn_);
    }
}

