/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BuiltinAggregateFunction;
import org.apache.doris.analysis.DateLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionName;
import org.apache.doris.analysis.FunctionParams;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.AggregateFunction;
import org.apache.doris.catalog.AliasFunction;
import org.apache.doris.catalog.ArrayType;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.ScalarFunction;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.util.VectorizedUtil;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.thrift.TAggregateExpr;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FunctionCallExpr
extends Expr {
    private static final Logger LOG = LogManager.getLogger(FunctionCallExpr.class);
    private FunctionName fnName;
    private FunctionParams fnParams;
    private boolean isAnalyticFnCall = false;
    private boolean isTableFnCall = false;
    private boolean isMergeAggFn;
    private static final ImmutableSet<String> STDDEV_FUNCTION_SET = new ImmutableSortedSet.Builder(String.CASE_INSENSITIVE_ORDER).add((Object)"stddev").add((Object)"stddev_val").add((Object)"stddev_samp").add((Object)"variance").add((Object)"variance_pop").add((Object)"variance_pop").add((Object)"var_samp").add((Object)"var_pop").build();
    private static final String ELEMENT_EXTRACT_FN_NAME = "%element_extract%";
    private int originChildSize;
    private Expr originStmtFnExpr;
    private boolean isRewrote = false;

    public void setIsAnalyticFnCall(boolean v) {
        this.isAnalyticFnCall = v;
    }

    public void setTableFnCall(boolean tableFnCall) {
        this.isTableFnCall = tableFnCall;
    }

    @Override
    public Function getFn() {
        return this.fn;
    }

    public FunctionName getFnName() {
        return this.fnName;
    }

    public FunctionParams getFnParams() {
        return this.fnParams;
    }

    private FunctionCallExpr() {
    }

    public FunctionCallExpr(String functionName, List<Expr> params) {
        this(new FunctionName(functionName), new FunctionParams(false, params));
    }

    public FunctionCallExpr(FunctionName fnName, List<Expr> params) {
        this(fnName, new FunctionParams(false, params));
    }

    public FunctionCallExpr(String fnName, FunctionParams params) {
        this(new FunctionName(fnName), params, false);
    }

    public FunctionCallExpr(FunctionName fnName, FunctionParams params) {
        this(fnName, params, false);
    }

    private FunctionCallExpr(FunctionName fnName, FunctionParams params, boolean isMergeAggFn) {
        this.fnName = fnName;
        this.fnParams = params;
        this.isMergeAggFn = isMergeAggFn;
        if (params.exprs() != null) {
            this.children.addAll(params.exprs());
        }
        this.originChildSize = this.children.size();
    }

    public FunctionCallExpr(FunctionCallExpr e, FunctionParams params) {
        Preconditions.checkState((boolean)e.isAnalyzed);
        Preconditions.checkState((e.isAggregateFunction() || e.isAnalyticFnCall ? 1 : 0) != 0);
        this.fnName = e.fnName;
        this.isAnalyticFnCall = e.isAnalyticFnCall;
        this.fnParams = params;
        this.fn = e.fn;
        this.isMergeAggFn = e.isMergeAggFn;
        if (params.exprs() != null) {
            this.children.addAll(params.exprs());
        }
    }

    protected FunctionCallExpr(FunctionCallExpr other) {
        super(other);
        this.fnName = other.fnName;
        this.isAnalyticFnCall = other.isAnalyticFnCall;
        if (other.fnParams.isStar()) {
            Preconditions.checkState((boolean)this.children.isEmpty());
            this.fnParams = FunctionParams.createStarParam();
        } else {
            this.fnParams = new FunctionParams(other.fnParams.isDistinct(), this.children);
        }
        this.isMergeAggFn = other.isMergeAggFn;
        this.fn = other.fn;
        this.isTableFnCall = other.isTableFnCall;
    }

    public String parseJsonDataType(boolean useKeyCheck) throws AnalysisException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.children.size(); ++i) {
            Type type = ((Expr)this.getChild(i)).getType();
            if (type.isNull()) {
                if ((i & 1) == 0 && useKeyCheck) {
                    throw new AnalysisException("json_object key can't be NULL: " + this.toSql());
                }
                this.children.set(i, new StringLiteral("NULL"));
                sb.append("0");
                continue;
            }
            if (type.isBoolean()) {
                sb.append("1");
                continue;
            }
            if (type.isFixedPointType()) {
                sb.append("2");
                continue;
            }
            if (type.isFloatingPointType() || type.isDecimalV2()) {
                sb.append("3");
                continue;
            }
            if (type.isTime()) {
                sb.append("4");
                continue;
            }
            sb.append("5");
        }
        return sb.toString();
    }

    public boolean isMergeAggFn() {
        return this.isMergeAggFn;
    }

    @Override
    public Expr clone() {
        return new FunctionCallExpr(this);
    }

    @Override
    public void resetAnalysisState() {
        this.isAnalyzed = false;
        if (!this.isMergeAggFn) {
            this.fn = null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        FunctionCallExpr o = (FunctionCallExpr)obj;
        return this.fnName.equals(o.fnName) && this.fnParams.isDistinct() == o.fnParams.isDistinct() && this.fnParams.isStar() == o.fnParams.isStar();
    }

    private String paramsToSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (this.fnParams.isStar()) {
            sb.append("*");
        }
        if (this.fnParams.isDistinct()) {
            sb.append("DISTINCT ");
        }
        int len = this.children.size();
        ArrayList result = Lists.newArrayList();
        if (this.fnName.getFunction().equalsIgnoreCase("json_array") || this.fnName.getFunction().equalsIgnoreCase("json_object")) {
            --len;
        }
        if (this.fnName.getFunction().equalsIgnoreCase("aes_decrypt") || this.fnName.getFunction().equalsIgnoreCase("aes_encrypt") || this.fnName.getFunction().equalsIgnoreCase("sm4_decrypt") || this.fnName.getFunction().equalsIgnoreCase("sm4_encrypt")) {
            --len;
        }
        for (int i = 0; i < len; ++i) {
            if (i == 1 && (this.fnName.getFunction().equalsIgnoreCase("aes_decrypt") || this.fnName.getFunction().equalsIgnoreCase("aes_encrypt") || this.fnName.getFunction().equalsIgnoreCase("sm4_decrypt") || this.fnName.getFunction().equalsIgnoreCase("sm4_encrypt"))) {
                result.add("'***'");
                continue;
            }
            result.add(((Expr)this.children.get(i)).toSql());
        }
        sb.append(Joiner.on((String)", ").join((Iterable)result)).append(")");
        return sb.toString();
    }

    @Override
    public String toSqlImpl() {
        Expr expr = this.originStmtFnExpr != null ? this.originStmtFnExpr : this;
        StringBuilder sb = new StringBuilder();
        sb.append(expr.fnName);
        sb.append(this.paramsToSql());
        if (this.fnName.getFunction().equalsIgnoreCase("json_quote") || this.fnName.getFunction().equalsIgnoreCase("json_array") || this.fnName.getFunction().equalsIgnoreCase("json_object")) {
            return this.forJSON(sb.toString());
        }
        return sb.toString();
    }

    @Override
    public String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.fnName).add("isStar", this.fnParams.isStar()).add("isDistinct", this.fnParams.isDistinct()).addValue((Object)super.debugString()).toString();
    }

    public FunctionParams getParams() {
        return this.fnParams;
    }

    public boolean isScalarFunction() {
        Preconditions.checkState((this.fn != null ? 1 : 0) != 0);
        return this.fn instanceof ScalarFunction;
    }

    public boolean isAggregateFunction() {
        Preconditions.checkState((this.fn != null ? 1 : 0) != 0);
        return this.fn instanceof AggregateFunction && !this.isAnalyticFnCall;
    }

    public boolean isBuiltin() {
        Preconditions.checkState((this.fn != null ? 1 : 0) != 0);
        return this.fn instanceof BuiltinAggregateFunction && !this.isAnalyticFnCall;
    }

    public boolean returnsNonNullOnEmpty() {
        Preconditions.checkNotNull((Object)this.fn);
        return this.fn instanceof AggregateFunction && ((AggregateFunction)this.fn).returnsNonNullOnEmpty();
    }

    public boolean isDistinct() {
        Preconditions.checkState((boolean)this.isAggregateFunction());
        return this.fnParams.isDistinct();
    }

    public boolean isCountStar() {
        if (this.fnName.getFunction().equalsIgnoreCase("count")) {
            if (this.fnParams.isStar()) {
                return true;
            }
            if (this.fnParams.exprs() == null || this.fnParams.exprs().isEmpty()) {
                return true;
            }
            for (Expr expr : this.fnParams.exprs()) {
                if (!expr.isConstant()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCountDistinctBitmapOrHLL() {
        if (!this.fnParams.isDistinct()) {
            return false;
        }
        if (!this.fnName.getFunction().equalsIgnoreCase("count")) {
            return false;
        }
        if (this.children.size() != 1) {
            return false;
        }
        Type type = ((Expr)this.getChild(0)).getType();
        return type.isBitmapType() || type.isHllType();
    }

    @Override
    protected void toThrift(TExprNode msg) {
        if (this.isAggregate() || this.isAnalyticFnCall) {
            msg.node_type = TExprNodeType.AGG_EXPR;
            if (!this.isAnalyticFnCall) {
                msg.setAggExpr(new TAggregateExpr(this.isMergeAggFn));
            }
        } else {
            msg.node_type = TExprNodeType.FUNCTION_CALL;
        }
    }

    private void analyzeBuiltinAggFunction(Analyzer analyzer) throws AnalysisException {
        if (this.fnParams.isStar() && !this.fnName.getFunction().equalsIgnoreCase("count")) {
            throw new AnalysisException("'*' can only be used in conjunction with COUNT: " + this.toSql());
        }
        if (this.fnName.getFunction().equalsIgnoreCase("count")) {
            if (this.children.size() > 1 && !this.fnParams.isDistinct()) {
                throw new AnalysisException("COUNT must have DISTINCT for multiple arguments: " + this.toSql());
            }
            for (Expr child : this.children) {
                if (!child.type.isOnlyMetricType()) continue;
                throw new AnalysisException("Doris hll and bitmap column must use with specific function, and don't support filter or group by.please run 'help hll' or 'help bitmap' in your mysql client.");
            }
            return;
        }
        if (this.fnName.getFunction().equalsIgnoreCase("json_array")) {
            String res = this.parseJsonDataType(false);
            if (this.children.size() == this.originChildSize) {
                this.children.add(new StringLiteral(res));
            }
            return;
        }
        if (this.fnName.getFunction().equalsIgnoreCase("json_object")) {
            if ((this.children.size() & 1) == 1 && this.originChildSize == this.children.size()) {
                throw new AnalysisException("json_object can't be odd parameters, need even parameters: " + this.toSql());
            }
            String res = this.parseJsonDataType(true);
            if (this.children.size() == this.originChildSize) {
                this.children.add(new StringLiteral(res));
            }
            return;
        }
        if (this.fnName.getFunction().equalsIgnoreCase("group_concat")) {
            if (this.children.size() > 2 || this.children.isEmpty()) {
                throw new AnalysisException("group_concat requires one or two parameters: " + this.toSql());
            }
            if (this.fnParams.isDistinct()) {
                throw new AnalysisException("group_concat does not support DISTINCT");
            }
            Expr arg0 = (Expr)this.getChild(0);
            if (!arg0.type.isStringType() && !arg0.type.isNull()) {
                throw new AnalysisException("group_concat requires first parameter to be of type STRING: " + this.toSql());
            }
            if (this.children.size() == 2) {
                Expr arg1 = (Expr)this.getChild(1);
                if (!arg1.type.isStringType() && !arg1.type.isNull()) {
                    throw new AnalysisException("group_concat requires second parameter to be of type STRING: " + this.toSql());
                }
            }
            return;
        }
        if (this.fnName.getFunction().equalsIgnoreCase("lag") || this.fnName.getFunction().equalsIgnoreCase("lead")) {
            if (!this.isAnalyticFnCall) {
                throw new AnalysisException(this.fnName.getFunction() + " only used in analytic function");
            }
            if (this.children.size() > 2) {
                if (!((Expr)this.getChild(1)).isConstant() || !((Expr)this.getChild(2)).isConstant()) {
                    throw new AnalysisException("The default parameter (parameter 2 or parameter 3) of LEAD/LAG must be a constant: " + this.toSql());
                }
                this.uncheckedCastChild(Type.BIGINT, 1);
                if (!((Expr)this.getChild((int)2)).type.matchesType(((Expr)this.getChild((int)0)).type) && !((Expr)this.getChild((int)2)).type.matchesType(Type.NULL)) {
                    this.uncheckedCastChild(((Expr)this.getChild((int)0)).type, 2);
                }
            }
            return;
        }
        if ((this.fnName.getFunction().equalsIgnoreCase("dense_rank") || this.fnName.getFunction().equalsIgnoreCase("rank") || this.fnName.getFunction().equalsIgnoreCase("row_number") || this.fnName.getFunction().equalsIgnoreCase("first_value") || this.fnName.getFunction().equalsIgnoreCase("last_value") || this.fnName.getFunction().equalsIgnoreCase("first_value_rewrite")) && !this.isAnalyticFnCall) {
            throw new AnalysisException(this.fnName.getFunction() + " only used in analytic function");
        }
        Expr arg = (Expr)this.getChild(0);
        if (arg == null) {
            return;
        }
        if ((this.fnName.getFunction().equalsIgnoreCase("sum") || this.fnName.getFunction().equalsIgnoreCase("avg")) && (!arg.type.isNumericType() && !arg.type.isNull() || arg.type.isOnlyMetricType())) {
            throw new AnalysisException(this.fnName.getFunction() + " requires a numeric parameter: " + this.toSql());
        }
        if (this.fnName.getFunction().equalsIgnoreCase("sum_distinct") && (!arg.type.isNumericType() && !arg.type.isNull() || arg.type.isOnlyMetricType())) {
            throw new AnalysisException("SUM_DISTINCT requires a numeric parameter: " + this.toSql());
        }
        if ((this.fnName.getFunction().equalsIgnoreCase("min") || this.fnName.getFunction().equalsIgnoreCase("max") || this.fnName.getFunction().equalsIgnoreCase("DISTINCT_PC") || this.fnName.getFunction().equalsIgnoreCase("DISTINCT_PCSA") || this.fnName.getFunction().equalsIgnoreCase("NDV")) && arg.type.isOnlyMetricType()) {
            throw new AnalysisException("Doris hll and bitmap column must use with specific function, and don't support filter or group by.please run 'help hll' or 'help bitmap' in your mysql client.");
        }
        if (this.fnName.getFunction().equalsIgnoreCase("bitmap_union_int") && !arg.type.isInteger32Type()) {
            throw new AnalysisException("BITMAP_UNION_INT params only support TINYINT or SMALLINT or INT");
        }
        if (this.fnName.getFunction().equalsIgnoreCase("intersect_count")) {
            if (this.children.size() <= 2) {
                throw new AnalysisException("intersect_count(bitmap_column, column_to_filter, filter_values) function requires at least three parameters");
            }
            Type inputType = ((Expr)this.getChild(0)).getType();
            if (!inputType.isBitmapType()) {
                throw new AnalysisException("intersect_count function first argument should be of BITMAP type, but was " + inputType);
            }
            for (int i = 2; i < this.children.size(); ++i) {
                if (((Expr)this.getChild(i)).isConstant()) continue;
                throw new AnalysisException("intersect_count function filter_values arg must be constant");
            }
            return;
        }
        if (this.fnName.getFunction().equalsIgnoreCase("bitmap_count") || this.fnName.getFunction().equalsIgnoreCase("bitmap_union") || this.fnName.getFunction().equalsIgnoreCase("bitmap_union_count") || this.fnName.getFunction().equalsIgnoreCase("bitmap_intersect")) {
            if (this.children.size() != 1) {
                throw new AnalysisException(this.fnName + " function could only have one child");
            }
            Type inputType = ((Expr)this.getChild(0)).getType();
            if (!inputType.isBitmapType()) {
                throw new AnalysisException(this.fnName + " function's argument should be of BITMAP type, but was " + inputType);
            }
            return;
        }
        if ((this.fnName.getFunction().equalsIgnoreCase("HLL_UNION_AGG") || this.fnName.getFunction().equalsIgnoreCase("HLL_CARDINALITY") || this.fnName.getFunction().equalsIgnoreCase("HLL_RAW_AGG")) && !arg.type.isHllType()) {
            throw new AnalysisException("HLL_UNION_AGG, HLL_RAW_AGG and HLL_CARDINALITY's params must be hll column");
        }
        if (this.fnName.getFunction().equalsIgnoreCase("min") || this.fnName.getFunction().equalsIgnoreCase("max")) {
            this.fnParams.setIsDistinct(false);
        } else if (this.fnName.getFunction().equalsIgnoreCase("DISTINCT_PC") || this.fnName.getFunction().equalsIgnoreCase("DISTINCT_PCSA") || this.fnName.getFunction().equalsIgnoreCase("NDV") || this.fnName.getFunction().equalsIgnoreCase("HLL_UNION_AGG")) {
            this.fnParams.setIsDistinct(false);
        }
        if (this.fnName.getFunction().equalsIgnoreCase("percentile")) {
            if (this.children.size() != 2) {
                throw new AnalysisException("percentile(expr, DOUBLE) requires two parameters");
            }
            if (!((Expr)this.getChild(1)).isConstant()) {
                throw new AnalysisException("percentile requires second parameter must be a constant : " + this.toSql());
            }
        }
        if (this.fnName.getFunction().equalsIgnoreCase("percentile_approx")) {
            if (this.children.size() != 2 && this.children.size() != 3) {
                throw new AnalysisException("percentile_approx(expr, DOUBLE [, B]) requires two or three parameters");
            }
            if (!((Expr)this.getChild(1)).isConstant()) {
                throw new AnalysisException("percentile_approx requires second parameter must be a constant : " + this.toSql());
            }
            if (this.children.size() == 3 && !((Expr)this.getChild(2)).isConstant()) {
                throw new AnalysisException("percentile_approx requires the third parameter must be a constant : " + this.toSql());
            }
        }
        if (this.fnName.getFunction().equalsIgnoreCase("topn")) {
            Expr e;
            if (this.children.size() != 2 && this.children.size() != 3) {
                throw new AnalysisException("topn(expr, INT [, B]) requires two or three parameters");
            }
            if (!((Expr)this.getChild(1)).isConstant() || !((Expr)this.getChild(1)).getType().isIntegerType()) {
                throw new AnalysisException("topn requires second parameter must be a constant Integer Type: " + this.toSql());
            }
            if (((Expr)this.getChild(1)).getType() != ScalarType.INT) {
                e = ((Expr)this.getChild(1)).castTo(ScalarType.INT);
                this.setChild(1, e);
            }
            if (this.children.size() == 3) {
                if (!((Expr)this.getChild(2)).isConstant() || !((Expr)this.getChild(2)).getType().isIntegerType()) {
                    throw new AnalysisException("topn requires the third parameter must be a constant Integer Type: " + this.toSql());
                }
                if (((Expr)this.getChild(2)).getType() != ScalarType.INT) {
                    e = ((Expr)this.getChild(2)).castTo(ScalarType.INT);
                    this.setChild(2, e);
                }
            }
        }
        if ((this.fnName.getFunction().equalsIgnoreCase("aes_decrypt") || this.fnName.getFunction().equalsIgnoreCase("aes_encrypt") || this.fnName.getFunction().equalsIgnoreCase("sm4_decrypt") || this.fnName.getFunction().equalsIgnoreCase("sm4_encrypt")) && this.children.size() == 3) {
            String blockEncryptionMode = "";
            HashSet<String> aesModes = new HashSet<String>(Arrays.asList("AES_128_ECB", "AES_192_ECB", "AES_256_ECB", "AES_128_CBC", "AES_192_CBC", "AES_256_CBC", "AES_128_CFB", "AES_192_CFB", "AES_256_CFB", "AES_128_CFB1", "AES_192_CFB1", "AES_256_CFB1", "AES_128_CFB8", "AES_192_CFB8", "AES_256_CFB8", "AES_128_CFB128", "AES_192_CFB128", "AES_256_CFB128", "AES_128_CTR", "AES_192_CTR", "AES_256_CTR", "AES_128_OFB", "AES_192_OFB", "AES_256_OFB"));
            HashSet<String> sm4Modes = new HashSet<String>(Arrays.asList("SM4_128_ECB", "SM4_128_CBC", "SM4_128_CFB128", "SM4_128_OFB", "SM4_128_CTR"));
            if (ConnectContext.get() != null) {
                blockEncryptionMode = ConnectContext.get().getSessionVariable().getBlockEncryptionMode();
                if (this.fnName.getFunction().equalsIgnoreCase("aes_decrypt") || this.fnName.getFunction().equalsIgnoreCase("aes_encrypt")) {
                    if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{blockEncryptionMode})) {
                        blockEncryptionMode = "AES_128_ECB";
                    }
                    if (!aesModes.contains(blockEncryptionMode.toUpperCase())) {
                        throw new AnalysisException("session variable block_encryption_mode is invalid with aes");
                    }
                }
                if (this.fnName.getFunction().equalsIgnoreCase("sm4_decrypt") || this.fnName.getFunction().equalsIgnoreCase("sm4_encrypt")) {
                    if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{blockEncryptionMode})) {
                        blockEncryptionMode = "SM4_128_ECB";
                    }
                    if (!sm4Modes.contains(blockEncryptionMode.toUpperCase())) {
                        throw new AnalysisException("session variable block_encryption_mode is invalid with sm4");
                    }
                }
            }
            this.children.add(new StringLiteral(blockEncryptionMode));
        }
    }

    protected String getFunctionNotFoundError(Type[] argTypes) {
        if (this.fnParams.isStar()) {
            return "'*' can only be used in conjunction with COUNT";
        }
        if (this.fnName.getFunction().equalsIgnoreCase("count") && !this.fnParams.isDistinct() && argTypes.length > 1) {
            return "COUNT must have DISTINCT for multiple arguments: " + this.toSql();
        }
        if (this.fnName.getFunction().equalsIgnoreCase("sum")) {
            return "SUM requires a numeric parameter: " + this.toSql();
        }
        if (this.fnName.getFunction().equalsIgnoreCase("avg")) {
            return "AVG requires a numeric or timestamp parameter: " + this.toSql();
        }
        Object[] argTypesSql = new String[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypesSql[i] = argTypes[i].toSql();
        }
        return String.format("No matching function with signature: %s(%s).", this.fnName, this.fnParams.isStar() ? "*" : Joiner.on((String)", ").join(argTypesSql));
    }

    public void analyzeImplForDefaultValue() throws AnalysisException {
        this.fn = this.getBuiltinFunction(null, this.fnName.getFunction(), new Type[0], Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        this.type = this.fn.getReturnType();
        for (int i = 0; i < this.children.size(); ++i) {
            if (!((Expr)this.getChild(i)).getType().isNull()) continue;
            this.uncheckedCastChild(Type.BOOLEAN, i);
        }
    }

    @Override
    public void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        Expr child1Result;
        Type[] args;
        if (this.isMergeAggFn) {
            AggregateFunction aggFn = (AggregateFunction)this.fn;
            Preconditions.checkNotNull((Object)aggFn);
            Type intermediateType = aggFn.getIntermediateType();
            if (intermediateType == null) {
                intermediateType = this.type;
            }
            return;
        }
        if (this.fnName.getFunction().equals("count") && this.fnParams.isDistinct()) {
            this.fn = this.getBuiltinFunction(analyzer, this.fnName.getFunction(), new Type[0], Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
            this.type = this.fn.getReturnType();
            for (int i = 0; i < this.children.size(); ++i) {
                if (!((Expr)this.getChild(i)).getType().isNull()) continue;
                this.uncheckedCastChild(Type.BOOLEAN, i);
            }
            return;
        }
        Type[] argTypes = new Type[this.children.size()];
        for (int i = 0; i < this.children.size(); ++i) {
            ((Expr)this.children.get(i)).analyze(analyzer);
            argTypes[i] = ((Expr)this.children.get(i)).getType();
        }
        this.analyzeBuiltinAggFunction(analyzer);
        if (this.fnName.getFunction().equalsIgnoreCase("sum")) {
            if (this.children.isEmpty()) {
                throw new AnalysisException("The " + this.fnName + " function must has one input param");
            }
            Type type = ((Expr)this.getChild((int)0)).type;
            if (!VectorizedUtil.isVectorized()) {
                type = ((Expr)this.getChild((int)0)).type.getMaxResolutionType();
            }
            this.fn = this.getBuiltinFunction(analyzer, this.fnName.getFunction(), new Type[]{type}, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        } else if (this.fnName.getFunction().equalsIgnoreCase("count_distinct")) {
            Type compatibleType = ((Expr)this.children.get(0)).getType();
            for (int i = 1; i < this.children.size(); ++i) {
                Type type = ((Expr)this.children.get(i)).getType();
                if (!(compatibleType = Type.getAssignmentCompatibleType(compatibleType, type, true)).isInvalid()) continue;
                compatibleType = Type.VARCHAR;
                break;
            }
            this.fn = this.getBuiltinFunction(analyzer, this.fnName.getFunction(), new Type[]{compatibleType}, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        } else if (this.fnName.getFunction().equalsIgnoreCase("window_funnel")) {
            int i;
            if (this.fnParams.exprs() == null || this.fnParams.exprs().size() < 4) {
                throw new AnalysisException("The " + this.fnName + " function must have at least four params");
            }
            if (!((Expr)this.children.get((int)0)).type.isIntegerType()) {
                throw new AnalysisException("The window params of " + this.fnName + " function must be integer");
            }
            if (!((Expr)this.children.get((int)1)).type.isStringType()) {
                throw new AnalysisException("The mode params of " + this.fnName + " function must be integer");
            }
            if (!((Expr)this.children.get((int)2)).type.isDateType()) {
                throw new AnalysisException("The 3rd param of " + this.fnName + " function must be DATE or DATETIME");
            }
            Type[] childTypes = new Type[this.children.size()];
            for (i = 0; i < 3; ++i) {
                childTypes[i] = ((Expr)this.children.get((int)i)).type;
            }
            for (i = 3; i < this.children.size(); ++i) {
                if (((Expr)this.children.get((int)i)).type != Type.BOOLEAN) {
                    throw new AnalysisException("The 4th and subsequent params of " + this.fnName + " function must be boolean");
                }
                childTypes[i] = ((Expr)this.children.get((int)i)).type;
            }
            this.fn = this.getBuiltinFunction(analyzer, this.fnName.getFunction(), childTypes, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        } else if (this.fnName.getFunction().equalsIgnoreCase("if")) {
            Type assignmentCompatibleType;
            Type[] childTypes = this.collectChildReturnTypes();
            childTypes[1] = assignmentCompatibleType = ScalarType.getAssignmentCompatibleType(childTypes[1], childTypes[2], true);
            childTypes[2] = assignmentCompatibleType;
            this.fn = this.getBuiltinFunction(analyzer, this.fnName.getFunction(), childTypes, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        } else if (this.isTableFnCall) {
            Type[] childTypes = this.collectChildReturnTypes();
            this.fn = this.getTableFunction(this.fnName.getFunction(), childTypes, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
            if (this.fn == null) {
                throw new AnalysisException(this.getFunctionNotFoundError(argTypes));
            }
        } else {
            if (Strings.isNullOrEmpty((String)this.fnName.getDb())) {
                Type[] childTypes = this.collectChildReturnTypes();
                this.fn = this.getBuiltinFunction(analyzer, this.fnName.getFunction(), childTypes, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
            }
            if (this.fn == null) {
                if (!analyzer.isUDFAllowed()) {
                    throw new AnalysisException("Does not support non-builtin functions, or function does not exist: " + this.toSqlImpl());
                }
                String dbName = this.fnName.analyzeDb(analyzer);
                if (!Strings.isNullOrEmpty((String)dbName)) {
                    Database db;
                    if (!Catalog.getCurrentCatalog().getAuth().checkDbPriv(ConnectContext.get(), dbName, PrivPredicate.SELECT)) {
                        ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "SELECT");
                    }
                    if ((db = Catalog.getCurrentCatalog().getDbNullable(dbName)) != null) {
                        Function searchDesc = new Function(this.fnName, Arrays.asList(this.collectChildReturnTypes()), Type.INVALID, false);
                        this.fn = db.getFunction(searchDesc, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
                    }
                }
            }
        }
        if (this.fn == null) {
            LOG.warn("fn {} not exists", (Object)this.toSqlImpl());
            throw new AnalysisException(this.getFunctionNotFoundError(this.collectChildReturnTypes()));
        }
        if ((this.fnName.getFunction().equalsIgnoreCase("from_unixtime") || this.fnName.getFunction().equalsIgnoreCase("date_format")) && this.children.size() > 1) {
            StringLiteral fmtLiteral = (StringLiteral)this.children.get(1);
            if (fmtLiteral.getStringValue().equals("yyyyMMdd")) {
                this.children.set(1, new StringLiteral("%Y%m%d"));
            } else if (fmtLiteral.getStringValue().equals("yyyy-MM-dd")) {
                this.children.set(1, new StringLiteral("%Y-%m-%d"));
            } else if (fmtLiteral.getStringValue().equals("yyyy-MM-dd HH:mm:ss")) {
                this.children.set(1, new StringLiteral("%Y-%m-%d %H:%i:%s"));
            }
        }
        if (this.fn.getFunctionName().getFunction().equals("timediff")) {
            this.fn.getReturnType().getPrimitiveType().setTimeType();
        }
        if (this.isAggregateFunction()) {
            String functionName = this.fnName.getFunction();
            if (Expr.containsAggregate(this.children)) {
                throw new AnalysisException("aggregate function cannot contain aggregate parameters: " + this.toSql());
            }
            if (STDDEV_FUNCTION_SET.contains((Object)functionName) && argTypes[0].isDateType()) {
                throw new AnalysisException("Stddev/variance function do not support Date/Datetime type");
            }
            if (functionName.equalsIgnoreCase("multi_distinct_sum") && argTypes[0].isDateType()) {
                throw new AnalysisException("Sum in multi distinct functions do not support Date/Datetime type");
            }
        } else {
            if (this.fnParams.isStar()) {
                throw new AnalysisException("Cannot pass '*' to scalar function.");
            }
            if (this.fnParams.isDistinct()) {
                throw new AnalysisException("Cannot pass 'DISTINCT' to scalar function.");
            }
        }
        if (!this.fn.getFunctionName().getFunction().equals(ELEMENT_EXTRACT_FN_NAME) && (args = this.fn.getArgs()).length > 0) {
            for (int i = 0; i < argTypes.length; ++i) {
                int ix = Math.min(args.length - 1, i);
                if (argTypes[i].matchesType(args[ix]) || argTypes[i].isDateType() && args[ix].isDateType()) continue;
                this.uncheckedCastChild(args[ix], i);
            }
        }
        this.type = this.fn.getFunctionName().getFunction().equals("str_to_date") ? ((child1Result = ((Expr)this.getChild(1)).getResultValue()) instanceof StringLiteral ? (DateLiteral.hasTimePart(((StringLiteral)child1Result).getStringValue()) ? Type.DATETIME : Type.DATE) : Type.DATETIME) : this.fn.getReturnType();
        this.analyzeNestedFunction();
    }

    private void analyzeNestedFunction() {
        if ("array".equalsIgnoreCase(this.fnName.getFunction()) && this.children.size() > 0) {
            this.type = new ArrayType(((Expr)this.children.get(0)).getType());
        }
    }

    public Expr rewriteExpr() throws AnalysisException {
        if (this.isRewrote) {
            return this;
        }
        FunctionCallExpr retExpr = (FunctionCallExpr)this.clone();
        retExpr.originStmtFnExpr = this.clone();
        FunctionCallExpr oriExpr = (FunctionCallExpr)((AliasFunction)retExpr.fn).getOriginFunction().clone();
        retExpr.fnName = oriExpr.getFnName();
        List<Expr> inputParamsExprs = retExpr.fnParams.exprs();
        List<String> parameters = ((AliasFunction)retExpr.fn).getParameters();
        Preconditions.checkArgument((inputParamsExprs.size() == parameters.size() ? 1 : 0) != 0, (Object)("Alias function [" + retExpr.fn.getFunctionName().getFunction() + "] args number is not equal to it's definition"));
        List<Expr> oriParamsExprs = oriExpr.fnParams.exprs();
        for (int i = 0; i < oriParamsExprs.size(); ++i) {
            Expr expr = this.replaceParams(parameters, inputParamsExprs, oriParamsExprs.get(i));
            oriParamsExprs.set(i, expr);
        }
        retExpr.fnParams = new FunctionParams(oriExpr.fnParams.isDistinct(), oriParamsExprs);
        retExpr.children.clear();
        retExpr.children.addAll(oriExpr.getChildren());
        retExpr.isRewrote = true;
        return retExpr;
    }

    private Expr replaceParams(List<String> parameters, List<Expr> inputParamsExprs, Expr oriExpr) throws AnalysisException {
        String columnName;
        int index;
        for (int i = 0; i < oriExpr.getChildren().size(); ++i) {
            Expr retExpr = this.replaceParams(parameters, inputParamsExprs, (Expr)oriExpr.getChild(i));
            oriExpr.setChild(i, retExpr);
        }
        if (oriExpr instanceof SlotRef && (index = parameters.indexOf(columnName = ((SlotRef)oriExpr).getColumnName())) != -1) {
            return inputParamsExprs.get(index);
        }
        if (oriExpr instanceof LiteralExpr && oriExpr.getType().equals(Type.INVALID)) {
            oriExpr = LiteralExpr.init((LiteralExpr)oriExpr);
        }
        return oriExpr;
    }

    @Override
    public boolean isVectorized() {
        return false;
    }

    public static FunctionCallExpr createMergeAggCall(FunctionCallExpr agg, List<Expr> params) {
        Preconditions.checkState((boolean)agg.isAnalyzed);
        Preconditions.checkState((boolean)agg.isAggregateFunction());
        FunctionCallExpr result = new FunctionCallExpr(agg.fnName, new FunctionParams(false, params), true);
        result.fn = agg.fn;
        result.type = agg.type;
        return result;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.fnName.write(out);
        this.fnParams.write(out);
        out.writeBoolean(this.isAnalyticFnCall);
        out.writeBoolean(this.isMergeAggFn);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.fnName = FunctionName.read(in);
        this.fnParams = FunctionParams.read(in);
        if (this.fnParams.exprs() != null) {
            this.children.addAll(this.fnParams.exprs());
        }
        this.isAnalyticFnCall = in.readBoolean();
        this.isMergeAggFn = in.readBoolean();
    }

    public static FunctionCallExpr read(DataInput in) throws IOException {
        FunctionCallExpr func = new FunctionCallExpr();
        func.readFields(in);
        return func;
    }

    @Override
    public boolean supportSerializable() {
        for (Expr child : this.children) {
            if (child.supportSerializable()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isConstantImpl() {
        if (this.fn instanceof AggregateFunction || this.fn == null) {
            return false;
        }
        String fnName = this.fnName.getFunction();
        if (FunctionCallExpr.isNondeterministicBuiltinFnName(fnName)) {
            return false;
        }
        if (fnName.equalsIgnoreCase("sleep")) {
            return false;
        }
        return super.isConstantImpl();
    }

    private static boolean isNondeterministicBuiltinFnName(String fnName) {
        return fnName.equalsIgnoreCase("rand") || fnName.equalsIgnoreCase("random") || fnName.equalsIgnoreCase("uuid");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode((Object[])new Object[]{this.opcode});
        result = 31 * result + Objects.hashCode((Object[])new Object[]{this.fnName});
        result = 31 * result + Objects.hashCode((Object[])new Object[]{this.fnParams});
        return result;
    }

    public String forJSON(String str) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(str);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\"') {
                result.append("\\\"");
            } else if (character == '\\') {
                result.append("\\\\");
            } else if (character == '/') {
                result.append("\\/");
            } else if (character == '\b') {
                result.append("\\b");
            } else if (character == '\f') {
                result.append("\\f");
            } else if (character == '\n') {
                result.append("\\n");
            } else if (character == '\r') {
                result.append("\\r");
            } else if (character == '\t') {
                result.append("\\t");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }
}

