/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.TypeDef;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;

public class FunctionArgsDef {
    private final List<TypeDef> argTypeDefs;
    private final boolean isVariadic;
    private Type[] argTypes;

    public FunctionArgsDef(List<TypeDef> argTypeDefs, boolean isVariadic) {
        this.argTypeDefs = argTypeDefs;
        this.isVariadic = isVariadic;
    }

    public Type[] getArgTypes() {
        return this.argTypes;
    }

    public boolean isVariadic() {
        return this.isVariadic;
    }

    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.argTypes = new Type[this.argTypeDefs.size()];
        int i = 0;
        for (TypeDef typeDef : this.argTypeDefs) {
            typeDef.analyze(analyzer);
            this.argTypes[i++] = typeDef.getType();
        }
    }

    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int i = 0;
        for (TypeDef typeDef : this.argTypeDefs) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(typeDef.toString());
            ++i;
        }
        if (this.isVariadic) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("...");
        }
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

