/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BaseTableRef;
import org.apache.doris.analysis.InlineViewRef;
import org.apache.doris.analysis.ParseNode;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.Table;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.VecNotImplException;
import org.apache.doris.common.util.VectorizedUtil;

public class FromClause
implements ParseNode,
Iterable<TableRef> {
    private final ArrayList<TableRef> tableRefs_;
    private boolean analyzed_ = false;
    private boolean needToSql = false;

    public FromClause(List<TableRef> tableRefs) {
        this.tableRefs_ = Lists.newArrayList(tableRefs);
        for (int i = 1; i < this.tableRefs_.size(); ++i) {
            this.tableRefs_.get(i).setLeftTblRef(this.tableRefs_.get(i - 1));
        }
    }

    public FromClause() {
        this.tableRefs_ = Lists.newArrayList();
    }

    public List<TableRef> getTableRefs() {
        return this.tableRefs_;
    }

    public void setNeedToSql(boolean needToSql) {
        this.needToSql = needToSql;
    }

    private void checkFromHiveTable(Analyzer analyzer) throws AnalysisException {
        for (TableRef tblRef : this.tableRefs_) {
            if (!(tblRef instanceof BaseTableRef)) continue;
            TableName tableName = tblRef.getName();
            String dbName = tableName.getDb();
            dbName = Strings.isNullOrEmpty((String)dbName) ? analyzer.getDefaultDb() : ClusterNamespace.getFullName(analyzer.getClusterName(), tblRef.getName().getDb());
            if (Strings.isNullOrEmpty((String)dbName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
            Database db = analyzer.getCatalog().getDbOrAnalysisException(dbName);
            String tblName = tableName.getTbl();
            Table table = db.getTableOrAnalysisException(tblName);
        }
    }

    private void sortTableRefKeepSequenceOfOnClause() {
        Collections.sort(this.tableRefs_, new Comparator<TableRef>(){

            @Override
            public int compare(TableRef tableref1, TableRef tableref2) {
                int i1 = 0;
                int i2 = 0;
                if (tableref1.getOnClause() != null || tableref1.getUsingClause() != null) {
                    i1 = 1;
                }
                if (tableref2.getOnClause() != null || tableref2.getUsingClause() != null) {
                    i2 = 1;
                }
                return i1 - i2;
            }
        });
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        if (this.analyzed_) {
            return;
        }
        if (this.tableRefs_.isEmpty()) {
            this.analyzed_ = true;
            return;
        }
        if (analyzer.enableStarJoinReorder()) {
            this.sortTableRefKeepSequenceOfOnClause();
        }
        TableRef leftTblRef = null;
        for (int i = 0; i < this.tableRefs_.size(); ++i) {
            TableRef tblRef = this.tableRefs_.get(i);
            tblRef = analyzer.resolveTableRef(tblRef);
            this.tableRefs_.set(i, (TableRef)Preconditions.checkNotNull((Object)tblRef));
            tblRef.setLeftTblRef(leftTblRef);
            if (tblRef instanceof InlineViewRef) {
                ((InlineViewRef)tblRef).setNeedToSql(this.needToSql);
            }
            tblRef.analyze(analyzer);
            leftTblRef = tblRef;
        }
        this.checkExternalTable(analyzer);
        this.changeTblRefToNullable(analyzer);
        this.checkFromHiveTable(analyzer);
        this.analyzed_ = true;
    }

    private void checkExternalTable(Analyzer analyzer) throws UserException {
        for (TableRef tblRef : this.tableRefs_) {
            if (!(tblRef instanceof BaseTableRef)) continue;
            TableName tableName = tblRef.getName();
            String dbName = tableName.getDb();
            dbName = Strings.isNullOrEmpty((String)dbName) ? analyzer.getDefaultDb() : ClusterNamespace.getFullName(analyzer.getClusterName(), tblRef.getName().getDb());
            if (Strings.isNullOrEmpty((String)dbName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
            Database db = analyzer.getCatalog().getDbOrAnalysisException(dbName);
            String tblName = tableName.getTbl();
            Table table = db.getTableOrAnalysisException(tblName);
            if (!VectorizedUtil.isVectorized() || table.getType() != Table.TableType.BROKER && table.getType() != Table.TableType.HIVE && table.getType() != Table.TableType.ICEBERG) continue;
            throw new VecNotImplException("Not support table type " + (Object)((Object)table.getType()) + " in vec engine");
        }
    }

    private void changeTblRefToNullable(Analyzer analyzer) {
        for (TableRef tableRef : this.tableRefs_) {
            InlineViewRef inlineViewRef;
            if (!(tableRef instanceof InlineViewRef) || !analyzer.isOuterJoined((inlineViewRef = (InlineViewRef)tableRef).getId())) continue;
            for (SlotDescriptor slotDescriptor : inlineViewRef.getDesc().getSlots()) {
                slotDescriptor.setIsNullable(true);
            }
        }
    }

    public FromClause clone() {
        ArrayList clone = Lists.newArrayList();
        for (TableRef tblRef : this.tableRefs_) {
            clone.add(tblRef.clone());
        }
        return new FromClause(clone);
    }

    public void reset() {
        for (int i = 0; i < this.size(); ++i) {
            TableRef origTblRef = this.get(i);
            this.get(i).reset();
        }
        this.analyzed_ = false;
    }

    @Override
    public String toSql() {
        StringBuilder builder = new StringBuilder();
        if (!this.tableRefs_.isEmpty()) {
            builder.append(" FROM");
            for (int i = 0; i < this.tableRefs_.size(); ++i) {
                builder.append(" " + this.tableRefs_.get(i).toSql());
            }
        }
        return builder.toString();
    }

    public boolean isEmpty() {
        return this.tableRefs_.isEmpty();
    }

    @Override
    public Iterator<TableRef> iterator() {
        return this.tableRefs_.iterator();
    }

    public int size() {
        return this.tableRefs_.size();
    }

    public TableRef get(int i) {
        return this.tableRefs_.get(i);
    }

    public void set(int i, TableRef tableRef) {
        this.tableRefs_.set(i, tableRef);
    }

    public void add(TableRef t) {
        this.tableRefs_.add(t);
    }

    public void addAll(List<TableRef> t) {
        this.tableRefs_.addAll(t);
    }

    public void clear() {
        this.tableRefs_.clear();
    }
}

