/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.doris.analysis.DecimalLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.NotImplementedException;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;
import org.apache.doris.thrift.TFloatLiteral;

public class FloatLiteral
extends LiteralExpr {
    private double value;

    public FloatLiteral() {
    }

    public FloatLiteral(Double value) {
        this.init(value);
    }

    public FloatLiteral(Double value, Type type) {
        this.value = value;
        this.type = type;
        this.analysisDone();
    }

    public FloatLiteral(String value) throws AnalysisException {
        Double floatValue = null;
        try {
            floatValue = new Double(value);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid floating-point literal: " + value, e);
        }
        this.init(floatValue);
    }

    protected FloatLiteral(FloatLiteral other) {
        super(other);
        this.value = other.value;
    }

    @Override
    public Expr clone() {
        return new FloatLiteral(this);
    }

    @Override
    public ByteBuffer getHashValue(PrimitiveType type) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        switch (type) {
            case TINYINT: {
                buffer.put((byte)this.value);
                break;
            }
            case SMALLINT: {
                buffer.putShort((short)this.value);
                break;
            }
            case INT: {
                buffer.putInt((int)this.value);
                break;
            }
            case BIGINT: {
                buffer.putLong((long)this.value);
                break;
            }
            default: {
                return super.getHashValue(type);
            }
        }
        buffer.flip();
        return buffer;
    }

    private void init(Double value) {
        this.value = value;
        float fvalue = value.floatValue();
        this.type = (double)fvalue == this.value ? Type.FLOAT : Type.DOUBLE;
    }

    @Override
    public boolean isMinValue() {
        return false;
    }

    @Override
    public int compareLiteral(LiteralExpr expr) {
        if (expr instanceof NullLiteral) {
            return 1;
        }
        return Double.compare(this.value, expr.getDoubleValue());
    }

    @Override
    public String toSqlImpl() {
        return this.getStringValue();
    }

    @Override
    public String getStringValue() {
        if (this.type.equals(Type.TIME)) {
            return this.timeStrFromFloat(this.value);
        }
        return Double.toString(this.value);
    }

    @Override
    public long getLongValue() {
        return (long)this.value;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.FLOAT_LITERAL;
        msg.float_literal = new TFloatLiteral(this.value);
    }

    public double getValue() {
        return this.value;
    }

    @Override
    protected Expr uncheckedCastTo(Type targetType) throws AnalysisException {
        if (!targetType.isFloatingPointType() && !targetType.isDecimalV2()) {
            return super.uncheckedCastTo(targetType);
        }
        if (targetType.isFloatingPointType()) {
            if (!this.type.equals(targetType)) {
                FloatLiteral floatLiteral = new FloatLiteral(this);
                floatLiteral.setType(targetType);
                return floatLiteral;
            }
            return this;
        }
        if (targetType.isDecimalV2()) {
            return new DecimalLiteral(new BigDecimal(this.value));
        }
        return this;
    }

    @Override
    public void swapSign() throws NotImplementedException {
        this.value = -this.value;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeDouble(this.value);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.value = in.readDouble();
    }

    public static FloatLiteral read(DataInput in) throws IOException {
        FloatLiteral literal = new FloatLiteral();
        literal.readFields(in);
        return literal;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Double.hashCode(this.value);
    }

    private String timeStrFromFloat(double time) {
        String timeStr = "";
        if (time < 0.0) {
            timeStr = timeStr + "-";
            time = -time;
        }
        int hour = (int)(time / 60.0 / 60.0);
        int minute = (int)(time / 60.0) % 60;
        int second = (int)time % 60;
        return "'" + timeStr + String.format("%02d:%02d:%02d", hour, minute, second) + "'";
    }
}

