/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.doris.analysis.ArithmeticExpr;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.DateLiteral;
import org.apache.doris.analysis.DecimalLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FloatLiteral;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.analysis.SysVariableDesc;
import org.apache.doris.analysis.TimestampArithmeticExpr;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.rewrite.FEFunction;
import org.apache.doris.rewrite.FEFunctionList;
import org.apache.doris.rewrite.FEFunctions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum ExpressionFunctions {
    INSTANCE;

    private static final Logger LOG;
    private ImmutableMultimap<String, FEFunctionInvoker> functions;

    private ExpressionFunctions() {
        this.registerFunctions();
    }

    public Expr evalExpr(Expr constExpr) {
        for (Object child : constExpr.getChildren()) {
            if (child instanceof LiteralExpr || child instanceof SysVariableDesc) continue;
            return constExpr;
        }
        if (constExpr instanceof ArithmeticExpr || constExpr instanceof FunctionCallExpr || constExpr instanceof TimestampArithmeticExpr) {
            Function fn = constExpr.getFn();
            Preconditions.checkNotNull((Object)fn, (Object)"Expr's fn can't be null.");
            if ((fn.getNullableMode() == Function.NullableMode.DEPEND_ON_ARGUMENT || Catalog.getCurrentCatalog().isNullResultWithOneNullParamFunction(fn.getFunctionName().getFunction())) && !fn.isUdf()) {
                for (Type[] e : constExpr.getChildren()) {
                    if (!(e instanceof NullLiteral)) continue;
                    return new NullLiteral();
                }
            }
            if (Catalog.getCurrentCatalog().isNondeterministicFunction(fn.getFunctionName().getFunction()) && ConnectContext.get() != null && ConnectContext.get().notEvalNondeterministicFunction()) {
                return constExpr;
            }
            ArrayList<ScalarType> argTypes = new ArrayList<ScalarType>();
            for (Type type : fn.getArgs()) {
                argTypes.add((ScalarType)type);
            }
            FEFunctionSignature signature = new FEFunctionSignature(fn.functionName(), argTypes.toArray(new ScalarType[argTypes.size()]), fn.getReturnType());
            FEFunctionInvoker invoker = this.getFunction(signature);
            if (invoker != null) {
                try {
                    return invoker.invoke(constExpr.getChildrenWithoutCast());
                }
                catch (AnalysisException e) {
                    LOG.debug("failed to invoke", (Throwable)e);
                    return constExpr;
                }
            }
        } else if (constExpr instanceof SysVariableDesc) {
            return ((SysVariableDesc)constExpr).getLiteralExpr();
        }
        return constExpr;
    }

    private FEFunctionInvoker getFunction(FEFunctionSignature signature) {
        ImmutableCollection functionInvokers = this.functions.get((Object)signature.getName());
        if (functionInvokers == null) {
            return null;
        }
        for (FEFunctionInvoker invoker : functionInvokers) {
            Object[] argTypes2;
            Object[] argTypes1;
            if (!invoker.getSignature().returnType.equals(signature.getReturnType()) || !Arrays.equals(argTypes1 = invoker.getSignature().getArgTypes(), argTypes2 = signature.getArgTypes())) continue;
            return invoker;
        }
        return null;
    }

    private synchronized void registerFunctions() {
        if (this.functions != null) {
            return;
        }
        ImmutableMultimap.Builder mapBuilder = new ImmutableMultimap.Builder();
        Class<FEFunctions> clazz = FEFunctions.class;
        for (Method method : clazz.getDeclaredMethods()) {
            FEFunctionList annotationList = method.getAnnotation(FEFunctionList.class);
            if (annotationList != null) {
                for (FEFunction f : annotationList.value()) {
                    this.registerFEFunction((ImmutableMultimap.Builder<String, FEFunctionInvoker>)mapBuilder, method, f);
                }
            }
            this.registerFEFunction((ImmutableMultimap.Builder<String, FEFunctionInvoker>)mapBuilder, method, method.getAnnotation(FEFunction.class));
        }
        this.functions = mapBuilder.build();
    }

    private void registerFEFunction(ImmutableMultimap.Builder<String, FEFunctionInvoker> mapBuilder, Method method, FEFunction annotation) {
        if (annotation != null) {
            String name = annotation.name();
            Type returnType = Type.fromPrimitiveType(PrimitiveType.valueOf(annotation.returnType()));
            ArrayList<ScalarType> argTypes = new ArrayList<ScalarType>();
            for (String type : annotation.argTypes()) {
                argTypes.add(ScalarType.createType(type));
            }
            FEFunctionSignature signature = new FEFunctionSignature(name, argTypes.toArray(new ScalarType[argTypes.size()]), returnType);
            mapBuilder.put((Object)name, (Object)new FEFunctionInvoker(method, signature));
        }
    }

    static {
        LOG = LogManager.getLogger(ExpressionFunctions.class);
    }

    public static class FEFunctionSignature {
        private final String name;
        private final ScalarType[] argTypes;
        private final Type returnType;

        public FEFunctionSignature(String name, ScalarType[] argTypes, Type returnType) {
            this.name = name;
            this.argTypes = argTypes;
            this.returnType = returnType;
        }

        public ScalarType[] getArgTypes() {
            return this.argTypes;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("FEFunctionSignature. name: ").append(this.name).append(", return: ").append(this.returnType);
            sb.append(", args: ").append(Joiner.on((String)",").join((Object[])this.argTypes));
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FEFunctionSignature signature = (FEFunctionSignature)o;
            return Objects.equals(this.name, signature.name) && Arrays.equals(this.argTypes, signature.argTypes) && Objects.equals(this.returnType, signature.returnType);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.argTypes, this.returnType);
        }
    }

    public static class FEFunctionInvoker {
        private final Method method;
        private final FEFunctionSignature signature;

        public FEFunctionInvoker(Method method, FEFunctionSignature signature) {
            this.method = method;
            this.signature = signature;
        }

        public Method getMethod() {
            return this.method;
        }

        public FEFunctionSignature getSignature() {
            return this.signature;
        }

        public LiteralExpr invoke(List<Expr> args) throws AnalysisException {
            List<Object> invokeArgs = this.createInvokeArgs(args);
            try {
                return (LiteralExpr)this.method.invoke(null, invokeArgs.toArray());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new AnalysisException(e.getLocalizedMessage());
            }
        }

        private List<Object> createInvokeArgs(List<Expr> args) throws AnalysisException {
            ArrayList invokeArgs = Lists.newArrayList();
            for (int typeIndex = 0; typeIndex < this.method.getParameterTypes().length; ++typeIndex) {
                Class<?> argType = this.method.getParameterTypes()[typeIndex];
                if (argType.isArray()) {
                    Preconditions.checkArgument((this.method.getParameterTypes().length == typeIndex + 1 ? 1 : 0) != 0);
                    ArrayList variableLengthExprs = Lists.newArrayList();
                    for (int variableLengthArgIndex = typeIndex; variableLengthArgIndex < args.size(); ++variableLengthArgIndex) {
                        variableLengthExprs.add(args.get(variableLengthArgIndex));
                    }
                    LiteralExpr[] variableLengthArgs = this.createVariableLengthArgs(variableLengthExprs, typeIndex);
                    invokeArgs.add(variableLengthArgs);
                    continue;
                }
                invokeArgs.add(args.get(typeIndex));
            }
            return invokeArgs;
        }

        private LiteralExpr[] createVariableLengthArgs(List<Expr> args, int typeIndex) throws AnalysisException {
            LiteralExpr[] exprs;
            HashSet classSet = Sets.newHashSet();
            for (Expr e2 : args) {
                classSet.add(e2.getClass());
            }
            if (classSet.size() > 1) {
                throw new AnalysisException("Function's args doesn't match.");
            }
            ScalarType argType = this.signature.getArgTypes()[typeIndex];
            if (argType.isStringType()) {
                exprs = new StringLiteral[args.size()];
            } else if (argType.isFixedPointType()) {
                exprs = new IntLiteral[args.size()];
            } else if (argType.isDateType()) {
                exprs = new DateLiteral[args.size()];
            } else if (argType.isDecimalV2()) {
                exprs = new DecimalLiteral[args.size()];
            } else if (argType.isFloatingPointType()) {
                exprs = new FloatLiteral[args.size()];
            } else if (argType.isBoolean()) {
                exprs = new BoolLiteral[args.size()];
            } else {
                throw new IllegalArgumentException("Doris doesn't support type:" + argType);
            }
            long size = args.stream().filter(e -> e instanceof NullLiteral).count();
            if ((long)args.size() == size) {
                exprs = new NullLiteral[args.size()];
            }
            args.toArray(exprs);
            return exprs;
        }
    }
}

