/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.common.AnalysisException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExprSubstitutionMap {
    private static final Logger LOG = LoggerFactory.getLogger(ExprSubstitutionMap.class);
    private boolean checkAnalyzed_ = true;
    private List<Expr> lhs_;
    private List<Expr> rhs_;

    public ExprSubstitutionMap() {
        this(Lists.newArrayList(), Lists.newArrayList());
    }

    public ExprSubstitutionMap(boolean checkAnalyzed) {
        this(Lists.newArrayList(), Lists.newArrayList());
        this.checkAnalyzed_ = checkAnalyzed;
    }

    public ExprSubstitutionMap(List<Expr> lhs, List<Expr> rhs) {
        this.lhs_ = lhs;
        this.rhs_ = rhs;
    }

    public void put(Expr lhsExpr, Expr rhsExpr) {
        Preconditions.checkState((!this.checkAnalyzed_ || rhsExpr.isAnalyzed() ? 1 : 0) != 0, (Object)"Rhs expr must be analyzed.");
        this.lhs_.add(lhsExpr);
        this.rhs_.add(rhsExpr);
    }

    public Expr get(Expr lhsExpr) {
        for (int i = 0; i < this.lhs_.size(); ++i) {
            if (!lhsExpr.equals(this.lhs_.get(i))) continue;
            return this.rhs_.get(i);
        }
        return null;
    }

    public boolean containsMappingFor(Expr lhsExpr) {
        return this.lhs_.contains(lhsExpr);
    }

    public Expr mappingForRhsExpr(Expr rhsExpr) {
        for (int i = 0; i < this.rhs_.size(); ++i) {
            if (!this.rhs_.get(i).equals(rhsExpr)) continue;
            return this.lhs_.get(i);
        }
        return null;
    }

    public void removeByRhsExpr(Expr rhsExpr) {
        for (int i = 0; i < this.rhs_.size(); ++i) {
            if (!this.rhs_.get(i).equals(rhsExpr)) continue;
            this.lhs_.remove(i);
            this.rhs_.remove(i);
            break;
        }
    }

    public void updateLhsExprs(List<Expr> lhsExprList) {
        this.lhs_ = lhsExprList;
    }

    public static ExprSubstitutionMap compose(ExprSubstitutionMap f, ExprSubstitutionMap g, Analyzer analyzer) {
        if (f == null && g == null) {
            return new ExprSubstitutionMap();
        }
        if (f == null) {
            return g;
        }
        if (g == null) {
            return f;
        }
        ExprSubstitutionMap result = new ExprSubstitutionMap();
        result.lhs_ = Expr.cloneList(f.lhs_);
        result.rhs_ = Expr.substituteList(f.rhs_, g, analyzer, false);
        for (int i = 0; i < g.lhs_.size(); ++i) {
            if (result.lhs_.contains(g.lhs_.get(i))) continue;
            result.lhs_.add(g.lhs_.get(i).clone());
            result.rhs_.add(g.rhs_.get(i).clone());
        }
        result.verify();
        return result;
    }

    public static ExprSubstitutionMap subtraction(ExprSubstitutionMap f, ExprSubstitutionMap g, Analyzer analyzer) {
        if (f == null && g == null) {
            return new ExprSubstitutionMap();
        }
        if (f == null) {
            return g;
        }
        if (g == null) {
            return f;
        }
        ExprSubstitutionMap result = new ExprSubstitutionMap();
        for (int i = 0; i < g.size(); ++i) {
            if (f.containsMappingFor(g.lhs_.get(i))) {
                result.put(f.get(g.lhs_.get(i)), g.rhs_.get(i));
                if (!(f.get(g.lhs_.get(i)) instanceof SlotRef) || !(g.rhs_.get(i) instanceof SlotRef)) continue;
                analyzer.putEquivalentSlot(((SlotRef)g.rhs_.get(i)).getSlotId(), ((SlotRef)Objects.requireNonNull(f.get(g.lhs_.get(i)))).getSlotId());
                continue;
            }
            result.put(g.lhs_.get(i), g.rhs_.get(i));
            if (!(g.lhs_.get(i) instanceof SlotRef) || !(g.rhs_.get(i) instanceof SlotRef)) continue;
            analyzer.putEquivalentSlot(((SlotRef)g.rhs_.get(i)).getSlotId(), ((SlotRef)g.lhs_.get(i)).getSlotId());
        }
        return result;
    }

    public static ExprSubstitutionMap composeAndReplace(ExprSubstitutionMap f, ExprSubstitutionMap g, Analyzer analyzer) throws AnalysisException {
        int i;
        if (f == null && g == null) {
            return new ExprSubstitutionMap();
        }
        if (f == null) {
            return g;
        }
        if (g == null) {
            return f;
        }
        ExprSubstitutionMap result = new ExprSubstitutionMap();
        for (i = 0; i < g.size(); ++i) {
            boolean findGMatch = false;
            Expr gLhs = g.getLhs().get(i);
            for (int j = 0; j < f.size(); ++j) {
                Expr fRhs = f.getRhs().get(j);
                if (!fRhs.contains(gLhs)) continue;
                Expr newRhs = fRhs.trySubstitute(g, analyzer, false);
                result.put(f.getLhs().get(j), newRhs);
                findGMatch = true;
                break;
            }
            if (findGMatch) continue;
            result.put(g.getLhs().get(i), g.getRhs().get(i));
        }
        for (i = 0; i < f.size(); ++i) {
            if (result.containsMappingFor(f.lhs_.get(i))) continue;
            result.put(f.lhs_.get(i), f.rhs_.get(i));
        }
        return result;
    }

    public static ExprSubstitutionMap combine(ExprSubstitutionMap f, ExprSubstitutionMap g) {
        if (f == null && g == null) {
            return new ExprSubstitutionMap();
        }
        if (f == null) {
            return g;
        }
        if (g == null) {
            return f;
        }
        ExprSubstitutionMap result = new ExprSubstitutionMap();
        result.lhs_ = Lists.newArrayList(f.lhs_);
        result.lhs_.addAll(g.lhs_);
        result.rhs_ = Lists.newArrayList(f.rhs_);
        result.rhs_.addAll(g.rhs_);
        result.verify();
        return result;
    }

    public void substituteLhs(ExprSubstitutionMap lhsSmap, Analyzer analyzer) {
        this.lhs_ = Expr.substituteList(this.lhs_, lhsSmap, analyzer, false);
    }

    public List<Expr> getLhs() {
        return this.lhs_;
    }

    public List<Expr> getRhs() {
        return this.rhs_;
    }

    public int size() {
        return this.lhs_.size();
    }

    public String debugString() {
        Preconditions.checkState((this.lhs_.size() == this.rhs_.size() ? 1 : 0) != 0);
        ArrayList output = Lists.newArrayList();
        for (int i = 0; i < this.lhs_.size(); ++i) {
            output.add(this.lhs_.get(i).toSql() + ":" + this.rhs_.get(i).toSql());
            output.add("(" + this.lhs_.get(i).debugString() + ":" + this.rhs_.get(i).debugString() + ")");
        }
        return "smap(" + Joiner.on((String)" ").join((Iterable)output) + ")";
    }

    private void verify() {
        for (int i = 0; i < this.lhs_.size(); ++i) {
            for (int j = i + 1; j < this.lhs_.size(); ++j) {
                if (!this.lhs_.get(i).equals(this.lhs_.get(j)) || !LOG.isTraceEnabled()) continue;
                LOG.trace("verify: smap=" + this.debugString());
            }
            Preconditions.checkState((!this.checkAnalyzed_ || this.rhs_.get(i).isAnalyzed() ? 1 : 0) != 0);
        }
    }

    public void clear() {
        this.lhs_.clear();
        this.rhs_.clear();
    }

    public ExprSubstitutionMap clone() {
        return new ExprSubstitutionMap(Expr.cloneList(this.lhs_), Expr.cloneList(this.rhs_));
    }
}

