/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ArithmeticExpr;
import org.apache.doris.analysis.ArrayLiteral;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.DecimalLiteral;
import org.apache.doris.analysis.ExprId;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.ExpressionFunctions;
import org.apache.doris.analysis.FloatLiteral;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.FunctionName;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LargeIntLiteral;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.MaxLiteral;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.ParseNode;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotId;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.analysis.Subquery;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.TreeNode;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.VectorizedUtil;
import org.apache.doris.thrift.TExpr;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprOpcode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Expr
extends TreeNode<Expr>
implements ParseNode,
Cloneable,
Writable {
    private static final Logger LOG = LogManager.getLogger(Expr.class);
    private static final String NEGATE_FN = "negate";
    public static final double DEFAULT_SELECTIVITY = 0.1;
    public static final float FUNCTION_CALL_COST = 10.0f;
    private static final Predicate<Expr> IS_AGGREGATE_PREDICATE = new Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof FunctionCallExpr && ((FunctionCallExpr)arg).isAggregateFunction();
        }
    };
    public static final Predicate<Expr> IS_NOT_PREDICATE = new Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof CompoundPredicate && ((CompoundPredicate)arg).getOp() == CompoundPredicate.Operator.NOT;
        }
    };
    public static final Predicate<Expr> IS_OR_PREDICATE = new Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof CompoundPredicate && ((CompoundPredicate)arg).getOp() == CompoundPredicate.Operator.OR;
        }
    };
    public static final Predicate<Expr> IS_SCALAR_SUBQUERY = new Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg.isScalarSubquery();
        }
    };
    public static final Predicate<Expr> NON_NULL_EMPTY_AGG = new Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof FunctionCallExpr && ((FunctionCallExpr)arg).returnsNonNullOnEmpty();
        }
    };
    public static final Predicate<Expr> CORRELATED_SUBQUERY_SUPPORT_AGG_FN = new Predicate<Expr>(){

        public boolean apply(Expr arg) {
            if (arg instanceof FunctionCallExpr) {
                String fnName = ((FunctionCallExpr)arg).getFnName().getFunction();
                return fnName.equalsIgnoreCase("sum") || fnName.equalsIgnoreCase("max") || fnName.equalsIgnoreCase("min") || fnName.equalsIgnoreCase("avg") || fnName.equalsIgnoreCase("count");
            }
            return false;
        }
    };
    public static final Predicate<Expr> IS_TRUE_LITERAL = new Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof BoolLiteral && ((BoolLiteral)arg).getValue();
        }
    };
    public static final Predicate<Expr> IS_FALSE_LITERAL = new Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof BoolLiteral && !((BoolLiteral)arg).getValue();
        }
    };
    public static final Predicate<Expr> IS_EQ_BINARY_PREDICATE = new Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return BinaryPredicate.getEqSlots(arg) != null;
        }
    };
    public static final Predicate<Expr> IS_BINARY_PREDICATE = new Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof BinaryPredicate;
        }
    };
    public static final Predicate<Expr> IS_NULL_LITERAL = new Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof NullLiteral;
        }
    };
    protected ExprId id;
    private boolean isAuxExpr = false;
    protected Type type;
    protected boolean isOnClauseConjunct_;
    protected boolean isAnalyzed = false;
    protected TExprOpcode opcode;
    protected TExprOpcode vectorOpcode;
    protected double selectivity;
    protected long numDistinctValues;
    protected int outputScale = -1;
    protected int outputColumn = -1;
    protected boolean isFilter = false;
    protected Function fn;
    private boolean isConstant_;
    protected boolean printSqlInParens = false;

    public void setSelectivity() {
        this.selectivity = -1.0;
    }

    protected Expr() {
        this.type = Type.INVALID;
        this.opcode = TExprOpcode.INVALID_OPCODE;
        this.vectorOpcode = TExprOpcode.INVALID_OPCODE;
        this.selectivity = -1.0;
        this.numDistinctValues = -1L;
    }

    protected Expr(Expr other) {
        this.id = other.id;
        this.isAuxExpr = other.isAuxExpr;
        this.type = other.type;
        this.isAnalyzed = other.isAnalyzed;
        this.selectivity = other.selectivity;
        this.numDistinctValues = other.numDistinctValues;
        this.opcode = other.opcode;
        this.outputScale = other.outputScale;
        this.isConstant_ = other.isConstant_;
        this.fn = other.fn;
        this.printSqlInParens = other.printSqlInParens;
        this.children = Expr.cloneList(other.children);
    }

    public boolean isAnalyzed() {
        return this.isAnalyzed;
    }

    public void checkValueValid() throws AnalysisException {
    }

    public ExprId getId() {
        return this.id;
    }

    public void setId(ExprId id) {
        this.id = id;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public TExprOpcode getOpcode() {
        return this.opcode;
    }

    public double getSelectivity() {
        return this.selectivity;
    }

    public boolean hasSelectivity() {
        return this.selectivity >= 0.0;
    }

    public long getNumDistinctValues() {
        return this.numDistinctValues;
    }

    public int getOutputScale() {
        return this.outputScale;
    }

    public void setOutputScale(int scale) {
        if (scale > 0 && scale < 10) {
            this.outputScale = scale;
        }
    }

    public int getOutputColumn() {
        return this.outputColumn;
    }

    public boolean isFilter() {
        return this.isFilter;
    }

    public void setIsFilter(boolean v) {
        this.isFilter = v;
    }

    public boolean isOnClauseConjunct() {
        return this.isOnClauseConjunct_;
    }

    public void setIsOnClauseConjunct(boolean b) {
        this.isOnClauseConjunct_ = b;
    }

    public boolean isAuxExpr() {
        return this.isAuxExpr;
    }

    public void setIsAuxExpr() {
        this.isAuxExpr = true;
    }

    public Function getFn() {
        return this.fn;
    }

    public boolean getPrintSqlInParens() {
        return this.printSqlInParens;
    }

    public void setPrintSqlInParens(boolean b) {
        this.printSqlInParens = b;
    }

    @Override
    public final void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed()) {
            return;
        }
        if (this.children.size() > Config.expr_children_limit) {
            throw new AnalysisException(String.format("Exceeded the maximum number of child expressions (%d).", Config.expr_children_limit));
        }
        if (analyzer != null) {
            analyzer.incrementCallDepth();
            if (analyzer.getCallDepth() > Config.expr_depth_limit) {
                throw new AnalysisException(String.format("Exceeded the maximum depth of an expression tree (%s).", Config.expr_depth_limit));
            }
        } else {
            throw new AnalysisException("analyzer is null.");
        }
        for (Expr child : this.children) {
            child.analyze(analyzer);
        }
        if (analyzer != null) {
            analyzer.decrementCallDepth();
        }
        this.computeNumDistinctValues();
        this.analyzeImpl(analyzer);
        if (analyzer.safeIsEnableJoinReorderBasedCost()) {
            this.setSelectivity();
        }
        this.analysisDone();
    }

    protected abstract void analyzeImpl(Analyzer var1) throws AnalysisException;

    protected void analysisDone() {
        Preconditions.checkState((!this.isAnalyzed ? 1 : 0) != 0);
        this.isConstant_ = this.isConstantImpl();
        this.isAnalyzed = true;
    }

    protected void computeNumDistinctValues() {
        if (this.isConstant()) {
            this.numDistinctValues = 1L;
        } else {
            ArrayList slotRefs = Lists.newArrayList();
            this.collect(SlotRef.class, slotRefs);
            this.numDistinctValues = -1L;
            for (SlotRef slotRef : slotRefs) {
                this.numDistinctValues = Math.max(this.numDistinctValues, slotRef.numDistinctValues);
            }
        }
    }

    protected Type[] collectChildReturnTypes() {
        Type[] childTypes = new Type[this.children.size()];
        for (int i = 0; i < this.children.size(); ++i) {
            childTypes[i] = ((Expr)this.children.get((int)i)).type;
        }
        return childTypes;
    }

    public List<Expr> getChildrenWithoutCast() {
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i) instanceof CastExpr) {
                CastExpr castExpr = (CastExpr)this.children.get(i);
                result.add((Expr)castExpr.getChild(0));
                continue;
            }
            result.add((Expr)this.children.get(i));
        }
        return result;
    }

    public static void analyze(List<? extends Expr> exprs, Analyzer analyzer) throws AnalysisException {
        for (Expr expr : exprs) {
            expr.analyze(analyzer);
        }
    }

    public static List<TExpr> treesToThrift(List<? extends Expr> exprs) {
        ArrayList result = Lists.newArrayList();
        for (Expr expr : exprs) {
            result.add(expr.treeToThrift());
        }
        return result;
    }

    public static String debugString(List<? extends Expr> exprs) {
        if (exprs == null || exprs.isEmpty()) {
            return "";
        }
        ArrayList strings = Lists.newArrayList();
        for (Expr expr : exprs) {
            strings.add(Strings.nullToEmpty((String)expr.debugString()));
        }
        return "(" + Joiner.on((String)" ").join((Iterable)strings) + ")";
    }

    public static <C extends Expr> boolean equalLists(List<C> l1, List<C> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator<C> l1Iter = l1.iterator();
        Iterator<C> l2Iter = l2.iterator();
        while (l1Iter.hasNext()) {
            if (((Expr)l1Iter.next()).equals(l2Iter.next())) continue;
            return false;
        }
        return true;
    }

    public static <C extends Expr> boolean equalSets(List<C> l1, List<C> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        HashMap<C, Integer> cMap1 = Expr.toCountMap(l1);
        HashMap<C, Integer> cMap2 = Expr.toCountMap(l2);
        if (cMap1.size() != cMap2.size()) {
            return false;
        }
        for (Expr obj : cMap1.keySet()) {
            Integer count1 = (Integer)cMap1.get(obj);
            Integer count2 = (Integer)cMap2.get(obj);
            if (count2 != null && count1 == count2) continue;
            return false;
        }
        return true;
    }

    public static <C extends Expr> HashMap<C, Integer> toCountMap(List<C> list) {
        HashMap<Expr, Integer> countMap = new HashMap<Expr, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            Expr obj = (Expr)list.get(i);
            Integer count = (Integer)countMap.get(obj);
            if (count == null) {
                countMap.put(obj, 1);
                continue;
            }
            countMap.put(obj, count + 1);
        }
        return countMap;
    }

    public void analyzeNoThrow(Analyzer analyzer) {
        try {
            this.analyze(analyzer);
        }
        catch (AnalysisException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <C extends Expr> ArrayList<C> cloneList(List<C> l, ExprSubstitutionMap sMap) {
        Preconditions.checkNotNull(l);
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Expr element : l) {
            result.add(element.clone(sMap));
        }
        return result;
    }

    public static <C extends Expr> ArrayList<C> cloneList(List<C> l) {
        Preconditions.checkNotNull(l);
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Expr element : l) {
            result.add(element.clone());
        }
        return result;
    }

    public static <C extends Expr> ArrayList<C> cloneAndResetList(List<C> l) {
        Preconditions.checkNotNull(l);
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Expr element : l) {
            result.add(element.clone().reset());
        }
        return result;
    }

    public static <C extends Expr> void collectList(List<? extends Expr> input, Class<C> cl, List<C> output) {
        Preconditions.checkNotNull(input);
        for (Expr expr : input) {
            expr.collect(cl, output);
        }
    }

    public static <C extends Expr> void collectAggregateExprs(List<? extends Expr> input, List<C> output) {
        Preconditions.checkNotNull(input);
        for (Expr expr : input) {
            expr.collectAggregateExprs(output);
        }
    }

    public static <C extends Expr> List<C> intersect(List<C> l1, List<C> l2) {
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Expr element : l1) {
            if (!l2.contains(element)) continue;
            result.add(element);
        }
        return result;
    }

    public static void intersect(Analyzer analyzer, List<Expr> l1, List<Expr> l2, ExprSubstitutionMap smap, List<Expr> i1, List<Expr> i2) throws AnalysisException {
        i1.clear();
        i2.clear();
        ArrayList<Expr> s1List = Expr.trySubstituteList(l1, smap, analyzer, false);
        Preconditions.checkState((s1List.size() == l1.size() ? 1 : 0) != 0);
        ArrayList<Expr> s2List = Expr.trySubstituteList(l2, smap, analyzer, false);
        Preconditions.checkState((s2List.size() == l2.size() ? 1 : 0) != 0);
        block0: for (int i = 0; i < s1List.size(); ++i) {
            Expr s1 = (Expr)s1List.get(i);
            for (int j = 0; j < s2List.size(); ++j) {
                Expr s2 = (Expr)s2List.get(j);
                if (!s1.equals(s2)) continue;
                i1.add(l1.get(i));
                i2.add(l2.get(j));
                continue block0;
            }
        }
    }

    public static <C extends Expr> boolean containsAggregate(List<? extends Expr> input) {
        for (Expr expr : input) {
            if (!expr.containsAggregate()) continue;
            return true;
        }
        return false;
    }

    public Expr trySubstitute(ExprSubstitutionMap smap, Analyzer analyzer, boolean preserveRootType) throws AnalysisException {
        Expr result = this.clone();
        if (smap == null) {
            return result;
        }
        result = result.substituteImpl(smap, analyzer);
        result.analyze(analyzer);
        if (preserveRootType && !this.type.equals(result.getType())) {
            result = result.castTo(this.type);
        }
        return result;
    }

    public Expr substitute(ExprSubstitutionMap smap, Analyzer analyzer, boolean preserveRootType) throws AnalysisException {
        try {
            return this.trySubstitute(smap, analyzer, preserveRootType);
        }
        catch (AnalysisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed analysis after expr substitution.", e);
        }
    }

    public static ArrayList<Expr> trySubstituteList(Iterable<? extends Expr> exprs, ExprSubstitutionMap smap, Analyzer analyzer, boolean preserveRootTypes) throws AnalysisException {
        if (exprs == null) {
            return null;
        }
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Expr expr : exprs) {
            result.add(expr.trySubstitute(smap, analyzer, preserveRootTypes));
        }
        return result;
    }

    public static ArrayList<Expr> substituteList(Iterable<? extends Expr> exprs, ExprSubstitutionMap smap, Analyzer analyzer, boolean preserveRootTypes) {
        try {
            return Expr.trySubstituteList(exprs, smap, analyzer, preserveRootTypes);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed analysis after expr substitution.", e);
        }
    }

    protected Expr substituteImpl(ExprSubstitutionMap smap, Analyzer analyzer) throws AnalysisException {
        Expr substExpr;
        if (this.isImplicitCast()) {
            return ((Expr)this.getChild(0)).substituteImpl(smap, analyzer);
        }
        if (smap != null && (substExpr = smap.get(this)) != null) {
            return substExpr.clone();
        }
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.set(i, ((Expr)this.children.get(i)).substituteImpl(smap, analyzer));
        }
        if (!(this instanceof SlotRef)) {
            this.resetAnalysisState();
        }
        return this;
    }

    public static <C extends Expr> void removeDuplicates(List<C> l) {
        if (l == null) {
            return;
        }
        ListIterator<C> it1 = l.listIterator();
        while (it1.hasNext()) {
            Expr e2;
            Expr e1 = (Expr)it1.next();
            ListIterator<C> it2 = l.listIterator();
            boolean duplicate = false;
            while (it2.hasNext() && e1 != (e2 = (Expr)it2.next())) {
                if (!e1.equals(e2)) continue;
                duplicate = true;
                break;
            }
            if (!duplicate) continue;
            it1.remove();
        }
    }

    public static boolean isBound(List<? extends Expr> exprs, List<TupleId> tids) {
        for (Expr expr : exprs) {
            if (expr.isBoundByTupleIds(tids)) continue;
            return false;
        }
        return true;
    }

    public static <C extends Expr> void getIds(List<? extends Expr> exprs, List<TupleId> tupleIds, List<SlotId> slotIds) {
        if (exprs == null) {
            return;
        }
        for (Expr expr : exprs) {
            expr.getIds(tupleIds, slotIds);
        }
    }

    public void markAgg() {
        for (Expr child : this.children) {
            child.markAgg();
        }
    }

    public static long getNumDistinctValues(List<Expr> exprs) {
        if (exprs == null || exprs.isEmpty()) {
            return 0L;
        }
        long numDistinctValues = 1L;
        for (Expr expr : exprs) {
            if (expr.getNumDistinctValues() == -1L) {
                numDistinctValues = -1L;
                break;
            }
            numDistinctValues *= expr.getNumDistinctValues();
        }
        return numDistinctValues;
    }

    public void vectorizedAnalyze(Analyzer analyzer) {
        for (Expr child : this.children) {
            child.vectorizedAnalyze(analyzer);
        }
    }

    public void computeOutputColumn(Analyzer analyzer) {
        for (Expr child : this.children) {
            child.computeOutputColumn(analyzer);
            LOG.info("child " + child.debugString() + " outputColumn: " + child.getOutputColumn());
        }
        if (!this.isConstant() && !this.isFilter) {
            ArrayList tupleIds = Lists.newArrayList();
            this.getIds(tupleIds, null);
            Preconditions.checkArgument((tupleIds.size() == 1 ? 1 : 0) != 0);
            int currentOutputColumn = analyzer.getCurrentOutputColumn((TupleId)tupleIds.get(0));
            this.outputColumn = currentOutputColumn++;
            LOG.info(this.debugString() + " outputColumn: " + this.outputColumn);
            analyzer.setCurrentOutputColumn((TupleId)tupleIds.get(0), currentOutputColumn);
        }
    }

    @Override
    public String toSql() {
        return this.printSqlInParens ? "(" + this.toSqlImpl() + ")" : this.toSqlImpl();
    }

    protected abstract String toSqlImpl();

    public String toMySql() {
        return this.toSql();
    }

    public String toColumnLabel() {
        return this.toSql();
    }

    public TExpr treeToThrift() {
        if (this.type.isNull()) {
            Preconditions.checkState((this instanceof NullLiteral || this instanceof SlotRef ? 1 : 0) != 0);
            return NullLiteral.create(ScalarType.BOOLEAN).treeToThrift();
        }
        TExpr result = new TExpr();
        this.treeToThriftHelper(result);
        return result;
    }

    public void setFn(Function fn) {
        this.fn = fn;
    }

    protected void treeToThriftHelper(TExpr container) {
        TExprNode msg = new TExprNode();
        msg.type = this.type.toThrift();
        msg.num_children = this.children.size();
        if (this.fn != null) {
            msg.setFn(this.fn.toThrift());
            if (this.fn.hasVarArgs()) {
                msg.setVarargStartIdx(this.fn.getNumArgs() - 1);
            }
        }
        msg.output_scale = this.getOutputScale();
        msg.setIsNullable(this.isNullable());
        this.toThrift(msg);
        container.addToNodes(msg);
        for (Expr child : this.children) {
            child.treeToThriftHelper(container);
        }
    }

    protected abstract void toThrift(TExprNode var1);

    public List<String> childrenToSql() {
        ArrayList result = Lists.newArrayList();
        for (Expr child : this.children) {
            result.add(child.toSql());
        }
        return result;
    }

    public static Predicate<Expr> isAggregatePredicate() {
        return IS_AGGREGATE_PREDICATE;
    }

    public boolean isAggregate() {
        return IS_AGGREGATE_PREDICATE.apply((Object)this);
    }

    public String debugString() {
        return Expr.debugString(this.children);
    }

    protected void resetAnalysisState() {
        this.isAnalyzed = false;
    }

    public Expr reset() {
        if (this.isImplicitCast()) {
            return ((Expr)this.getChild(0)).reset();
        }
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.set(i, ((Expr)this.children.get(i)).reset());
        }
        this.resetAnalysisState();
        return this;
    }

    public static ArrayList<Expr> resetList(ArrayList<Expr> l) {
        for (int i = 0; i < l.size(); ++i) {
            l.set(i, l.get(i).reset());
        }
        return l;
    }

    public abstract Expr clone();

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Expr expr = (Expr)obj;
        if (this.children.size() != expr.children.size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (((Expr)this.children.get(i)).equals(expr.children.get(i))) continue;
            return false;
        }
        if (this.fn == null && expr.fn == null) {
            return true;
        }
        if (this.fn == null || expr.fn == null) {
            return false;
        }
        return this.fn.equals(expr.fn);
    }

    public int hashCode() {
        if (this.id == null) {
            int result = 31 * Objects.hashCode((Object[])new Object[]{this.type}) + Objects.hashCode((Object[])new Object[]{this.opcode});
            for (Expr child : this.children) {
                result = 31 * result + Objects.hashCode((Object[])new Object[]{child});
            }
            return result;
        }
        return this.id.asInt();
    }

    public List<Expr> getConjuncts() {
        ArrayList list = Lists.newArrayList();
        if (this instanceof CompoundPredicate && ((CompoundPredicate)this).getOp() == CompoundPredicate.Operator.AND) {
            list.addAll(((Expr)this.getChild(0)).getConjuncts());
            list.addAll(((Expr)this.getChild(1)).getConjuncts());
        } else {
            list.add(this);
        }
        return list;
    }

    public Expr clone(ExprSubstitutionMap sMap) {
        if (sMap != null) {
            for (int i = 0; i < sMap.getLhs().size(); ++i) {
                if (!this.equals(sMap.getLhs().get(i))) continue;
                return sMap.getRhs().get(i).clone(null);
            }
        }
        Expr result = this.clone();
        result.children = Lists.newArrayList();
        for (Expr child : this.children) {
            result.children.add(child.clone(sMap));
        }
        return result;
    }

    public <C extends Expr> void collectAggregateExprs(List<C> output) {
        if (this.isAggregate() && !output.contains(this)) {
            output.add(this);
            return;
        }
        for (Expr child : this.children) {
            child.collectAggregateExprs(output);
        }
    }

    public boolean containsAggregate() {
        if (this.isAggregate()) {
            return true;
        }
        return Expr.containsAggregate(this.children);
    }

    public Expr substitute(ExprSubstitutionMap sMap) {
        int i;
        Preconditions.checkNotNull((Object)sMap);
        for (i = 0; i < sMap.getLhs().size(); ++i) {
            if (!this.equals(sMap.getLhs().get(i))) continue;
            Expr result = sMap.getRhs().get(i).clone(null);
            if (this.id != null) {
                result.id = this.id;
            }
            return result;
        }
        for (i = 0; i < this.children.size(); ++i) {
            this.children.set(i, ((Expr)this.children.get(i)).substitute(sMap));
        }
        return this;
    }

    public boolean isBound(TupleId tid) {
        return this.isBoundByTupleIds(Lists.newArrayList((Object[])new TupleId[]{tid}));
    }

    public boolean isBoundByTupleIds(List<TupleId> tids) {
        for (Expr child : this.children) {
            if (child.isBoundByTupleIds(tids)) continue;
            return false;
        }
        return true;
    }

    public boolean isBound(SlotId slotId) {
        for (Expr child : this.children) {
            if (child.isBound(slotId)) continue;
            return false;
        }
        return true;
    }

    public boolean isBound(List<SlotId> slotIds) {
        ArrayList exprTupleIds = Lists.newArrayList();
        ArrayList exprSlotIds = Lists.newArrayList();
        this.getIds(exprTupleIds, exprSlotIds);
        return !exprSlotIds.retainAll(slotIds);
    }

    public void getSlotRefsBoundByTupleIds(List<TupleId> tupleIds, Set<SlotRef> boundSlotRefs) {
        for (Expr child : this.children) {
            child.getSlotRefsBoundByTupleIds(tupleIds, boundSlotRefs);
        }
    }

    public void getIds(List<TupleId> tupleIds, List<SlotId> slotIds) {
        for (Expr child : this.children) {
            child.getIds(tupleIds, slotIds);
        }
    }

    public void getTableIdToColumnNames(Map<Long, Set<String>> tableIdToColumnNames) {
        Preconditions.checkState((tableIdToColumnNames != null ? 1 : 0) != 0);
        for (Expr child : this.children) {
            child.getTableIdToColumnNames(tableIdToColumnNames);
        }
    }

    public boolean isLiteral() {
        return this instanceof LiteralExpr;
    }

    public final boolean isConstant() {
        if (this.isAnalyzed) {
            return this.isConstant_;
        }
        return this.isConstantImpl();
    }

    protected boolean isConstantImpl() {
        for (Expr expr : this.children) {
            if (expr.isConstant()) continue;
            return false;
        }
        return true;
    }

    public boolean isScalarSubquery() {
        Preconditions.checkState((boolean)this.isAnalyzed);
        return this instanceof Subquery && this.getType().isScalarType();
    }

    public boolean isVectorized() {
        for (Expr child : this.children) {
            if (child.isVectorized()) continue;
            return false;
        }
        return true;
    }

    public void checkReturnsBool(String name, boolean printExpr) throws AnalysisException {
        if (!this.type.isBoolean() && !this.type.isNull()) {
            if (this instanceof BoolLiteral) {
                return;
            }
            throw new AnalysisException(String.format("%s%s requires return type 'BOOLEAN'. Actual type is '%s'.", name, printExpr ? " '" + this.toSql() + "'" : "", this.type.toString()));
        }
    }

    public Expr checkTypeCompatibility(Type targetType) throws AnalysisException {
        if (targetType.getPrimitiveType().equals((Object)this.type.getPrimitiveType())) {
            return this;
        }
        if (targetType.getPrimitiveType() == PrimitiveType.BITMAP) {
            throw new AnalysisException("bitmap column require the function return type is BITMAP");
        }
        if (targetType.getPrimitiveType() == PrimitiveType.HLL) {
            this.checkHllCompatibility();
            return this;
        }
        Expr newExpr = this.castTo(targetType);
        newExpr.checkValueValid();
        return newExpr;
    }

    private void checkHllCompatibility() throws AnalysisException {
        String hllMismatchLog = "Column's type is HLL, SelectList must contains HLL or hll_hash or hll_empty function's result";
        if (this instanceof SlotRef) {
            SlotRef slot = (SlotRef)this;
            if (!slot.getType().equals(Type.HLL)) {
                throw new AnalysisException("Column's type is HLL, SelectList must contains HLL or hll_hash or hll_empty function's result");
            }
        } else if (this instanceof FunctionCallExpr) {
            FunctionCallExpr functionExpr = (FunctionCallExpr)this;
            if (!functionExpr.getFnName().getFunction().equalsIgnoreCase("hll_hash") && !functionExpr.getFnName().getFunction().equalsIgnoreCase("hll_empty")) {
                throw new AnalysisException("Column's type is HLL, SelectList must contains HLL or hll_hash or hll_empty function's result");
            }
        } else {
            throw new AnalysisException("Column's type is HLL, SelectList must contains HLL or hll_hash or hll_empty function's result");
        }
    }

    public final Expr castTo(Type targetType) throws AnalysisException {
        if (targetType.isNull()) {
            return this;
        }
        if ((targetType.isStringType() || targetType.isHllType()) && (this.type.isStringType() || this.type.isHllType())) {
            return this;
        }
        if (!Type.canCastTo(this.type, targetType)) {
            throw new AnalysisException("type not match, originType=" + this.type + ", targeType=" + targetType);
        }
        return this.uncheckedCastTo(targetType);
    }

    protected Expr uncheckedCastTo(Type targetType) throws AnalysisException {
        return new CastExpr(targetType, this);
    }

    public void castChild(Type targetType, int childIndex) throws AnalysisException {
        Expr child = (Expr)this.getChild(childIndex);
        Expr newChild = child.castTo(targetType);
        this.setChild(childIndex, newChild);
    }

    public void uncheckedCastChild(Type targetType, int childIndex) throws AnalysisException {
        Expr child = (Expr)this.getChild(childIndex);
        Expr newChild = child.uncheckedCastTo(targetType);
        this.setChild(childIndex, newChild);
    }

    public Expr ignoreImplicitCast() {
        return this;
    }

    public Type castBinaryOp(Type compatibleType) throws AnalysisException {
        Preconditions.checkState((this instanceof BinaryPredicate || this instanceof ArithmeticExpr ? 1 : 0) != 0);
        Type t1 = ((Expr)this.getChild(0)).getType();
        Type t2 = ((Expr)this.getChild(1)).getType();
        Preconditions.checkState((boolean)compatibleType.isValid());
        if (t1.getPrimitiveType() != compatibleType.getPrimitiveType()) {
            this.castChild(compatibleType, 0);
        }
        if (t2.getPrimitiveType() != compatibleType.getPrimitiveType()) {
            this.castChild(compatibleType, 1);
        }
        return compatibleType;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id).add("type", (Object)this.type).add("sel", this.selectivity).add("#distinct", this.numDistinctValues).add("scale", this.outputScale).toString();
    }

    public SlotRef getSrcSlotRef() {
        SlotRef unwrapSloRef = this.unwrapSlotRef();
        if (unwrapSloRef == null) {
            return null;
        }
        SlotDescriptor slotDescriptor = unwrapSloRef.getDesc();
        if (slotDescriptor == null) {
            return null;
        }
        List<Expr> sourceExpr = slotDescriptor.getSourceExprs();
        if (sourceExpr == null || sourceExpr.isEmpty()) {
            return unwrapSloRef;
        }
        if (sourceExpr.size() > 1) {
            return null;
        }
        return sourceExpr.get(0).getSrcSlotRef();
    }

    public boolean comeFrom(Expr srcExpr) {
        SlotRef unwrapSloRef = this.unwrapSlotRef();
        if (unwrapSloRef == null) {
            return false;
        }
        SlotRef unwrapSrcSlotRef = srcExpr.unwrapSlotRef();
        if (unwrapSrcSlotRef == null) {
            return false;
        }
        if (unwrapSloRef.columnEqual(unwrapSrcSlotRef)) {
            return true;
        }
        SlotDescriptor slotDescriptor = unwrapSloRef.getDesc();
        if (slotDescriptor == null || slotDescriptor.getSourceExprs() == null || slotDescriptor.getSourceExprs().size() != 1) {
            return false;
        }
        return slotDescriptor.getSourceExprs().get(0).comeFrom(unwrapSrcSlotRef);
    }

    public SlotRef unwrapSlotRef() {
        if (this instanceof SlotRef) {
            return (SlotRef)this;
        }
        if (this instanceof CastExpr && this.getChild(0) instanceof SlotRef) {
            return (SlotRef)this.getChild(0);
        }
        return null;
    }

    public SlotRef unwrapSlotRef(boolean implicitOnly) {
        Expr unwrappedExpr = this.unwrapExpr(implicitOnly);
        if (unwrappedExpr instanceof SlotRef) {
            return (SlotRef)unwrappedExpr;
        }
        return null;
    }

    public Expr unwrapExpr(boolean implicitOnly) {
        if (this instanceof CastExpr && (!implicitOnly || ((CastExpr)this).isImplicit())) {
            return (Expr)this.children.get(0);
        }
        return this;
    }

    public SlotDescriptor findSrcScanSlot() {
        SlotRef slotRef = this.unwrapSlotRef(false);
        if (slotRef == null) {
            return null;
        }
        SlotDescriptor slotDesc = slotRef.getDesc();
        if (slotDesc.isScanSlot()) {
            return slotDesc;
        }
        if (slotDesc.getSourceExprs().size() == 1) {
            return slotDesc.getSourceExprs().get(0).findSrcScanSlot();
        }
        return null;
    }

    public static double getConstFromExpr(Expr e) throws AnalysisException {
        Preconditions.checkState((boolean)e.isConstant());
        double value = 0.0;
        if (!(e instanceof LiteralExpr)) {
            throw new AnalysisException("To const value not a LiteralExpr ");
        }
        LiteralExpr lit = (LiteralExpr)e;
        value = lit.getDoubleValue();
        return value;
    }

    public boolean isImplicitCast() {
        return this instanceof CastExpr && ((CastExpr)this).isImplicit();
    }

    public boolean contains(Expr expr) {
        if (this.equals(expr)) {
            return true;
        }
        for (Expr child : this.getChildren()) {
            if (!child.contains(expr)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(List<Expr> exprs) {
        if (exprs.isEmpty()) {
            return false;
        }
        for (Expr expr : exprs) {
            if (!this.contains(expr)) continue;
            return true;
        }
        return false;
    }

    public Expr findEqual(List<Expr> exprs) {
        if (exprs.isEmpty()) {
            return null;
        }
        for (Expr expr : exprs) {
            if (!this.contains(expr)) continue;
            return expr;
        }
        return null;
    }

    protected Function getBuiltinFunction(Analyzer analyzer, String name, Type[] argTypes, Function.CompareMode mode) throws AnalysisException {
        FunctionName fnName = new FunctionName(name);
        Function searchDesc = new Function(fnName, Arrays.asList(argTypes), Type.INVALID, false, VectorizedUtil.isVectorized());
        Function f = Catalog.getCurrentCatalog().getFunction(searchDesc, mode);
        if (f != null && fnName.getFunction().equalsIgnoreCase("rand") && this.children.size() == 1 && !(this.children.get(0) instanceof LiteralExpr)) {
            throw new AnalysisException("The param of rand function must be literal");
        }
        return f;
    }

    protected Function getTableFunction(String name, Type[] argTypes, Function.CompareMode mode) {
        FunctionName fnName = new FunctionName(name);
        Function searchDesc = new Function(fnName, Arrays.asList(argTypes), Type.INVALID, false, VectorizedUtil.isVectorized());
        Function f = Catalog.getCurrentCatalog().getTableFunction(searchDesc, mode);
        return f;
    }

    public static Expr pushNegationToOperands(Expr root) {
        Preconditions.checkNotNull((Object)root);
        if (IS_NOT_PREDICATE.apply((Object)root)) {
            try {
                Method m = ((Expr)root.getChild(0)).getClass().getDeclaredMethod(NEGATE_FN, new Class[0]);
                return Expr.pushNegationToOperands(((Expr)root.getChild(0)).negate());
            }
            catch (NoSuchMethodException e) {
                return root;
            }
        }
        if (root instanceof CompoundPredicate) {
            Expr left = Expr.pushNegationToOperands((Expr)root.getChild(0));
            Expr right = Expr.pushNegationToOperands((Expr)root.getChild(1));
            CompoundPredicate compoundPredicate = new CompoundPredicate(((CompoundPredicate)root).getOp(), left, right);
            compoundPredicate.setPrintSqlInParens(root.getPrintSqlInParens());
            return compoundPredicate;
        }
        return root;
    }

    public Expr negate() {
        Preconditions.checkState((boolean)this.type.equals(Type.BOOLEAN));
        return new CompoundPredicate(CompoundPredicate.Operator.NOT, this, null);
    }

    public Subquery getSubquery() {
        if (!this.contains(Subquery.class)) {
            return null;
        }
        ArrayList subqueries = Lists.newArrayList();
        this.collect(Subquery.class, subqueries);
        Preconditions.checkState((subqueries.size() == 1 ? 1 : 0) != 0, (Object)("only support one subquery in " + this.toSql()));
        return (Subquery)subqueries.get(0);
    }

    public boolean isCorrelatedPredicate(List<TupleId> tupleIdList) {
        if (this instanceof SlotRef && !this.isBoundByTupleIds(tupleIdList)) {
            return true;
        }
        for (Expr child : this.getChildren()) {
            if (!child.isCorrelatedPredicate(tupleIdList)) continue;
            return true;
        }
        return false;
    }

    public void write(DataOutput out) throws IOException {
        throw new IOException("Not implemented serializable ");
    }

    public void readFields(DataInput in) throws IOException {
        throw new IOException("Not implemented serializable ");
    }

    public static void writeTo(Expr expr, DataOutput output) throws IOException {
        if (expr instanceof SlotRef) {
            output.writeInt(ExprSerCode.SLOT_REF.getCode());
        } else if (expr instanceof NullLiteral) {
            output.writeInt(ExprSerCode.NULL_LITERAL.getCode());
        } else if (expr instanceof BoolLiteral) {
            output.writeInt(ExprSerCode.BOOL_LITERAL.getCode());
        } else if (expr instanceof IntLiteral) {
            output.writeInt(ExprSerCode.INT_LITERAL.getCode());
        } else if (expr instanceof LargeIntLiteral) {
            output.writeInt(ExprSerCode.LARGE_INT_LITERAL.getCode());
        } else if (expr instanceof FloatLiteral) {
            output.writeInt(ExprSerCode.FLOAT_LITERAL.getCode());
        } else if (expr instanceof DecimalLiteral) {
            output.writeInt(ExprSerCode.DECIMAL_LITERAL.getCode());
        } else if (expr instanceof StringLiteral) {
            output.writeInt(ExprSerCode.STRING_LITERAL.getCode());
        } else if (expr instanceof MaxLiteral) {
            output.writeInt(ExprSerCode.MAX_LITERAL.getCode());
        } else if (expr instanceof BinaryPredicate) {
            output.writeInt(ExprSerCode.BINARY_PREDICATE.getCode());
        } else if (expr instanceof FunctionCallExpr) {
            output.writeInt(ExprSerCode.FUNCTION_CALL.getCode());
        } else if (expr instanceof ArrayLiteral) {
            output.writeInt(ExprSerCode.ARRAY_LITERAL.getCode());
        } else if (expr instanceof CastExpr) {
            output.writeInt(ExprSerCode.CAST_EXPR.getCode());
        } else {
            throw new IOException("Unknown class " + expr.getClass().getName());
        }
        expr.write(output);
    }

    public static Expr readIn(DataInput in) throws IOException {
        int code = in.readInt();
        ExprSerCode exprSerCode = ExprSerCode.fromCode(code);
        if (exprSerCode == null) {
            throw new IOException("Unknown code: " + code);
        }
        switch (exprSerCode) {
            case SLOT_REF: {
                return SlotRef.read(in);
            }
            case NULL_LITERAL: {
                return NullLiteral.read(in);
            }
            case BOOL_LITERAL: {
                return BoolLiteral.read(in);
            }
            case INT_LITERAL: {
                return IntLiteral.read(in);
            }
            case LARGE_INT_LITERAL: {
                return LargeIntLiteral.read(in);
            }
            case FLOAT_LITERAL: {
                return FloatLiteral.read(in);
            }
            case DECIMAL_LITERAL: {
                return DecimalLiteral.read(in);
            }
            case STRING_LITERAL: {
                return StringLiteral.read(in);
            }
            case MAX_LITERAL: {
                return MaxLiteral.read(in);
            }
            case BINARY_PREDICATE: {
                return BinaryPredicate.read(in);
            }
            case FUNCTION_CALL: {
                return FunctionCallExpr.read(in);
            }
            case ARRAY_LITERAL: {
                return ArrayLiteral.read(in);
            }
            case CAST_EXPR: {
                return CastExpr.read(in);
            }
        }
        throw new IOException("Unknown code: " + code);
    }

    public boolean supportSerializable() {
        return false;
    }

    protected void recursiveResetChildrenResult() throws AnalysisException {
        for (int i = 0; i < this.children.size(); ++i) {
            Expr child = (Expr)this.children.get(i);
            Expr newChild = child.getResultValue();
            if (newChild == child) continue;
            this.setChild(i, newChild);
        }
    }

    public Expr getResultValue() throws AnalysisException {
        this.recursiveResetChildrenResult();
        Expr newExpr = ExpressionFunctions.INSTANCE.evalExpr(this);
        return newExpr != null ? newExpr : this;
    }

    public String getStringValue() {
        if (this instanceof LiteralExpr) {
            return ((LiteralExpr)this).getStringValue();
        }
        return "";
    }

    public static Expr getFirstBoundChild(Expr expr, List<TupleId> tids) {
        for (Expr child : expr.getChildren()) {
            if (!child.isBoundByTupleIds(tids)) continue;
            return child;
        }
        return null;
    }

    public boolean isContainsFunction(String functionName) {
        if (this.fn == null) {
            return false;
        }
        if (this.fn.functionName().equalsIgnoreCase(functionName)) {
            return true;
        }
        for (Expr child : this.children) {
            if (!child.isContainsFunction(functionName)) continue;
            return true;
        }
        return false;
    }

    public boolean isContainsClass(String className) {
        if (this.getClass().getName().equalsIgnoreCase(className)) {
            return true;
        }
        for (Expr child : this.children) {
            if (!child.isContainsClass(className)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasNullableChild() {
        for (Expr expr : this.children) {
            if (!expr.isNullable()) continue;
            return true;
        }
        return false;
    }

    public boolean isNullable() {
        if (this.fn == null) {
            return true;
        }
        switch (this.fn.getNullableMode()) {
            case DEPEND_ON_ARGUMENT: {
                return this.hasNullableChild();
            }
            case ALWAYS_NOT_NULLABLE: {
                return false;
            }
            case CUSTOM: {
                return this.customNullableAlgorithm();
            }
        }
        return true;
    }

    private boolean customNullableAlgorithm() {
        Preconditions.checkState((this.fn.getNullableMode() == Function.NullableMode.CUSTOM ? 1 : 0) != 0);
        if (this.fn.functionName().equalsIgnoreCase("if")) {
            Preconditions.checkState((this.children.size() == 3 ? 1 : 0) != 0);
            for (int i = 1; i < this.children.size(); ++i) {
                if (!((Expr)this.children.get(i)).isNullable()) continue;
                return true;
            }
            return false;
        }
        if (this.fn.functionName().equalsIgnoreCase("ifnull")) {
            Preconditions.checkState((this.children.size() == 2 ? 1 : 0) != 0);
            if (((Expr)this.children.get(0)).isNullable()) {
                return ((Expr)this.children.get(1)).isNullable();
            }
            return false;
        }
        if (this.fn.functionName().equalsIgnoreCase("coalesce")) {
            for (Expr expr : this.children) {
                if (expr.isNullable()) continue;
                return false;
            }
            return true;
        }
        if (this.fn.functionName().equalsIgnoreCase("concat_ws")) {
            return ((Expr)this.children.get(0)).isNullable();
        }
        return true;
    }

    static enum ExprSerCode {
        SLOT_REF(1),
        NULL_LITERAL(2),
        BOOL_LITERAL(3),
        INT_LITERAL(4),
        LARGE_INT_LITERAL(5),
        FLOAT_LITERAL(6),
        DECIMAL_LITERAL(7),
        STRING_LITERAL(8),
        DATE_LITERAL(9),
        MAX_LITERAL(10),
        BINARY_PREDICATE(11),
        FUNCTION_CALL(12),
        ARRAY_LITERAL(13),
        CAST_EXPR(14);

        private static Map<Integer, ExprSerCode> codeMap;
        private int code;

        private ExprSerCode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static ExprSerCode fromCode(int code) {
            return codeMap.get(code);
        }

        static {
            codeMap = Maps.newHashMap();
            for (ExprSerCode item : ExprSerCode.values()) {
                codeMap.put(item.code, item);
            }
        }
    }
}

