/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.Separator;
import org.apache.doris.analysis.StatementBase;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.FsBroker;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.common.util.PropertyAnalyzer;
import org.apache.doris.common.util.URI;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExportStmt
extends StatementBase {
    private static final Logger LOG = LogManager.getLogger(ExportStmt.class);
    public static final String TABLET_NUMBER_PER_TASK_PROP = "tablet_num_per_task";
    public static final String LABEL = "label";
    private static final String DEFAULT_COLUMN_SEPARATOR = "\t";
    private static final String DEFAULT_LINE_DELIMITER = "\n";
    private static final String DEFAULT_COLUMNS = "";
    private TableName tblName;
    private List<String> partitions;
    private Expr whereExpr;
    private String path;
    private BrokerDesc brokerDesc;
    private Map<String, String> properties = Maps.newHashMap();
    private String columnSeparator;
    private String lineDelimiter;
    private String columns;
    private TableRef tableRef;

    public ExportStmt(TableRef tableRef, Expr whereExpr, String path, Map<String, String> properties, BrokerDesc brokerDesc) {
        this.tableRef = tableRef;
        this.whereExpr = whereExpr;
        this.path = path.trim();
        if (properties != null) {
            this.properties = properties;
        }
        this.brokerDesc = brokerDesc;
        this.columnSeparator = DEFAULT_COLUMN_SEPARATOR;
        this.lineDelimiter = DEFAULT_LINE_DELIMITER;
        this.columns = DEFAULT_COLUMNS;
    }

    public String getColumns() {
        return this.columns;
    }

    public TableName getTblName() {
        return this.tblName;
    }

    public List<String> getPartitions() {
        return this.partitions;
    }

    public Expr getWhereExpr() {
        return this.whereExpr;
    }

    public String getPath() {
        return this.path;
    }

    public BrokerDesc getBrokerDesc() {
        return this.brokerDesc;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    @Override
    public boolean needAuditEncryption() {
        return this.brokerDesc != null;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        this.tableRef = analyzer.resolveTableRef(this.tableRef);
        Preconditions.checkNotNull((Object)this.tableRef);
        this.tableRef.analyze(analyzer);
        this.tblName = this.tableRef.getName();
        PartitionNames partitionNames = this.tableRef.getPartitionNames();
        if (partitionNames != null) {
            if (partitionNames.isTemp()) {
                throw new AnalysisException("Do not support exporting temporary partitions");
            }
            this.partitions = partitionNames.getPartitionNames();
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.tblName.getDb(), this.tblName.getTbl(), PrivPredicate.SELECT)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "EXPORT", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), this.tblName.getDb() + ": " + this.tblName.getTbl());
        }
        this.checkTable(analyzer.getCatalog());
        if (this.brokerDesc == null) {
            this.brokerDesc = new BrokerDesc("local", StorageBackend.StorageType.LOCAL, null);
        }
        this.path = ExportStmt.checkPath(this.path, this.brokerDesc.getStorageType());
        if (this.brokerDesc.getStorageType() == StorageBackend.StorageType.BROKER) {
            if (!analyzer.getCatalog().getBrokerMgr().containsBroker(this.brokerDesc.getName())) {
                throw new AnalysisException("broker " + this.brokerDesc.getName() + " does not exist");
            }
            FsBroker broker = analyzer.getCatalog().getBrokerMgr().getAnyBroker(this.brokerDesc.getName());
            if (broker == null) {
                throw new AnalysisException("failed to get alive broker");
            }
        }
        this.checkProperties(this.properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTable(Catalog catalog) throws AnalysisException {
        Database db = catalog.getDbOrAnalysisException(this.tblName.getDb());
        Table table = db.getTableOrAnalysisException(this.tblName.getTbl());
        table.readLock();
        try {
            if (this.partitions == null) {
                return;
            }
            if (!table.isPartitioned()) {
                throw new AnalysisException("Table[" + this.tblName.getTbl() + "] is not partitioned.");
            }
            Table.TableType tblType = table.getType();
            switch (tblType) {
                case MYSQL: 
                case ODBC: 
                case OLAP: {
                    break;
                }
                default: {
                    throw new AnalysisException("Table[" + this.tblName.getTbl() + "] is " + tblType.toString() + " type, do not support EXPORT.");
                }
            }
            for (String partitionName : this.partitions) {
                Partition partition = table.getPartition(partitionName);
                if (partition != null) continue;
                throw new AnalysisException("Partition [" + partitionName + "] does not exist");
            }
        }
        finally {
            table.readUnlock();
        }
    }

    public static String checkPath(String path, StorageBackend.StorageType type) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)path)) {
            throw new AnalysisException("No dest path specified.");
        }
        URI uri = URI.create(path);
        String schema = uri.getScheme();
        if (type == StorageBackend.StorageType.BROKER) {
            if (schema == null || !schema.equalsIgnoreCase("bos") && !schema.equalsIgnoreCase("afs") && !schema.equalsIgnoreCase("hdfs")) {
                throw new AnalysisException("Invalid export path. please use valid 'HDFS://', 'AFS://' or 'BOS://' path.");
            }
        } else if (type == StorageBackend.StorageType.S3) {
            if (schema == null || !schema.equalsIgnoreCase("s3")) {
                throw new AnalysisException("Invalid export path. please use valid 'S3://' path.");
            }
        } else if (type == StorageBackend.StorageType.HDFS) {
            if (schema == null || !schema.equalsIgnoreCase("hdfs")) {
                throw new AnalysisException("Invalid export path. please use valid 'HDFS://' path.");
            }
        } else if (type == StorageBackend.StorageType.LOCAL) {
            if (schema != null && !schema.equalsIgnoreCase("file")) {
                throw new AnalysisException("Invalid export path. please use valid 'file:///' path.");
            }
            path = path.substring("file:///".length() - 1);
        }
        return path;
    }

    private void checkProperties(Map<String, String> properties) throws UserException {
        this.columnSeparator = Separator.convertSeparator(PropertyAnalyzer.analyzeColumnSeparator(properties, DEFAULT_COLUMN_SEPARATOR));
        this.lineDelimiter = Separator.convertSeparator(PropertyAnalyzer.analyzeLineDelimiter(properties, DEFAULT_LINE_DELIMITER));
        this.columns = properties.get("columns");
        if (properties.containsKey("exec_mem_limit")) {
            try {
                Long.parseLong(properties.get("exec_mem_limit"));
            }
            catch (NumberFormatException e) {
                throw new DdlException("Invalid exec_mem_limit value: " + e.getMessage());
            }
        } else {
            properties.put("exec_mem_limit", String.valueOf(ConnectContext.get().getSessionVariable().getMaxExecMemByte()));
        }
        if (properties.containsKey("timeout")) {
            try {
                Long.parseLong(properties.get("timeout"));
            }
            catch (NumberFormatException e) {
                throw new DdlException("Invalid timeout value: " + e.getMessage());
            }
        } else {
            properties.put("timeout", String.valueOf(Config.export_task_default_timeout_second));
        }
        if (properties.containsKey(TABLET_NUMBER_PER_TASK_PROP)) {
            try {
                Long.parseLong(properties.get(TABLET_NUMBER_PER_TASK_PROP));
            }
            catch (NumberFormatException e) {
                throw new DdlException("Invalid tablet num per task value: " + e.getMessage());
            }
        } else {
            properties.put(TABLET_NUMBER_PER_TASK_PROP, String.valueOf(Config.export_tablet_num_per_task));
        }
        if (properties.containsKey(LABEL)) {
            FeNameFormat.checkLabel(properties.get(LABEL));
        } else {
            String label = "export_" + UUID.randomUUID().toString();
            properties.put(LABEL, label);
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("EXPORT TABLE ");
        if (this.tblName == null) {
            sb.append("non-exist");
        } else {
            sb.append(this.tblName.toSql());
        }
        if (this.partitions != null && !this.partitions.isEmpty()) {
            sb.append(" PARTITION (");
            Joiner.on((String)", ").appendTo(sb, this.partitions);
            sb.append(")");
        }
        sb.append(DEFAULT_LINE_DELIMITER);
        sb.append(" TO ").append("'");
        sb.append(this.path);
        sb.append("'");
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append("\nPROPERTIES (");
            sb.append(new PrintableMap<String, String>(this.properties, "=", true, false));
            sb.append(")");
        }
        if (this.brokerDesc != null) {
            sb.append("\n WITH BROKER '").append(this.brokerDesc.getName()).append("' (");
            sb.append(new PrintableMap<String, String>(this.brokerDesc.getProperties(), "=", true, false, true));
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.FORWARD_WITH_SYNC;
    }

    public String toString() {
        return this.toSql();
    }
}

