/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.Predicate;
import org.apache.doris.analysis.Subquery;
import org.apache.doris.thrift.TExprNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExistsPredicate
extends Predicate {
    private static final Logger LOG = LoggerFactory.getLogger(ExistsPredicate.class);
    private boolean notExists = false;

    public boolean isNotExists() {
        return this.notExists;
    }

    public ExistsPredicate(Subquery subquery, boolean notExists) {
        Preconditions.checkNotNull((Object)subquery);
        this.children.add(subquery);
        this.notExists = notExists;
    }

    public ExistsPredicate(ExistsPredicate other) {
        super(other);
        this.notExists = other.notExists;
    }

    @Override
    public Expr negate() {
        return new ExistsPredicate((Subquery)this.getChild(0), !this.notExists);
    }

    @Override
    protected void toThrift(TExprNode msg) {
        Preconditions.checkState((boolean)false);
    }

    @Override
    public Expr clone() {
        return new ExistsPredicate(this);
    }

    @Override
    public String toSqlImpl() {
        StringBuilder strBuilder = new StringBuilder();
        if (this.notExists) {
            strBuilder.append("NOT ");
        }
        strBuilder.append("EXISTS ");
        strBuilder.append(((Expr)this.getChild(0)).toSql());
        return strBuilder.toString();
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Boolean.hashCode(this.notExists);
    }
}

