/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;

public class EnterStmt
extends DdlStmt {
    private String name;

    public EnterStmt(String name) {
        this.name = name;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        if (Strings.isNullOrEmpty((String)this.name)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NAME_NULL, new Object[0]);
        }
        if (analyzer.getCatalog().getCluster(this.name) == null) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_UNKNOWN_ERROR, this.name);
        }
    }

    @Override
    public String toSql() {
        return super.toSql();
    }

    public String toString() {
        return super.toString();
    }

    @Override
    public String getClusterName() {
        return this.name;
    }

    @Override
    public void setClusterName(String name) {
        this.name = name;
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.NO_FORWARD;
    }
}

