/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.EncryptKeyName;
import org.apache.doris.analysis.Expr;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.EncryptKey;
import org.apache.doris.catalog.Type;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.thrift.TExprNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncryptKeyRef
extends Expr {
    private static final Logger LOG = LogManager.getLogger(EncryptKeyRef.class);
    private EncryptKeyName encryptKeyName;
    private EncryptKey encryptKey;

    public EncryptKeyRef(EncryptKeyName encryptKeyName) {
        this.encryptKeyName = encryptKeyName;
        this.type = Type.VARCHAR;
    }

    protected EncryptKeyRef(EncryptKeyRef other) {
        super(other);
        this.encryptKeyName = other.encryptKeyName;
        this.encryptKey = other.encryptKey;
    }

    public EncryptKey getEncryptKey() {
        return this.encryptKey;
    }

    private void analyzeEncryptKey(Analyzer analyzer) throws AnalysisException {
        String dbName = this.encryptKeyName.getDb();
        if (Strings.isNullOrEmpty((String)dbName)) {
            dbName = analyzer.getDefaultDb();
        }
        if ("".equals(dbName)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
        } else {
            dbName = ClusterNamespace.getFullName(analyzer.getClusterName(), dbName);
            Database database = analyzer.getCatalog().getDbOrAnalysisException(dbName);
            EncryptKey encryptKey = database.getEncryptKey(this.encryptKeyName.getKeyName());
            if (encryptKey != null) {
                this.encryptKey = encryptKey;
            } else {
                throw new AnalysisException("Can not found encryptKey: " + this.encryptKeyName.toString());
            }
        }
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        this.encryptKeyName.analyze(analyzer);
        this.analyzeEncryptKey(analyzer);
    }

    @Override
    protected String toSqlImpl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.encryptKeyName.toSql());
        return sb.toString();
    }

    @Override
    protected void toThrift(TExprNode msg) {
    }

    @Override
    public Expr clone() {
        return new EncryptKeyRef(this);
    }
}

