/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncryptKeyName
implements Writable {
    private static final Logger LOG = LogManager.getLogger(EncryptKeyName.class);
    @SerializedName(value="db")
    private String db;
    @SerializedName(value="keyName")
    private String keyName;

    public EncryptKeyName(String db, String keyName) {
        this.db = db;
        this.keyName = keyName.toLowerCase();
        if (db != null) {
            this.db = db.toLowerCase();
        }
    }

    public EncryptKeyName(String keyName) {
        this.db = null;
        this.keyName = keyName.toLowerCase();
    }

    public void analyze(Analyzer analyzer) throws AnalysisException {
        FeNameFormat.checkCommonName("EncryptKey", this.keyName);
        if (this.db == null) {
            this.db = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)this.db)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            if (Strings.isNullOrEmpty((String)analyzer.getClusterName())) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NAME_NULL, new Object[0]);
            }
            this.db = ClusterNamespace.getFullName(analyzer.getClusterName(), this.db);
        }
    }

    public String getDb() {
        return this.db;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String toString() {
        if (this.db == null) {
            return this.keyName;
        }
        return ClusterNamespace.getNameFromFullName(this.db) + "." + this.keyName;
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static EncryptKeyName read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (EncryptKeyName)GsonUtils.GSON.fromJson(json, EncryptKeyName.class);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EncryptKeyName)) {
            return false;
        }
        EncryptKeyName o = (EncryptKeyName)obj;
        if ((this.db == null || o.db == null) && this.db != o.db) {
            if (this.db == null && o.db != null) {
                return false;
            }
            if (this.db != null && o.db == null) {
                return false;
            }
            if (!this.db.equalsIgnoreCase(o.db)) {
                return false;
            }
        }
        return this.keyName.equalsIgnoreCase(o.keyName);
    }

    public int hashCode() {
        return 31 * Objects.hashCode(this.db) + Objects.hashCode(this.keyName);
    }

    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("KEY ");
        if (this.db != null) {
            sb.append(ClusterNamespace.getNameFromFullName(this.db)).append(".");
        }
        sb.append(this.keyName);
        return sb.toString();
    }
}

