/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.PrintableMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnableFeatureClause
extends AlterTableClause {
    private static final Logger LOG = LogManager.getLogger(EnableFeatureClause.class);
    private String featureName;
    private boolean needSchemaChange;
    private Features feature;
    private Map<String, String> properties;

    public EnableFeatureClause(String featureName) {
        this(featureName, null);
    }

    public EnableFeatureClause(String featureName, Map<String, String> properties) {
        super(AlterOpType.ENABLE_FEATURE);
        this.featureName = featureName;
        this.needSchemaChange = false;
        this.properties = properties;
    }

    public boolean needSchemaChange() {
        return this.needSchemaChange;
    }

    public Features getFeature() {
        return this.feature;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        switch (this.featureName.toUpperCase()) {
            case "BATCH_DELETE": {
                this.needSchemaChange = true;
                this.feature = Features.BATCH_DELETE;
                break;
            }
            case "SEQUENCE_LOAD": {
                this.needSchemaChange = true;
                this.feature = Features.SEQUENCE_LOAD;
                if (this.properties != null && !this.properties.isEmpty()) break;
                throw new AnalysisException("Properties is not set");
            }
            default: {
                throw new AnalysisException("unknown feature name: " + this.featureName);
            }
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("ENABLE FEATURE \"").append(this.featureName).append("\"");
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append(" WITH PROPERTIES (");
            sb.append(new PrintableMap<String, String>(this.properties, "=", true, false));
            sb.append(")");
        }
        return sb.toString();
    }

    public static enum Features {
        BATCH_DELETE,
        SEQUENCE_LOAD,
        UNKNOWN;

    }
}

