/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class DropTableStmt
extends DdlStmt {
    private boolean ifExists;
    private final TableName tableName;
    private final boolean isView;
    private boolean forceDrop;

    public DropTableStmt(boolean ifExists, TableName tableName, boolean forceDrop) {
        this.ifExists = ifExists;
        this.tableName = tableName;
        this.isView = false;
        this.forceDrop = forceDrop;
    }

    public DropTableStmt(boolean ifExists, TableName tableName, boolean isView, boolean forceDrop) {
        this.ifExists = ifExists;
        this.tableName = tableName;
        this.isView = isView;
        this.forceDrop = forceDrop;
    }

    public boolean isSetIfExists() {
        return this.ifExists;
    }

    public String getDbName() {
        return this.tableName.getDb();
    }

    public String getTableName() {
        return this.tableName.getTbl();
    }

    public boolean isView() {
        return this.isView;
    }

    public boolean isForceDrop() {
        return this.forceDrop;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        if (Strings.isNullOrEmpty((String)this.tableName.getDb())) {
            this.tableName.setDb(analyzer.getDefaultDb());
        }
        this.tableName.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.tableName.getDb(), this.tableName.getTbl(), PrivPredicate.DROP)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "DROP");
        }
    }

    @Override
    public String toSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DROP TABLE ").append(this.tableName.toSql());
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

