/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.parquet.Strings;

public class DropSqlBlockRuleStmt
extends DdlStmt {
    private List<String> ruleNames;

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
    }

    public DropSqlBlockRuleStmt(List<String> ruleNames) {
        this.ruleNames = ruleNames;
    }

    public List<String> getRuleNames() {
        return this.ruleNames;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("DROP SQL_BLOCK_RULE ").append(Strings.join(this.ruleNames, (String)","));
        return sb.toString();
    }
}

