/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.common.AnalysisException;

public class DropRollupClause
extends AlterTableClause {
    private final String rollupName;
    private Map<String, String> properties;

    public DropRollupClause(String rollupName, Map<String, String> properties) {
        super(AlterOpType.DROP_ROLLUP);
        this.rollupName = rollupName;
        this.properties = properties;
        this.needTableStable = false;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.rollupName)) {
            throw new AnalysisException("No rollup in delete rollup.");
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String toSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DROP ROLLUP ");
        stringBuilder.append("`").append(this.rollupName).append("`");
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toSql();
    }

    public String getRollupName() {
        return this.rollupName;
    }
}

