/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class DropMaterializedViewStmt
extends DdlStmt {
    private String mvName;
    private TableName tableName;
    private boolean ifExists;

    public DropMaterializedViewStmt(boolean ifExists, String mvName, TableName tableName) {
        this.mvName = mvName;
        this.tableName = tableName;
        this.ifExists = ifExists;
    }

    public String getMvName() {
        return this.mvName;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        if (Strings.isNullOrEmpty((String)this.mvName)) {
            throw new AnalysisException("The materialized name could not be empty or null.");
        }
        this.tableName.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.tableName.getDb(), this.tableName.getTbl(), PrivPredicate.DROP)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "DROP");
        }
    }

    @Override
    public String toSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DROP MATERIALIZED VIEW ");
        if (this.ifExists) {
            stringBuilder.append("IF EXISTS ");
        }
        stringBuilder.append("`").append(this.mvName).append("` ");
        stringBuilder.append("ON ").append(this.tableName.toSql());
        return stringBuilder.toString();
    }
}

