/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.TableName;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;

public class DropIndexClause
extends AlterTableClause {
    private final String indexName;
    private final TableName tableName;
    private boolean ifExists;
    private boolean alter;

    public DropIndexClause(String indexName, boolean ifExists, TableName tableName, boolean alter) {
        super(AlterOpType.SCHEMA_CHANGE);
        this.indexName = indexName;
        this.ifExists = ifExists;
        this.tableName = tableName;
        this.alter = alter;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public boolean isSetIfExists() {
        return this.ifExists;
    }

    public boolean isAlter() {
        return this.alter;
    }

    @Override
    public Map<String, String> getProperties() {
        return null;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        if (StringUtils.isEmpty((String)this.indexName)) {
            throw new AnalysisException("index name is excepted");
        }
    }

    @Override
    public String toSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DROP INDEX ").append(this.indexName);
        if (!this.alter) {
            stringBuilder.append(" ON ").append(this.tableName.toSql());
        }
        return stringBuilder.toString();
    }
}

