/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.FunctionArgsDef;
import org.apache.doris.analysis.FunctionName;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.FunctionSearchDesc;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class DropFunctionStmt
extends DdlStmt {
    private final FunctionName functionName;
    private final FunctionArgsDef argsDef;
    private FunctionSearchDesc function;

    public DropFunctionStmt(FunctionName functionName, FunctionArgsDef argsDef) {
        this.functionName = functionName;
        this.argsDef = argsDef;
    }

    public FunctionName getFunctionName() {
        return this.functionName;
    }

    public FunctionSearchDesc getFunction() {
        return this.function;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        this.functionName.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
        this.argsDef.analyze(analyzer);
        this.function = new FunctionSearchDesc(this.functionName, this.argsDef.getArgTypes(), this.argsDef.isVariadic());
    }

    @Override
    public String toSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DROP FUNCTION ").append(this.functionName).append(this.argsDef);
        return stringBuilder.toString();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.FORWARD_WITH_SYNC;
    }
}

