/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.Optional;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class DropFileStmt
extends DdlStmt {
    public static final String PROP_CATALOG = "catalog";
    private String fileName;
    private String dbName;
    private Map<String, String> properties;
    private String catalogName;

    public DropFileStmt(String fileName, String dbName, Map<String, String> properties) {
        this.fileName = fileName;
        this.dbName = dbName;
        this.properties = properties;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
        if (this.dbName == null) {
            this.dbName = analyzer.getDefaultDb();
        } else {
            if (Strings.isNullOrEmpty((String)analyzer.getClusterName())) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NAME_NULL, new Object[0]);
            }
            this.dbName = ClusterNamespace.getFullName(analyzer.getClusterName(), this.dbName);
        }
        if (Strings.isNullOrEmpty((String)this.dbName)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
        }
        if (Strings.isNullOrEmpty((String)this.fileName)) {
            throw new AnalysisException("File name is not specified");
        }
        Optional<String> optional = this.properties.keySet().stream().filter(entity -> !PROP_CATALOG.equals(entity)).findFirst();
        if (optional.isPresent()) {
            throw new AnalysisException(optional.get() + " is invalid property");
        }
        this.catalogName = this.properties.get(PROP_CATALOG);
        if (Strings.isNullOrEmpty((String)this.catalogName)) {
            throw new AnalysisException("catalog name is missing");
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("DROP FILE \"").append(this.fileName).append("\"");
        if (this.dbName != null) {
            sb.append(" FROM ").append(this.dbName);
        }
        sb.append(" PROPERTIES(");
        PrintableMap<String, String> map = new PrintableMap<String, String>(this.properties, ",", true, false);
        sb.append(map.toString());
        return sb.toString();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.FORWARD_WITH_SYNC;
    }
}

