/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.EncryptKeyName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.EncryptKeySearchDesc;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class DropEncryptKeyStmt
extends DdlStmt {
    private final EncryptKeyName encryptKeyName;
    private EncryptKeySearchDesc encryptKeySearchDesc;

    public DropEncryptKeyStmt(EncryptKeyName encryptKeyName) {
        this.encryptKeyName = encryptKeyName;
    }

    public EncryptKeyName getEncryptKeyName() {
        return this.encryptKeyName;
    }

    public EncryptKeySearchDesc getEncryptKeysSearchDesc() {
        return this.encryptKeySearchDesc;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
        this.encryptKeyName.analyze(analyzer);
        this.encryptKeySearchDesc = new EncryptKeySearchDesc(this.encryptKeyName);
    }

    @Override
    public String toSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DROP ENCRYPTKEY ").append(this.encryptKeyName.getKeyName());
        return stringBuilder.toString();
    }
}

