/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;

public class DropColumnClause
extends AlterTableClause {
    private String colName;
    private String rollupName;
    private Map<String, String> properties;

    public String getColName() {
        return this.colName;
    }

    public String getRollupName() {
        return this.rollupName;
    }

    public DropColumnClause(String colName, String rollupName, Map<String, String> properties) {
        super(AlterOpType.SCHEMA_CHANGE);
        this.colName = colName;
        this.rollupName = rollupName;
        this.properties = properties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.colName)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_WRONG_COLUMN_NAME, this.colName);
        }
        if (Strings.isNullOrEmpty((String)this.rollupName)) {
            this.rollupName = null;
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("DROP COLUMN `").append(this.colName).append("`");
        if (this.rollupName != null) {
            sb.append(" IN `").append(this.rollupName).append("`");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

