/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

@Deprecated
public class DropClusterStmt
extends DdlStmt {
    private boolean ifExists;
    private String name;

    public DropClusterStmt(boolean ifExists, String name) {
        this.ifExists = ifExists;
        this.name = name;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        if (Config.disable_cluster_feature) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_INVALID_OPERATION, "DROP CLUSTER");
        }
        if (Strings.isNullOrEmpty((String)this.name)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NAME_NULL, new Object[0]);
        }
        if (this.name.equalsIgnoreCase("default_cluster")) {
            throw new AnalysisException("Can not drop default_cluster");
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.OPERATOR)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NO_PERMISSIONS, new Object[0]);
        }
    }

    @Override
    public String toSql() {
        return "DROP CLUSTER " + this.name;
    }

    @Override
    public String getClusterName() {
        return this.name;
    }

    @Override
    public void setClusterName(String clusterName) {
        this.name = clusterName;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

