/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotId;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.IdGenerator;
import org.apache.doris.thrift.TDescriptorTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DescriptorTable {
    private static final Logger LOG = LogManager.getLogger(DescriptorTable.class);
    private final HashMap<TupleId, TupleDescriptor> tupleDescs = new HashMap();
    private final List<Table> referencedTables = new ArrayList<Table>();
    private final IdGenerator<TupleId> tupleIdGenerator_ = TupleId.createGenerator();
    private final IdGenerator<SlotId> slotIdGenerator_ = SlotId.createGenerator();
    private final HashMap<SlotId, SlotDescriptor> slotDescs = Maps.newHashMap();

    public TupleDescriptor createTupleDescriptor() {
        TupleDescriptor d = new TupleDescriptor(this.tupleIdGenerator_.getNextId());
        this.tupleDescs.put(d.getId(), d);
        return d;
    }

    public TupleDescriptor createTupleDescriptor(String debugName) {
        TupleDescriptor d = new TupleDescriptor(this.tupleIdGenerator_.getNextId(), debugName);
        this.tupleDescs.put(d.getId(), d);
        return d;
    }

    public SlotDescriptor addSlotDescriptor(TupleDescriptor d) {
        SlotDescriptor result = new SlotDescriptor(this.slotIdGenerator_.getNextId(), d);
        d.addSlot(result);
        this.slotDescs.put(result.getId(), result);
        return result;
    }

    public TupleDescriptor copyTupleDescriptor(TupleId srcId, String debugName) {
        TupleDescriptor d = new TupleDescriptor(this.tupleIdGenerator_.getNextId(), debugName);
        this.tupleDescs.put(d.getId(), d);
        TupleDescriptor src = this.tupleDescs.get(srcId);
        for (SlotDescriptor slot : src.getSlots()) {
            this.copySlotDescriptor(d, slot);
        }
        d.computeStatAndMemLayout();
        return d;
    }

    public SlotDescriptor copySlotDescriptor(TupleDescriptor dest, SlotDescriptor src) {
        SlotDescriptor result = new SlotDescriptor(this.slotIdGenerator_.getNextId(), dest, src);
        dest.addSlot(result);
        this.slotDescs.put(result.getId(), result);
        return result;
    }

    public TupleDescriptor getTupleDesc(TupleId id) {
        return this.tupleDescs.get(id);
    }

    public List<TupleDescriptor> getTupleDesc(List<TupleId> idList) throws AnalysisException {
        ArrayList result = Lists.newArrayList();
        for (TupleId tupleId : idList) {
            TupleDescriptor tupleDescriptor = this.getTupleDesc(tupleId);
            if (tupleDescriptor == null) {
                throw new AnalysisException("Invalid tuple id:" + tupleId.toString());
            }
            result.add(tupleDescriptor);
        }
        return result;
    }

    public SlotDescriptor getSlotDesc(SlotId id) {
        return this.slotDescs.get(id);
    }

    public Collection<TupleDescriptor> getTupleDescs() {
        return this.tupleDescs.values();
    }

    public void addReferencedTable(Table table) {
        this.referencedTables.add(table);
    }

    public void markSlotsMaterialized(List<SlotId> ids) {
        for (SlotId id : ids) {
            this.getSlotDesc(id).setIsMaterialized(true);
        }
    }

    @Deprecated
    public void computeMemLayout() {
        for (TupleDescriptor d : this.tupleDescs.values()) {
            d.computeMemLayout();
        }
    }

    public void computeStatAndMemLayout() {
        for (TupleDescriptor d : this.tupleDescs.values()) {
            d.computeStatAndMemLayout();
        }
    }

    public TDescriptorTable toThrift() {
        TDescriptorTable result = new TDescriptorTable();
        HashSet referencedTbls = Sets.newHashSet();
        for (TupleDescriptor tupleD : this.tupleDescs.values()) {
            if (!tupleD.getIsMaterialized()) continue;
            result.addToTupleDescriptors(tupleD.toThrift());
            if (tupleD.getTable() != null && tupleD.getTable().getId() >= 0L) {
                referencedTbls.add(tupleD.getTable());
            }
            for (SlotDescriptor slotD : tupleD.getMaterializedSlots()) {
                result.addToSlotDescriptors(slotD.toThrift());
            }
        }
        for (Table table : this.referencedTables) {
            referencedTbls.add(table);
        }
        for (Table tbl : referencedTbls) {
            result.addToTableDescriptors(tbl.toThrift());
        }
        return result;
    }

    public String debugString() {
        StringBuilder out = new StringBuilder();
        out.append("tuples:\n");
        for (TupleDescriptor tupleDescriptor : this.tupleDescs.values()) {
            out.append(tupleDescriptor + "\n");
        }
        out.append("\n ");
        out.append("slotDesc size: " + this.slotDescs.size() + "\n");
        for (SlotDescriptor slotDescriptor : this.slotDescs.values()) {
            out.append(slotDescriptor.debugString());
            out.append("\n");
        }
        out.append("\n ");
        return out.toString();
    }

    public String getExplainString() {
        StringBuilder out = new StringBuilder();
        out.append("\nTuples:\n");
        for (TupleDescriptor desc : this.tupleDescs.values()) {
            out.append(desc.getExplainString() + "\n");
        }
        return out.toString();
    }
}

