/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndexMeta;
import org.apache.doris.catalog.MysqlTable;
import org.apache.doris.catalog.OdbcTable;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.UserException;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.ProcService;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;

public class DescribeStmt
extends ShowStmt {
    private static final ShowResultSetMetaData DESC_OLAP_TABLE_ALL_META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("IndexName", ScalarType.createVarchar(20))).addColumn(new Column("IndexKeysType", ScalarType.createVarchar(20))).addColumn(new Column("Field", ScalarType.createVarchar(20))).addColumn(new Column("Type", ScalarType.createVarchar(20))).addColumn(new Column("Null", ScalarType.createVarchar(10))).addColumn(new Column("Key", ScalarType.createVarchar(10))).addColumn(new Column("Default", ScalarType.createVarchar(30))).addColumn(new Column("Extra", ScalarType.createVarchar(30))).addColumn(new Column("Visible", ScalarType.createVarchar(10))).build();
    private static final ShowResultSetMetaData DESC_MYSQL_TABLE_ALL_META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("Host", ScalarType.createVarchar(30))).addColumn(new Column("Port", ScalarType.createVarchar(10))).addColumn(new Column("User", ScalarType.createVarchar(30))).addColumn(new Column("Password", ScalarType.createVarchar(30))).addColumn(new Column("Database", ScalarType.createVarchar(30))).addColumn(new Column("Table", ScalarType.createVarchar(30))).build();
    private static final List<String> EMPTY_ROW = DescribeStmt.initEmptyRow();
    private TableName dbTableName;
    private ProcNodeInterface node;
    List<List<String>> totalRows;
    private boolean isAllTables;
    private boolean isOlapTable;

    public DescribeStmt(TableName dbTableName, boolean isAllTables) {
        this.dbTableName = dbTableName;
        this.totalRows = new LinkedList<List<String>>();
        this.isAllTables = isAllTables;
    }

    public boolean isAllTables() {
        return this.isAllTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        this.dbTableName.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.dbTableName.getDb(), this.dbTableName.getTbl(), PrivPredicate.SHOW)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "DESCRIBE", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), this.dbTableName.getDb() + ": " + this.dbTableName.getTbl());
        }
        Database db = Catalog.getCurrentCatalog().getDbOrAnalysisException(this.dbTableName.getDb());
        Table table = db.getTableOrAnalysisException(this.dbTableName.getTbl());
        table.readLock();
        try {
            if (!this.isAllTables) {
                String procString = "/dbs/" + db.getId() + "/" + table.getId() + "/" + "index_schema" + "/";
                procString = table.getType() == Table.TableType.OLAP ? procString + ((OlapTable)table).getBaseIndexId() : procString + table.getId();
                this.node = ProcService.getInstance().open(procString);
                if (this.node == null) {
                    throw new AnalysisException("Describe table[" + this.dbTableName.getTbl() + "] failed");
                }
            } else if (table.getType() == Table.TableType.OLAP) {
                this.isOlapTable = true;
                OlapTable olapTable = (OlapTable)table;
                Set<String> bfColumns = olapTable.getCopiedBfColumns();
                Map<Long, List<Column>> indexIdToSchema = olapTable.getIndexIdToSchema();
                ArrayList indices = Lists.newArrayList();
                indices.add(olapTable.getBaseIndexId());
                for (Long indexId : indexIdToSchema.keySet()) {
                    if (indexId.longValue() == olapTable.getBaseIndexId()) continue;
                    indices.add(indexId);
                }
                for (int i = 0; i < indices.size(); ++i) {
                    long indexId = (Long)indices.get(i);
                    List<Column> columns = indexIdToSchema.get(indexId);
                    String indexName = olapTable.getIndexNameById(indexId);
                    MaterializedIndexMeta indexMeta = olapTable.getIndexMetaByIndexId(indexId);
                    for (int j = 0; j < columns.size(); ++j) {
                        Column column = columns.get(j);
                        ArrayList extras = Lists.newArrayList();
                        if (column.getAggregationType() != null) {
                            extras.add(column.getAggregationType().name());
                        }
                        if (bfColumns != null && bfColumns.contains(column.getName())) {
                            extras.add("BLOOM_FILTER");
                        }
                        String extraStr = StringUtils.join((Collection)extras, (String)",");
                        List<String> row = Arrays.asList("", "", column.getDisplayName(), column.getOriginType().toString(), column.isAllowNull() ? "Yes" : "No", Boolean.valueOf(column.isKey()).toString(), column.getDefaultValue() == null ? FeConstants.null_string : column.getDefaultValue(), extraStr, Boolean.valueOf(column.isVisible()).toString());
                        if (j == 0) {
                            row.set(0, indexName);
                            row.set(1, indexMeta.getKeysType().name());
                        }
                        this.totalRows.add(row);
                    }
                    if (i == indices.size() - 1) continue;
                    this.totalRows.add(EMPTY_ROW);
                }
            } else if (table.getType() == Table.TableType.ODBC) {
                this.isOlapTable = false;
                OdbcTable odbcTable = (OdbcTable)table;
                List<String> row = Arrays.asList(odbcTable.getHost(), odbcTable.getPort(), odbcTable.getUserName(), odbcTable.getPasswd(), odbcTable.getOdbcDatabaseName(), odbcTable.getOdbcTableName(), odbcTable.getOdbcDriver(), odbcTable.getOdbcTableTypeName());
                this.totalRows.add(row);
            } else if (table.getType() == Table.TableType.MYSQL) {
                this.isOlapTable = false;
                MysqlTable mysqlTable = (MysqlTable)table;
                List<String> row = Arrays.asList(mysqlTable.getHost(), mysqlTable.getPort(), mysqlTable.getUserName(), mysqlTable.getPasswd(), mysqlTable.getMysqlDatabaseName(), mysqlTable.getMysqlTableName());
                this.totalRows.add(row);
            } else {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_UNKNOWN_STORAGE_ENGINE, new Object[]{table.getType()});
            }
        }
        finally {
            table.readUnlock();
        }
    }

    public String getTableName() {
        return this.dbTableName.getTbl();
    }

    public String getDb() {
        return this.dbTableName.getDb();
    }

    public List<List<String>> getResultRows() throws AnalysisException {
        if (this.isAllTables) {
            return this.totalRows;
        }
        Preconditions.checkNotNull((Object)this.node);
        return this.node.fetchResult().getRows();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        if (!this.isAllTables) {
            ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
            ProcResult result = null;
            try {
                result = this.node.fetchResult();
            }
            catch (AnalysisException e) {
                return builder.build();
            }
            for (String col : result.getColumnNames()) {
                builder.addColumn(new Column(col, ScalarType.createVarchar(30)));
            }
            return builder.build();
        }
        if (this.isOlapTable) {
            return DESC_OLAP_TABLE_ALL_META_DATA;
        }
        return DESC_MYSQL_TABLE_ALL_META_DATA;
    }

    @Override
    public String toSql() {
        return "DESCRIBE `" + this.dbTableName + "`" + (this.isAllTables ? " ALL" : "");
    }

    public String toString() {
        return this.toSql();
    }

    private static List<String> initEmptyRow() {
        ArrayList<String> emptyRow = new ArrayList<String>(DESC_OLAP_TABLE_ALL_META_DATA.getColumns().size());
        for (int i = 0; i < DESC_OLAP_TABLE_ALL_META_DATA.getColumns().size(); ++i) {
            emptyRow.add("");
        }
        return emptyRow;
    }
}

