/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.InPredicate;
import org.apache.doris.analysis.IsNullPredicate;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.Predicate;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class DeleteStmt
extends DdlStmt {
    private final TableName tbl;
    private final PartitionNames partitionNames;
    private Expr wherePredicate;
    private List<Predicate> deleteConditions;

    public DeleteStmt(TableName tableName, PartitionNames partitionNames, Expr wherePredicate) {
        this.tbl = tableName;
        this.partitionNames = partitionNames;
        this.wherePredicate = wherePredicate;
        this.deleteConditions = new LinkedList<Predicate>();
    }

    public String getTableName() {
        return this.tbl.getTbl();
    }

    public String getDbName() {
        return this.tbl.getDb();
    }

    public List<String> getPartitionNames() {
        return this.partitionNames == null ? Lists.newArrayList() : this.partitionNames.getPartitionNames();
    }

    public List<Predicate> getDeleteConditions() {
        return this.deleteConditions;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (this.tbl == null) {
            throw new AnalysisException("Table is not set");
        }
        this.tbl.analyze(analyzer);
        if (this.partitionNames != null) {
            this.partitionNames.analyze(analyzer);
            if (this.partitionNames.isTemp()) {
                throw new AnalysisException("Do not support deleting temp partitions");
            }
        }
        if (this.wherePredicate == null) {
            throw new AnalysisException("Where clause is not set");
        }
        this.analyzePredicate(this.wherePredicate);
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.tbl.getDb(), this.tbl.getTbl(), PrivPredicate.LOAD)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "LOAD", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), this.tbl.getDb() + ": " + this.tbl.getTbl());
        }
    }

    private void analyzePredicate(Expr predicate) throws AnalysisException {
        if (predicate instanceof BinaryPredicate) {
            BinaryPredicate binaryPredicate = (BinaryPredicate)predicate;
            Expr leftExpr = (Expr)binaryPredicate.getChild(0);
            if (!(leftExpr instanceof SlotRef)) {
                throw new AnalysisException("Left expr of binary predicate should be column name");
            }
            Expr rightExpr = (Expr)binaryPredicate.getChild(1);
            if (!(rightExpr instanceof LiteralExpr)) {
                throw new AnalysisException("Right expr of binary predicate should be value");
            }
            this.deleteConditions.add(binaryPredicate);
        } else if (predicate instanceof CompoundPredicate) {
            CompoundPredicate compoundPredicate = (CompoundPredicate)predicate;
            if (compoundPredicate.getOp() != CompoundPredicate.Operator.AND) {
                throw new AnalysisException("Compound predicate's op should be AND");
            }
            this.analyzePredicate((Expr)compoundPredicate.getChild(0));
            this.analyzePredicate((Expr)compoundPredicate.getChild(1));
        } else if (predicate instanceof IsNullPredicate) {
            IsNullPredicate isNullPredicate = (IsNullPredicate)predicate;
            Expr leftExpr = (Expr)isNullPredicate.getChild(0);
            if (!(leftExpr instanceof SlotRef)) {
                throw new AnalysisException("Left expr of is_null predicate should be column name");
            }
            this.deleteConditions.add(isNullPredicate);
        } else if (predicate instanceof InPredicate) {
            int maxAllowedInElementNumOfDelete;
            InPredicate inPredicate = (InPredicate)predicate;
            Expr leftExpr = (Expr)inPredicate.getChild(0);
            if (!(leftExpr instanceof SlotRef)) {
                throw new AnalysisException("Left expr of in predicate should be column name");
            }
            int inElementNum = inPredicate.getInElementNum();
            if (inElementNum > (maxAllowedInElementNumOfDelete = Config.max_allowed_in_element_num_of_delete)) {
                throw new AnalysisException("Element num of in predicate should not be more than " + maxAllowedInElementNumOfDelete);
            }
            for (int i = 1; i <= inPredicate.getInElementNum(); ++i) {
                Expr expr = (Expr)inPredicate.getChild(i);
                if (expr instanceof LiteralExpr) continue;
                throw new AnalysisException("Child of in predicate should be value");
            }
            this.deleteConditions.add(inPredicate);
        } else {
            throw new AnalysisException("Where clause only supports compound predicate, binary predicate, is_null predicate or in predicate");
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ").append(this.tbl.toSql());
        if (this.partitionNames != null) {
            sb.append(" PARTITION (");
            sb.append(Joiner.on((String)", ").join(this.partitionNames.getPartitionNames()));
            sb.append(")");
        }
        sb.append(" WHERE ").append(this.wherePredicate.toSql());
        return sb.toString();
    }
}

