/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FloatLiteral;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.NotImplementedException;
import org.apache.doris.common.io.Text;
import org.apache.doris.thrift.TDecimalLiteral;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DecimalLiteral
extends LiteralExpr {
    private static final Logger LOG = LogManager.getLogger(DecimalLiteral.class);
    private BigDecimal value;

    public DecimalLiteral() {
    }

    public DecimalLiteral(BigDecimal value) {
        this.init(value);
        this.analysisDone();
    }

    public DecimalLiteral(String value) throws AnalysisException {
        BigDecimal v = null;
        try {
            v = new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid floating-point literal: " + value, e);
        }
        this.init(v);
        this.analysisDone();
    }

    protected DecimalLiteral(DecimalLiteral other) {
        super(other);
        this.value = other.value;
    }

    @Override
    public Expr clone() {
        return new DecimalLiteral(this);
    }

    private void init(BigDecimal value) {
        this.value = value;
        this.type = Type.DECIMALV2;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void checkPrecisionAndScale(int precision, int scale) throws AnalysisException {
        Preconditions.checkNotNull((Object)this.value);
        boolean valid = true;
        if (precision != -1 && scale != -1) {
            int realPrecision = this.value.precision();
            int realScale = this.value.scale();
            if (precision < realPrecision || scale < realScale) {
                valid = false;
            }
        } else {
            valid = false;
        }
        if (!valid) {
            throw new AnalysisException("Invalid precision and scale: " + precision + ", " + scale);
        }
    }

    @Override
    public boolean isMinValue() {
        return false;
    }

    @Override
    public ByteBuffer getHashValue(PrimitiveType type) {
        ByteBuffer buffer;
        switch (type) {
            case TINYINT: {
                buffer = ByteBuffer.allocate(8);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.put(this.value.byteValue());
                break;
            }
            case SMALLINT: {
                buffer = ByteBuffer.allocate(8);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.putShort(this.value.shortValue());
                break;
            }
            case INT: {
                buffer = ByteBuffer.allocate(8);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.putInt(this.value.intValue());
                break;
            }
            case BIGINT: {
                buffer = ByteBuffer.allocate(8);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.putLong(this.value.longValue());
                break;
            }
            case DECIMALV2: {
                buffer = ByteBuffer.allocate(12);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                long integerValue = this.value.longValue();
                int fracValue = this.getFracValue();
                buffer.putLong(integerValue);
                buffer.putInt(fracValue);
                break;
            }
            default: {
                return super.getHashValue(type);
            }
        }
        buffer.flip();
        return buffer;
    }

    @Override
    public Object getRealValue() {
        return this.value;
    }

    @Override
    public int compareLiteral(LiteralExpr expr) {
        if (expr instanceof NullLiteral) {
            return 1;
        }
        if (expr instanceof DecimalLiteral) {
            return this.value.compareTo(((DecimalLiteral)expr).value);
        }
        try {
            DecimalLiteral decimalLiteral = new DecimalLiteral(expr.getStringValue());
            return this.compareLiteral(decimalLiteral);
        }
        catch (AnalysisException e) {
            throw new ClassCastException("Those two values cannot be compared: " + this.value + " and " + expr.toSqlImpl());
        }
    }

    @Override
    public String toSqlImpl() {
        return this.getStringValue();
    }

    @Override
    public String getStringValue() {
        return this.value.toString();
    }

    @Override
    public long getLongValue() {
        return this.value.longValue();
    }

    @Override
    public double getDoubleValue() {
        return this.value.doubleValue();
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.DECIMAL_LITERAL;
        BigDecimal v = new BigDecimal(this.value.toBigInteger());
        msg.decimal_literal = new TDecimalLiteral(this.value.toPlainString());
    }

    @Override
    public void swapSign() throws NotImplementedException {
        this.value = this.value.negate();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.value.toString());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.value = new BigDecimal(Text.readString((DataInput)in));
    }

    public static DecimalLiteral read(DataInput in) throws IOException {
        DecimalLiteral dec = new DecimalLiteral();
        dec.readFields(in);
        return dec;
    }

    public int getFracValue() {
        BigDecimal integerPart = new BigDecimal(this.value.toBigInteger());
        BigDecimal fracPart = this.value.subtract(integerPart);
        fracPart = fracPart.setScale(9, 1);
        fracPart = fracPart.movePointRight(9);
        return fracPart.intValue();
    }

    public void roundCeiling() {
        this.value = this.value.setScale(0, RoundingMode.CEILING);
    }

    public void roundFloor() {
        this.value = this.value.setScale(0, RoundingMode.FLOOR);
    }

    @Override
    protected Expr uncheckedCastTo(Type targetType) throws AnalysisException {
        if (targetType.isDecimalV2()) {
            return this;
        }
        if (targetType.isFloatingPointType()) {
            return new FloatLiteral(this.value.doubleValue(), targetType);
        }
        if (targetType.isIntegerType()) {
            return new IntLiteral(this.value.longValue(), targetType);
        }
        if (targetType.isStringType()) {
            return new StringLiteral(this.value.toString());
        }
        return super.uncheckedCastTo(targetType);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.value);
    }
}

