/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Year;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.MaxLiteral;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.InvalidFormatException;
import org.apache.doris.thrift.TDateLiteral;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class DateLiteral
extends LiteralExpr {
    private static final Logger LOG = LogManager.getLogger(DateLiteral.class);
    private static final DateLiteral MIN_DATE = new DateLiteral(0L, 1L, 1L);
    private static final DateLiteral MAX_DATE = new DateLiteral(9999L, 12L, 31L);
    private static final DateLiteral MIN_DATETIME = new DateLiteral(0L, 1L, 1L, 0L, 0L, 0L);
    private static final DateLiteral MAX_DATETIME = new DateLiteral(9999L, 12L, 31L, 23L, 59L, 59L);
    public static final DateLiteral UNIX_EPOCH_TIME = new DateLiteral(1970L, 1L, 1L, 0L, 0L, 0L);
    private static final int DATEKEY_LENGTH = 8;
    private static final int MAX_MICROSECOND = 999999;
    private static final int DATETIME_TO_MINUTE_STRING_LENGTH = 16;
    private static final int DATETIME_TO_HOUR_STRING_LENGTH = 13;
    private static DateTimeFormatter DATE_TIME_FORMATTER = null;
    private static DateTimeFormatter DATE_TIME_FORMATTER_TO_HOUR = null;
    private static DateTimeFormatter DATE_TIME_FORMATTER_TO_MINUTE = null;
    private static DateTimeFormatter DATE_FORMATTER = null;
    private static DateTimeFormatter DATE_TIME_FORMATTER_TWO_DIGIT = null;
    private static DateTimeFormatter DATE_FORMATTER_TWO_DIGIT = null;
    private static DateTimeFormatter DATEKEY_FORMATTER = null;
    private static Map<String, Integer> MONTH_NAME_DICT = Maps.newHashMap();
    private static Map<String, Integer> MONTH_ABBR_NAME_DICT = Maps.newHashMap();
    private static Map<String, Integer> WEEK_DAY_NAME_DICT = Maps.newHashMap();
    private static final int[] DAYS_IN_MONTH = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int ALLOW_SPACE_MASK = 68;
    private static final int MAX_DATE_PARTS = 8;
    private static final int YY_PART_YEAR = 70;
    private static final Pattern HAS_TIME_PART;
    private long year;
    private long month;
    private long day;
    private long hour;
    private long minute;
    private long second;
    private long microsecond;

    public DateLiteral() {
    }

    public DateLiteral(Type type, boolean isMax) throws AnalysisException {
        this.type = type;
        if (type.equals(Type.DATE)) {
            if (isMax) {
                this.copy(MAX_DATE);
            } else {
                this.copy(MIN_DATE);
            }
        } else if (isMax) {
            this.copy(MAX_DATETIME);
        } else {
            this.copy(MIN_DATETIME);
        }
        this.analysisDone();
    }

    public DateLiteral(String s, Type type) throws AnalysisException {
        this.init(s, type);
        this.analysisDone();
    }

    public DateLiteral(long unixTimestamp, TimeZone timeZone, Type type) {
        DateTime dt = new DateTime(unixTimestamp, DateTimeZone.forTimeZone((TimeZone)timeZone));
        this.year = dt.getYear();
        this.month = dt.getMonthOfYear();
        this.day = dt.getDayOfMonth();
        this.hour = dt.getHourOfDay();
        this.minute = dt.getMinuteOfHour();
        this.second = dt.getSecondOfMinute();
        if (type.equals(Type.DATE)) {
            this.hour = 0L;
            this.minute = 0L;
            this.second = 0L;
            this.type = Type.DATE;
        } else {
            this.type = Type.DATETIME;
        }
    }

    public DateLiteral(long year, long month, long day) {
        this.hour = 0L;
        this.minute = 0L;
        this.second = 0L;
        this.year = year;
        this.month = month;
        this.day = day;
        this.type = Type.DATE;
    }

    public DateLiteral(long year, long month, long day, long hour, long minute, long second) {
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.year = year;
        this.month = month;
        this.day = day;
        this.type = Type.DATETIME;
    }

    public DateLiteral(LocalDateTime dateTime, Type type) {
        this.year = dateTime.getYear();
        this.month = dateTime.getMonthOfYear();
        this.day = dateTime.getDayOfMonth();
        this.hour = dateTime.getHourOfDay();
        this.minute = dateTime.getMinuteOfHour();
        this.second = dateTime.getSecondOfMinute();
        this.type = type;
    }

    public DateLiteral(DateLiteral other) {
        super(other);
        this.hour = other.hour;
        this.minute = other.minute;
        this.second = other.second;
        this.year = other.year;
        this.month = other.month;
        this.day = other.day;
        this.microsecond = other.microsecond;
        this.type = other.type;
    }

    public static DateLiteral createMinValue(Type type) throws AnalysisException {
        return new DateLiteral(type, false);
    }

    private void init(String s, Type type) throws AnalysisException {
        try {
            Preconditions.checkArgument((boolean)type.isDateType());
            LocalDateTime dateTime = type.equals(Type.DATE) ? (s.split("-")[0].length() == 2 ? DATE_FORMATTER_TWO_DIGIT.parseLocalDateTime(s) : (s.length() == 8 && !s.contains("-") ? DATEKEY_FORMATTER.parseLocalDateTime(s) : DATE_FORMATTER.parseLocalDateTime(s))) : (s.split("-")[0].length() == 2 ? DATE_TIME_FORMATTER_TWO_DIGIT.parseLocalDateTime(s) : (s.length() == 16 ? DATE_TIME_FORMATTER_TO_MINUTE.parseLocalDateTime(s) : (s.length() == 13 ? DATE_TIME_FORMATTER_TO_HOUR.parseLocalDateTime(s) : DATE_TIME_FORMATTER.parseLocalDateTime(s))));
            this.year = dateTime.getYear();
            this.month = dateTime.getMonthOfYear();
            this.day = dateTime.getDayOfMonth();
            this.hour = dateTime.getHourOfDay();
            this.minute = dateTime.getMinuteOfHour();
            this.second = dateTime.getSecondOfMinute();
            this.type = type;
        }
        catch (Exception ex) {
            throw new AnalysisException("date literal [" + s + "] is invalid");
        }
    }

    private void copy(DateLiteral other) {
        this.hour = other.hour;
        this.minute = other.minute;
        this.second = other.second;
        this.year = other.year;
        this.month = other.month;
        this.day = other.day;
        this.microsecond = other.microsecond;
        this.type = other.type;
    }

    @Override
    public Expr clone() {
        return new DateLiteral(this);
    }

    @Override
    public boolean isMinValue() {
        switch (this.type.getPrimitiveType()) {
            case DATE: {
                return this.getStringValue().compareTo(MIN_DATE.getStringValue()) == 0;
            }
            case DATETIME: {
                return this.getStringValue().compareTo(MIN_DATETIME.getStringValue()) == 0;
            }
        }
        return false;
    }

    @Override
    public Object getRealValue() {
        if (this.type.equals(Type.DATE)) {
            return this.year * 16L * 32L + this.month * 32L + this.day;
        }
        if (this.type.equals(Type.DATETIME)) {
            return (this.year * 10000L + this.month * 100L + this.day) * 1000000L + this.hour * 10000L + this.minute * 100L + this.second;
        }
        Preconditions.checkState((boolean)false, (Object)("invalid date type: " + this.type));
        return -1L;
    }

    @Override
    public ByteBuffer getHashValue(PrimitiveType type) {
        ByteBuffer buffer;
        String value = this.convertToString(type);
        try {
            buffer = ByteBuffer.wrap(value.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    @Override
    public int compareLiteral(LiteralExpr expr) {
        if (expr instanceof NullLiteral) {
            return 1;
        }
        if (expr == MaxLiteral.MAX_VALUE) {
            return -1;
        }
        return Long.signum(this.getLongValue() - expr.getLongValue());
    }

    @Override
    public String toSqlImpl() {
        return "'" + this.getStringValue() + "'";
    }

    @Override
    public String getStringValue() {
        return this.convertToString(this.type.getPrimitiveType());
    }

    private String convertToString(PrimitiveType type) {
        if (type == PrimitiveType.DATE) {
            return String.format("%04d-%02d-%02d", this.year, this.month, this.day);
        }
        return String.format("%04d-%02d-%02d %02d:%02d:%02d", this.year, this.month, this.day, this.hour, this.minute, this.second);
    }

    @Override
    public long getLongValue() {
        return (this.year * 10000L + this.month * 100L + this.day) * 1000000L + this.hour * 10000L + this.minute * 100L + this.second;
    }

    @Override
    public double getDoubleValue() {
        return this.getLongValue();
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.DATE_LITERAL;
        msg.date_literal = new TDateLiteral(this.getStringValue());
    }

    @Override
    protected Expr uncheckedCastTo(Type targetType) throws AnalysisException {
        if (targetType.isDateType()) {
            if (this.type.equals(targetType)) {
                return this;
            }
            if (targetType.equals(Type.DATE)) {
                return new DateLiteral(this.year, this.month, this.day);
            }
            if (targetType.equals(Type.DATETIME)) {
                return new DateLiteral(this.year, this.month, this.day, this.hour, this.minute, this.second);
            }
            throw new AnalysisException("Error date literal type : " + this.type);
        }
        if (targetType.isStringType()) {
            return new StringLiteral(this.getStringValue());
        }
        if (Type.isImplicitlyCastable(this.type, targetType, true)) {
            return new CastExpr(targetType, (Expr)this);
        }
        Preconditions.checkState((boolean)false);
        return this;
    }

    public void castToDate() {
        this.type = Type.DATE;
        this.hour = 0L;
        this.minute = 0L;
        this.second = 0L;
    }

    private long makePackedDatetime() {
        long ymd = this.year * 13L + this.month << 5 | this.day;
        long hms = this.hour << 12 | this.minute << 6 | this.second;
        long packed_datetime = (ymd << 17 | hms) << (int)(24L + this.microsecond);
        return packed_datetime;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        if (this.type.equals(Type.DATETIME)) {
            out.writeShort(DateLiteralType.DATETIME.value());
        } else if (this.type.equals(Type.DATE)) {
            out.writeShort(DateLiteralType.DATE.value());
        } else {
            throw new IOException("Error date literal type : " + this.type);
        }
        out.writeLong(this.makePackedDatetime());
    }

    private void fromPackedDatetime(long packed_time) {
        this.microsecond = packed_time % 0x1000000L;
        long ymdhms = packed_time >> 24;
        long ymd = ymdhms >> 17;
        long hms = ymdhms % 131072L;
        this.day = ymd % 32L;
        long ym = ymd >> 5;
        this.month = ym % 13L;
        this.year = ym / 13L;
        this.year %= 10000L;
        this.second = hms % 64L;
        this.minute = (hms >> 6) % 64L;
        this.hour = hms >> 12;
        this.type = Type.DATETIME;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        short date_literal_type = in.readShort();
        this.fromPackedDatetime(in.readLong());
        if (date_literal_type == DateLiteralType.DATETIME.value()) {
            this.type = Type.DATETIME;
        } else if (date_literal_type == DateLiteralType.DATE.value()) {
            this.type = Type.DATE;
        } else {
            throw new IOException("Error date literal type : " + this.type);
        }
    }

    public static DateLiteral read(DataInput in) throws IOException {
        DateLiteral literal = new DateLiteral();
        literal.readFields(in);
        return literal;
    }

    public long unixTimestamp(TimeZone timeZone) {
        DateTime dt = new DateTime((int)this.year, (int)this.month, (int)this.day, (int)this.hour, (int)this.minute, (int)this.second, DateTimeZone.forTimeZone((TimeZone)timeZone));
        return dt.getMillis();
    }

    public static DateLiteral dateParser(String date, String pattern) throws AnalysisException {
        DateTimeFormatter formatter = DateLiteral.formatBuilder(pattern).toFormatter();
        LocalDateTime dateTime = formatter.parseLocalDateTime(date);
        DateLiteral dateLiteral = new DateLiteral(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), dateTime.getHourOfDay(), dateTime.getMinuteOfHour(), dateTime.getSecondOfMinute());
        if (HAS_TIME_PART.matcher(pattern).matches()) {
            dateLiteral.setType(Type.DATETIME);
        } else {
            dateLiteral.setType(Type.DATE);
        }
        return dateLiteral;
    }

    public static boolean hasTimePart(String format) {
        return HAS_TIME_PART.matcher(format).matches();
    }

    public String dateFormat(String pattern) throws AnalysisException {
        if (this.type.equals(Type.DATE)) {
            return DATE_FORMATTER.parseLocalDateTime(this.getStringValue()).toString(DateLiteral.formatBuilder(pattern).toFormatter());
        }
        return DATE_TIME_FORMATTER.parseLocalDateTime(this.getStringValue()).toString(DateLiteral.formatBuilder(pattern).toFormatter());
    }

    private static DateTimeFormatterBuilder formatBuilder(String pattern) throws AnalysisException {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        boolean escaped = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char character = pattern.charAt(i);
            if (escaped) {
                switch (character) {
                    case 'a': {
                        builder.appendDayOfWeekShortText();
                        break;
                    }
                    case 'b': {
                        builder.appendMonthOfYearShortText();
                        break;
                    }
                    case 'c': {
                        builder.appendMonthOfYear(1);
                        break;
                    }
                    case 'd': {
                        builder.appendDayOfMonth(2);
                        break;
                    }
                    case 'e': {
                        builder.appendDayOfMonth(1);
                        break;
                    }
                    case 'H': {
                        builder.appendHourOfDay(2);
                        break;
                    }
                    case 'I': 
                    case 'h': {
                        builder.appendClockhourOfHalfday(2);
                        break;
                    }
                    case 'i': {
                        builder.appendMinuteOfHour(2);
                        break;
                    }
                    case 'j': {
                        builder.appendDayOfYear(3);
                        break;
                    }
                    case 'k': {
                        builder.appendHourOfDay(1);
                        break;
                    }
                    case 'l': {
                        builder.appendClockhourOfHalfday(1);
                        break;
                    }
                    case 'M': {
                        builder.appendMonthOfYearText();
                        break;
                    }
                    case 'm': {
                        builder.appendMonthOfYear(2);
                        break;
                    }
                    case 'p': {
                        builder.appendHalfdayOfDayText();
                        break;
                    }
                    case 'r': {
                        builder.appendClockhourOfHalfday(2).appendLiteral(':').appendMinuteOfHour(2).appendLiteral(':').appendSecondOfMinute(2).appendLiteral(' ').appendHalfdayOfDayText();
                        break;
                    }
                    case 'S': 
                    case 's': {
                        builder.appendSecondOfMinute(2);
                        break;
                    }
                    case 'T': {
                        builder.appendHourOfDay(2).appendLiteral(':').appendMinuteOfHour(2).appendLiteral(':').appendSecondOfMinute(2);
                        break;
                    }
                    case 'v': {
                        builder.appendWeekOfWeekyear(2);
                        break;
                    }
                    case 'x': {
                        builder.appendWeekyear(4, 4);
                        break;
                    }
                    case 'W': {
                        builder.appendDayOfWeekText();
                        break;
                    }
                    case 'Y': {
                        builder.appendYear(4, 4);
                        break;
                    }
                    case 'y': {
                        builder.appendTwoDigitYear(2020);
                        break;
                    }
                    case 'D': 
                    case 'U': 
                    case 'V': 
                    case 'X': 
                    case 'f': 
                    case 'u': 
                    case 'w': {
                        throw new AnalysisException(String.format("%%%s not supported in date format string", Character.valueOf(character)));
                    }
                    case '%': {
                        builder.appendLiteral('%');
                        break;
                    }
                    default: {
                        builder.appendLiteral(character);
                    }
                }
                escaped = false;
                continue;
            }
            if (character == '%') {
                escaped = true;
                continue;
            }
            builder.appendLiteral(character);
        }
        return builder;
    }

    public LocalDateTime getTimeFormatter() throws AnalysisException {
        if (this.type.equals(Type.DATE)) {
            return DATE_FORMATTER.parseLocalDateTime(this.getStringValue());
        }
        if (this.type.equals(Type.DATETIME)) {
            return DATE_TIME_FORMATTER.parseLocalDateTime(this.getStringValue());
        }
        throw new AnalysisException("Not support date literal type");
    }

    public DateLiteral plusYears(int year) throws AnalysisException {
        return new DateLiteral(this.getTimeFormatter().plusYears(year), this.type);
    }

    public DateLiteral plusMonths(int month) throws AnalysisException {
        return new DateLiteral(this.getTimeFormatter().plusMonths(month), this.type);
    }

    public DateLiteral plusDays(int day) throws AnalysisException {
        return new DateLiteral(this.getTimeFormatter().plusDays(day), this.type);
    }

    public DateLiteral plusHours(int hour) throws AnalysisException {
        return new DateLiteral(this.getTimeFormatter().plusHours(hour), this.type);
    }

    public DateLiteral plusMinutes(int minute) throws AnalysisException {
        return new DateLiteral(this.getTimeFormatter().plusMinutes(minute), this.type);
    }

    public DateLiteral plusSeconds(int second) throws AnalysisException {
        return new DateLiteral(this.getTimeFormatter().plusSeconds(second), this.type);
    }

    public long getYear() {
        return this.year;
    }

    public long getMonth() {
        return this.month;
    }

    public long getDay() {
        return this.day;
    }

    public long getHour() {
        return this.hour;
    }

    public long getMinute() {
        return this.minute;
    }

    public long getSecond() {
        return this.second;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.unixTimestamp(TimeZone.getDefault()));
    }

    public int fromDateFormatStr(String format, String value, boolean hasSubVal) throws InvalidFormatException {
        char f;
        int fp = 0;
        int fend = format.length();
        int vp = 0;
        int vend = value.length();
        boolean datePartUsed = false;
        boolean timePartUsed = false;
        int dayPart = 0;
        long weekday = -1L;
        long yearday = -1L;
        long weekNum = -1L;
        boolean strictWeekNumber = false;
        boolean sundayFirst = false;
        boolean strictWeekNumberYearType = false;
        long strictWeekNumberYear = -1L;
        boolean usaTime = false;
        block30: while (fp < fend && vp < vend) {
            while (vp < vend && Character.isSpaceChar(value.charAt(vp))) {
                ++vp;
            }
            if (vp >= vend) break;
            f = format.charAt(fp);
            if (f == '%' && fp + 1 < fend) {
                int tmp = 0;
                long intValue = 0L;
                f = format.charAt(++fp);
                ++fp;
                switch (f) {
                    case 'y': {
                        tmp = vp + Math.min(2, vend - vp);
                        intValue = this.strToLong(value.substring(vp, tmp));
                        this.year = intValue += intValue >= 70L ? 1900L : 2000L;
                        vp = tmp;
                        datePartUsed = true;
                        continue block30;
                    }
                    case 'Y': {
                        tmp = vp + Math.min(4, vend - vp);
                        intValue = this.strToLong(value.substring(vp, tmp));
                        if (tmp - vp <= 2) {
                            intValue += intValue >= 70L ? 1900L : 2000L;
                        }
                        this.year = intValue;
                        vp = tmp;
                        datePartUsed = true;
                        continue block30;
                    }
                    case 'c': 
                    case 'm': {
                        tmp = vp + Math.min(2, vend - vp);
                        this.month = intValue = this.strToLong(value.substring(vp, tmp));
                        vp = tmp;
                        datePartUsed = true;
                        continue block30;
                    }
                    case 'M': {
                        int nextPos = this.findWord(value, vp);
                        this.month = intValue = (long)this.checkWord(MONTH_NAME_DICT, value.substring(vp, nextPos));
                        vp = nextPos;
                        continue block30;
                    }
                    case 'b': {
                        int nextPos = this.findWord(value, vp);
                        this.month = intValue = (long)this.checkWord(MONTH_ABBR_NAME_DICT, value.substring(vp, nextPos));
                        vp = nextPos;
                        continue block30;
                    }
                    case 'd': 
                    case 'e': {
                        tmp = vp + Math.min(2, vend - vp);
                        this.day = intValue = this.strToLong(value.substring(vp, tmp));
                        vp = tmp;
                        datePartUsed = true;
                        continue block30;
                    }
                    case 'D': {
                        tmp = vp + Math.min(2, vend - vp);
                        this.day = intValue = this.strToLong(value.substring(vp, tmp));
                        vp = tmp + Math.min(2, vend - tmp);
                        datePartUsed = true;
                        continue block30;
                    }
                    case 'I': 
                    case 'h': 
                    case 'l': {
                        usaTime = true;
                    }
                    case 'H': 
                    case 'k': {
                        tmp = this.findNumber(value, vp, 2);
                        this.hour = intValue = this.strToLong(value.substring(vp, tmp));
                        vp = tmp;
                        timePartUsed = true;
                        continue block30;
                    }
                    case 'i': {
                        tmp = vp + Math.min(2, vend - vp);
                        this.minute = intValue = this.strToLong(value.substring(vp, tmp));
                        vp = tmp;
                        timePartUsed = true;
                        continue block30;
                    }
                    case 'S': 
                    case 's': {
                        tmp = vp + Math.min(2, vend - vp);
                        this.second = intValue = this.strToLong(value.substring(vp, tmp));
                        vp = tmp;
                        timePartUsed = true;
                        continue block30;
                    }
                    case 'f': {
                        vp = tmp = vp + Math.min(6, vend - vp);
                        continue block30;
                    }
                    case 'p': {
                        if (vend - vp < 2 || Character.toUpperCase(value.charAt(vp + 1)) != 'M' || !usaTime) {
                            throw new InvalidFormatException("Invalid %p format");
                        }
                        if (Character.toUpperCase(value.charAt(vp)) == 'P') {
                            dayPart = 12;
                        }
                        timePartUsed = true;
                        vp += 2;
                        continue block30;
                    }
                    case 'W': {
                        int nextPos = this.findWord(value, vp);
                        intValue = this.checkWord(WEEK_DAY_NAME_DICT, value.substring(vp, nextPos));
                        weekday = ++intValue;
                        datePartUsed = true;
                        continue block30;
                    }
                    case 'a': {
                        int nextPos = this.findWord(value, vp);
                        intValue = this.checkWord(WEEK_DAY_NAME_DICT, value.substring(vp, nextPos));
                        weekday = ++intValue;
                        datePartUsed = true;
                        continue block30;
                    }
                    case 'w': {
                        tmp = vp + Math.min(1, vend - vp);
                        intValue = this.strToLong(value.substring(vp, tmp));
                        if (intValue >= 7L) {
                            throw new InvalidFormatException("invalid day of week: " + intValue);
                        }
                        if (intValue == 0L) {
                            intValue = 7L;
                        }
                        weekday = intValue;
                        vp = tmp;
                        datePartUsed = true;
                        continue block30;
                    }
                    case 'j': {
                        tmp = vp + Math.min(3, vend - vp);
                        yearday = intValue = this.strToLong(value.substring(vp, tmp));
                        vp = tmp;
                        datePartUsed = true;
                        continue block30;
                    }
                    case 'U': 
                    case 'V': 
                    case 'u': 
                    case 'v': {
                        sundayFirst = format.charAt(fp - 1) == 'U' || format.charAt(fp - 1) == 'V';
                        strictWeekNumber = format.charAt(fp - 1) == 'V' || format.charAt(fp - 1) == 'v';
                        tmp = vp + Math.min(2, vend - vp);
                        weekNum = intValue = Long.valueOf(value.substring(vp, tmp)).longValue();
                        if (weekNum > 53L || strictWeekNumber && weekNum == 0L) {
                            throw new InvalidFormatException("invalid num of week: " + weekNum);
                        }
                        vp = tmp;
                        datePartUsed = true;
                        continue block30;
                    }
                    case 'X': 
                    case 'x': {
                        strictWeekNumberYearType = format.charAt(fp - 1) == 'X';
                        tmp = vp + Math.min(4, vend - vp);
                        strictWeekNumberYear = intValue = Long.valueOf(value.substring(vp, tmp)).longValue();
                        vp = tmp;
                        datePartUsed = true;
                        continue block30;
                    }
                    case 'r': {
                        vp = tmp = this.fromDateFormatStr("%I:%i:%S %p", value.substring(vp, vend), true);
                        timePartUsed = true;
                        continue block30;
                    }
                    case 'T': {
                        vp = tmp = this.fromDateFormatStr("%H:%i:%S", value.substring(vp, vend), true);
                        timePartUsed = true;
                        continue block30;
                    }
                    case '.': {
                        while (vp < vend && Character.toString(value.charAt(vp)).matches("\\p{Punct}")) {
                            ++vp;
                        }
                        continue block30;
                    }
                    case '@': {
                        while (vp < vend && Character.isLetter(value.charAt(vp))) {
                            ++vp;
                        }
                        continue block30;
                    }
                    case '#': {
                        while (vp < vend && Character.isDigit(value.charAt(vp))) {
                            ++vp;
                        }
                        continue block30;
                    }
                    case '%': {
                        if ('%' != value.charAt(vp)) {
                            throw new InvalidFormatException("invalid char after %: " + value.charAt(vp));
                        }
                        ++vp;
                        continue block30;
                    }
                }
                throw new InvalidFormatException("Invalid format pattern: " + f);
            }
            if (format.charAt(fp) != ' ') {
                if (format.charAt(fp) != value.charAt(vp)) {
                    throw new InvalidFormatException("Invalid char: " + value.charAt(vp) + ", expected: " + format.charAt(fp));
                }
                ++fp;
                ++vp;
                continue;
            }
            ++fp;
        }
        block35: while (fp < fend) {
            f = format.charAt(fp);
            if (f == '%' && fp + 1 < fend) {
                f = format.charAt(++fp);
                ++fp;
                switch (f) {
                    case 'H': 
                    case 'I': 
                    case 'S': 
                    case 'T': 
                    case 'h': 
                    case 'i': 
                    case 'k': 
                    case 'l': 
                    case 'p': 
                    case 'r': 
                    case 's': {
                        timePartUsed = true;
                        continue block35;
                    }
                }
                continue;
            }
            ++fp;
        }
        if (usaTime) {
            if (this.hour > 12L || this.hour < 1L) {
                throw new InvalidFormatException("Invalid hour: " + this.hour);
            }
            this.hour = this.hour % 12L + (long)dayPart;
        }
        if (hasSubVal) {
            return vp;
        }
        if (yearday > 0L) {
            long days = this.calcDaynr(this.year, 1L, 1L) + yearday - 1L;
            this.getDateFromDaynr(days);
        }
        if (weekNum >= 0L && weekday > 0L) {
            if (strictWeekNumber && (strictWeekNumberYear < 0L || strictWeekNumberYearType != sundayFirst) || !strictWeekNumber && strictWeekNumberYear >= 0L) {
                throw new InvalidFormatException("invalid week number");
            }
            long days = this.calcDaynr(strictWeekNumber ? strictWeekNumberYear : this.year, 1L, 1L);
            long weekday_b = this.calcWeekday(days, sundayFirst);
            days = sundayFirst ? (days += (long)(weekday_b == 0L ? 0 : 7) - weekday_b + (weekNum - 1L) * 7L + weekday % 7L) : (days += (long)(weekday_b <= 3L ? 0 : 7) - weekday_b + (weekNum - 1L) * 7L + weekday - 1L);
            this.getDateFromDaynr(days);
        }
        if (datePartUsed) {
            this.type = timePartUsed ? Type.DATETIME : Type.DATE;
        }
        if (this.checkRange() || this.checkDate()) {
            throw new InvalidFormatException("Invalid format");
        }
        return 0;
    }

    private boolean checkRange() {
        return this.year > DateLiteral.MAX_DATETIME.year || this.month > DateLiteral.MAX_DATETIME.month || this.day > DateLiteral.MAX_DATETIME.day || this.hour > DateLiteral.MAX_DATETIME.hour || this.minute > DateLiteral.MAX_DATETIME.minute || this.second > DateLiteral.MAX_DATETIME.second || this.microsecond > 999999L;
    }

    private boolean checkDate() {
        if (this.month != 0L && this.day > (long)DAYS_IN_MONTH[(int)this.month]) {
            return this.month != 2L || this.day != 29L || !Year.isLeap(this.year);
        }
        return false;
    }

    private long strToLong(String l) throws InvalidFormatException {
        try {
            long y = Long.valueOf(l);
            if (y < 0L) {
                throw new InvalidFormatException("Invalid format: negative number.");
            }
            return y;
        }
        catch (NumberFormatException e) {
            throw new InvalidFormatException(e.getMessage());
        }
    }

    private long calcDaynr(long year, long month, long day) {
        long delsum = 0L;
        long y = year;
        if (year == 0L && month == 0L) {
            return 0L;
        }
        delsum = 365L * y + 31L * (month - 1L) + day;
        if (month <= 2L) {
            --y;
        } else {
            delsum -= (month * 4L + 23L) / 10L;
        }
        return delsum + y / 4L - y / 100L + y / 400L;
    }

    private long calcWeekday(long dayNr, boolean isSundayFirstDay) {
        return (dayNr + 5L + (isSundayFirstDay ? 1L : 0L)) % 7L;
    }

    private void getDateFromDaynr(long daynr) throws InvalidFormatException {
        if (daynr <= 0L || daynr > 3652424L) {
            throw new InvalidFormatException("Invalid days to year: " + daynr);
        }
        this.year = daynr / 365L;
        long daysBeforeYear = 0L;
        while (daynr < (daysBeforeYear = this.calcDaynr(this.year, 1L, 1L))) {
            --this.year;
        }
        long daysOfYear = daynr - daysBeforeYear + 1L;
        int leapDay = 0;
        if (Year.isLeap(this.year) && daysOfYear > 59L && --daysOfYear == 59L) {
            leapDay = 1;
        }
        this.month = 1L;
        while (daysOfYear > (long)DAYS_IN_MONTH[(int)this.month]) {
            daysOfYear -= (long)DAYS_IN_MONTH[(int)this.month];
            ++this.month;
        }
        this.day = daysOfYear + (long)leapDay;
    }

    private int findWord(String value, int start) {
        int p;
        for (p = start; p < value.length() && Character.isLetter(value.charAt(p)); ++p) {
        }
        return p;
    }

    private int findNumber(String value, int start, int maxLen) {
        int p = start;
        for (int left = maxLen; p < value.length() && Character.isDigit(value.charAt(p)) && left > 0; ++p, --left) {
        }
        return p;
    }

    private int checkWord(Map<String, Integer> dict, String value) throws InvalidFormatException {
        Integer i = dict.get(value.toLowerCase());
        if (i != null) {
            return i;
        }
        throw new InvalidFormatException("'" + value + "' is invalid");
    }

    public void fromDateStr(String dateStr) throws AnalysisException {
        int pos;
        if ((dateStr = dateStr.trim()).isEmpty()) {
            throw new AnalysisException("parse datetime value failed: " + dateStr);
        }
        int[] dateVal = new int[8];
        int[] dateLen = new int[8];
        int pre = 0;
        for (pos = 0; pos < dateStr.length() && (Character.isDigit(dateStr.charAt(pos)) || dateStr.charAt(pos) == 'T'); ++pos) {
        }
        int yearLen = 4;
        int digits = pos - pre;
        boolean isIntervalFormat = false;
        if (pos == dateStr.length() || dateStr.charAt(pos) == '.') {
            yearLen = digits == 4 || digits == 8 || digits >= 14 ? 4 : 2;
            isIntervalFormat = true;
        }
        int fieldIdx = 0;
        int fieldLen = yearLen;
        while (pre < dateStr.length() && Character.isDigit(dateStr.charAt(pre)) && fieldIdx < 7) {
            boolean scanToDelim;
            int start = pre;
            int temp_val = 0;
            boolean bl = scanToDelim = !isIntervalFormat && fieldIdx != 6;
            while (pre < dateStr.length() && Character.isDigit(dateStr.charAt(pre)) && (scanToDelim || fieldLen-- != 0)) {
                temp_val = temp_val * 10 + (dateStr.charAt(pre++) - 48);
            }
            dateVal[fieldIdx] = temp_val;
            dateLen[fieldIdx] = pre - start;
            fieldLen = 2;
            if (pre == dateStr.length()) {
                ++fieldIdx;
                break;
            }
            if (fieldIdx == 2 && dateStr.charAt(pre) == 'T') {
                ++pre;
                ++fieldIdx;
                continue;
            }
            if (fieldIdx == 5) {
                if (dateStr.charAt(pre) == '.') {
                    ++pre;
                    fieldLen = 6;
                } else if (Character.isDigit(dateStr.charAt(pre))) {
                    ++fieldIdx;
                    break;
                }
                ++fieldIdx;
                continue;
            }
            while (pre < dateStr.length() && Character.toString(dateStr.charAt(pre)).matches("\\p{Punct}") || Character.isSpaceChar(dateStr.charAt(pre))) {
                if (Character.isSpaceChar(dateStr.charAt(pre)) && (1 << fieldIdx & 0x44) == 0) {
                    throw new AnalysisException("parse datetime value failed: " + dateStr);
                }
                ++pre;
            }
            ++fieldIdx;
        }
        int numField = fieldIdx;
        if (!isIntervalFormat) {
            yearLen = dateLen[0];
        }
        while (fieldIdx < 8) {
            dateLen[fieldIdx] = 0;
            dateVal[fieldIdx] = 0;
            ++fieldIdx;
        }
        if (yearLen == 2) {
            dateVal[0] = dateVal[0] < 70 ? dateVal[0] + 2000 : dateVal[0] + 1900;
        }
        if (numField < 3) {
            throw new AnalysisException("parse datetime value failed: " + dateStr);
        }
        this.year = dateVal[0];
        this.month = dateVal[1];
        this.day = dateVal[2];
        this.hour = dateVal[3];
        this.minute = dateVal[4];
        this.second = dateVal[5];
        this.microsecond = dateVal[6];
        this.type = numField == 3 ? Type.DATE : Type.DATETIME;
        if (this.checkRange() || this.checkDate()) {
            throw new AnalysisException("Datetime value is out of range: " + dateStr);
        }
    }

    static {
        try {
            DATE_TIME_FORMATTER = DateLiteral.formatBuilder("%Y-%m-%d %H:%i:%s").toFormatter();
            DATE_TIME_FORMATTER_TO_HOUR = DateLiteral.formatBuilder("%Y-%m-%d %H").toFormatter();
            DATE_TIME_FORMATTER_TO_MINUTE = DateLiteral.formatBuilder("%Y-%m-%d %H:%i").toFormatter();
            DATE_FORMATTER = DateLiteral.formatBuilder("%Y-%m-%d").toFormatter();
            DATEKEY_FORMATTER = DateLiteral.formatBuilder("%Y%m%d").toFormatter();
            DATE_TIME_FORMATTER_TWO_DIGIT = DateLiteral.formatBuilder("%y-%m-%d %H:%i:%s").toFormatter();
            DATE_FORMATTER_TWO_DIGIT = DateLiteral.formatBuilder("%y-%m-%d").toFormatter();
        }
        catch (AnalysisException e) {
            LOG.error("invalid date format", (Throwable)e);
            System.exit(-1);
        }
        MONTH_NAME_DICT.put("january", 1);
        MONTH_NAME_DICT.put("february", 2);
        MONTH_NAME_DICT.put("march", 3);
        MONTH_NAME_DICT.put("april", 4);
        MONTH_NAME_DICT.put("may", 5);
        MONTH_NAME_DICT.put("june", 6);
        MONTH_NAME_DICT.put("july", 7);
        MONTH_NAME_DICT.put("august", 8);
        MONTH_NAME_DICT.put("september", 9);
        MONTH_NAME_DICT.put("october", 10);
        MONTH_NAME_DICT.put("november", 11);
        MONTH_NAME_DICT.put("december", 12);
        MONTH_ABBR_NAME_DICT.put("jan", 1);
        MONTH_ABBR_NAME_DICT.put("feb", 2);
        MONTH_ABBR_NAME_DICT.put("mar", 3);
        MONTH_ABBR_NAME_DICT.put("apr", 4);
        MONTH_ABBR_NAME_DICT.put("may", 5);
        MONTH_ABBR_NAME_DICT.put("jun", 6);
        MONTH_ABBR_NAME_DICT.put("jul", 7);
        MONTH_ABBR_NAME_DICT.put("aug", 8);
        MONTH_ABBR_NAME_DICT.put("sep", 9);
        MONTH_ABBR_NAME_DICT.put("oct", 10);
        MONTH_ABBR_NAME_DICT.put("nov", 11);
        MONTH_ABBR_NAME_DICT.put("dec", 12);
        WEEK_DAY_NAME_DICT.put("monday", 0);
        WEEK_DAY_NAME_DICT.put("tuesday", 1);
        WEEK_DAY_NAME_DICT.put("wednesday", 2);
        WEEK_DAY_NAME_DICT.put("thursday", 3);
        WEEK_DAY_NAME_DICT.put("friday", 4);
        WEEK_DAY_NAME_DICT.put("saturday", 5);
        WEEK_DAY_NAME_DICT.put("sunday", 6);
        MONTH_ABBR_NAME_DICT.put("mon", 0);
        MONTH_ABBR_NAME_DICT.put("tue", 1);
        MONTH_ABBR_NAME_DICT.put("wed", 2);
        MONTH_ABBR_NAME_DICT.put("thu", 3);
        MONTH_ABBR_NAME_DICT.put("fri", 4);
        MONTH_ABBR_NAME_DICT.put("sat", 5);
        MONTH_ABBR_NAME_DICT.put("sun", 6);
        HAS_TIME_PART = Pattern.compile("^.*[HhIiklrSsTp]+.*$");
    }

    private static enum DateLiteralType {
        DATETIME(0),
        DATE(1);

        private final int value;

        private DateLiteralType(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

