/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.thrift.TSortType;

public class DataSortInfo
implements Writable {
    public static final String DATA_SORT_PROPERTY_PREFIX = "data_sort";
    public static final String DATA_SORT_TYPE = "data_sort.sort_type";
    public static final String DATA_SORT_COL_NUM = "data_sort.col_num";
    @SerializedName(value="sort_type")
    private TSortType sortType;
    @SerializedName(value="col_num")
    private int colNum;

    public DataSortInfo() {
    }

    public DataSortInfo(Map<String, String> properties) {
        if (properties != null && !properties.isEmpty()) {
            this.sortType = properties.get(DATA_SORT_TYPE).equalsIgnoreCase("ZORDER") ? TSortType.ZORDER : TSortType.LEXICAL;
            this.colNum = Integer.parseInt(properties.get(DATA_SORT_COL_NUM));
        }
    }

    public DataSortInfo(TSortType sortType, int colNum) {
        this.sortType = sortType;
        this.colNum = colNum;
    }

    public TSortType getSortType() {
        return this.sortType;
    }

    public void setSortType(TSortType sortType) {
        this.sortType = sortType;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static DataSortInfo read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (DataSortInfo)GsonUtils.GSON.fromJson(json, DataSortInfo.class);
    }

    public boolean equals(DataSortInfo dataSortInfo) {
        if (this.sortType != dataSortInfo.sortType) {
            return false;
        }
        return this.colNum == dataSortInfo.colNum;
    }

    public String toSql() {
        String res = ",\n\"data_sort.sort_type\" = \"" + this.sortType + "\",\n\"" + DATA_SORT_COL_NUM + "\" = \"" + this.colNum + "\"";
        return res;
    }
}

