/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.ColumnDef;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.ImportColumnDesc;
import org.apache.doris.analysis.ImportColumnsStmt;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.Separator;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.SqlParser;
import org.apache.doris.analysis.SqlScanner;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.Pair;
import org.apache.doris.common.util.SqlParserUtils;
import org.apache.doris.load.loadv2.LoadTask;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataDescription {
    private static final Logger LOG = LogManager.getLogger(DataDescription.class);
    private static final List<String> HADOOP_SUPPORT_FUNCTION_NAMES = Arrays.asList("strftime", "time_format", "alignment_timestamp", "default_value", "md5sum", "replace_value", "now", "hll_hash", "substitute");
    private final String tableName;
    private final PartitionNames partitionNames;
    private final List<String> filePaths;
    private final Separator columnSeparator;
    private final String fileFormat;
    private final boolean isNegative;
    private final List<String> columnsFromPath;
    private final List<Expr> columnMappingList;
    private final Expr precedingFilterExpr;
    private final Expr whereExpr;
    private final String srcTableName;
    private List<Long> fileSize;
    private List<String> fileFieldNames;
    private TNetworkAddress beAddr;
    private Separator lineDelimiter;
    private String columnDef;
    private long backendId;
    private boolean stripOuterArray = false;
    private String jsonPaths = "";
    private String jsonRoot = "";
    private boolean fuzzyParse = false;
    private boolean readJsonByLine = false;
    private boolean numAsString = false;
    private String sequenceCol;
    private List<ImportColumnDesc> parsedColumnExprList = Lists.newArrayList();
    private final Map<String, Pair<String, List<String>>> columnToHadoopFunction = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
    private boolean isHadoopLoad = false;
    private LoadTask.MergeType mergeType = LoadTask.MergeType.APPEND;
    private final Expr deleteCondition;
    private Map<String, String> properties;

    public DataDescription(String tableName, PartitionNames partitionNames, List<String> filePaths, List<String> columns, Separator columnSeparator, String fileFormat, boolean isNegative, List<Expr> columnMappingList) {
        this(tableName, partitionNames, filePaths, columns, columnSeparator, fileFormat, null, isNegative, columnMappingList, null, null, LoadTask.MergeType.APPEND, null, null, null);
    }

    public DataDescription(String tableName, PartitionNames partitionNames, List<String> filePaths, List<String> columns, Separator columnSeparator, String fileFormat, List<String> columnsFromPath, boolean isNegative, List<Expr> columnMappingList, Expr fileFilterExpr, Expr whereExpr, LoadTask.MergeType mergeType, Expr deleteCondition, String sequenceColName, Map<String, String> properties) {
        this.tableName = tableName;
        this.partitionNames = partitionNames;
        this.filePaths = filePaths;
        this.fileFieldNames = columns;
        this.columnSeparator = columnSeparator;
        this.fileFormat = fileFormat;
        this.columnsFromPath = columnsFromPath;
        this.isNegative = isNegative;
        this.columnMappingList = columnMappingList;
        this.precedingFilterExpr = fileFilterExpr;
        this.whereExpr = whereExpr;
        this.srcTableName = null;
        this.mergeType = mergeType;
        this.deleteCondition = deleteCondition;
        this.sequenceCol = sequenceColName;
        this.properties = properties;
    }

    public DataDescription(String tableName, PartitionNames partitionNames, String srcTableName, boolean isNegative, List<Expr> columnMappingList, Expr whereExpr, LoadTask.MergeType mergeType, Expr deleteCondition, Map<String, String> properties) {
        this.tableName = tableName;
        this.partitionNames = partitionNames;
        this.filePaths = null;
        this.fileFieldNames = null;
        this.columnSeparator = null;
        this.fileFormat = null;
        this.columnsFromPath = null;
        this.isNegative = isNegative;
        this.columnMappingList = columnMappingList;
        this.precedingFilterExpr = null;
        this.whereExpr = whereExpr;
        this.srcTableName = srcTableName;
        this.mergeType = mergeType;
        this.deleteCondition = deleteCondition;
        this.properties = properties;
    }

    public static void validateMappingFunction(String functionName, List<String> args, Map<String, String> columnNameMap, Column mappingColumn, boolean isHadoopLoad) throws AnalysisException {
        if (functionName.equalsIgnoreCase("alignment_timestamp")) {
            DataDescription.validateAlignmentTimestamp(args, columnNameMap);
        } else if (functionName.equalsIgnoreCase("strftime")) {
            DataDescription.validateStrftime(args, columnNameMap);
        } else if (functionName.equalsIgnoreCase("time_format")) {
            DataDescription.validateTimeFormat(args, columnNameMap);
        } else if (functionName.equalsIgnoreCase("default_value")) {
            DataDescription.validateDefaultValue(args, mappingColumn);
        } else if (functionName.equalsIgnoreCase("md5sum")) {
            DataDescription.validateMd5sum(args, columnNameMap);
        } else if (functionName.equalsIgnoreCase("replace_value")) {
            DataDescription.validateReplaceValue(args, mappingColumn);
        } else if (functionName.equalsIgnoreCase("hll_hash")) {
            DataDescription.validateHllHash(args, columnNameMap);
        } else if (functionName.equalsIgnoreCase("now")) {
            DataDescription.validateNowFunction(mappingColumn);
        } else if (functionName.equalsIgnoreCase("substitute")) {
            DataDescription.validateSubstituteFunction(args, columnNameMap);
        } else if (isHadoopLoad) {
            throw new AnalysisException("Unknown function: " + functionName);
        }
    }

    private static void validateSubstituteFunction(List<String> args, Map<String, String> columnNameMap) throws AnalysisException {
        if (args.size() != 1) {
            throw new AnalysisException("Should has only one argument: " + args);
        }
        String argColumn = args.get(0);
        if (!columnNameMap.containsKey(argColumn)) {
            throw new AnalysisException("Column is not in sources, column: " + argColumn);
        }
        args.set(0, columnNameMap.get(argColumn));
    }

    private static void validateAlignmentTimestamp(List<String> args, Map<String, String> columnNameMap) throws AnalysisException {
        String regex;
        if (args.size() != 2) {
            throw new AnalysisException("Function alignment_timestamp args size is not 2");
        }
        String precision = args.get(0).toLowerCase();
        if (!precision.matches(regex = "^year|month|day|hour$")) {
            throw new AnalysisException("Alignment precision error. regex: " + regex + ", arg: " + precision);
        }
        String argColumn = args.get(1);
        if (!columnNameMap.containsKey(argColumn)) {
            throw new AnalysisException("Column is not in sources, column: " + argColumn);
        }
        args.set(1, columnNameMap.get(argColumn));
    }

    private static void validateStrftime(List<String> args, Map<String, String> columnNameMap) throws AnalysisException {
        String regex;
        if (args.size() != 2) {
            throw new AnalysisException("Function strftime needs 2 args");
        }
        String format = args.get(0);
        if (!format.matches(regex = "^(%[YMmdHhiSs][ -:]?){0,5}%[YMmdHhiSs]$")) {
            throw new AnalysisException("Date format error. regex: " + regex + ", arg: " + format);
        }
        String argColumn = args.get(1);
        if (!columnNameMap.containsKey(argColumn)) {
            throw new AnalysisException("Column is not in sources, column: " + argColumn);
        }
        args.set(1, columnNameMap.get(argColumn));
    }

    private static void validateTimeFormat(List<String> args, Map<String, String> columnNameMap) throws AnalysisException {
        if (args.size() != 3) {
            throw new AnalysisException("Function time_format needs 3 args");
        }
        String outputFormat = args.get(0);
        String inputFormat = args.get(1);
        String regex = "^(%[YMmdHhiSs][ -:]?){0,5}%[YMmdHhiSs]$";
        if (!outputFormat.matches(regex)) {
            throw new AnalysisException("Date format error. regex: " + regex + ", arg: " + outputFormat);
        }
        if (!inputFormat.matches(regex)) {
            throw new AnalysisException("Date format error. regex: " + regex + ", arg: " + inputFormat);
        }
        String argColumn = args.get(2);
        if (!columnNameMap.containsKey(argColumn)) {
            throw new AnalysisException("Column is not in sources, column: " + argColumn);
        }
        args.set(2, columnNameMap.get(argColumn));
    }

    private static void validateDefaultValue(List<String> args, Column column) throws AnalysisException {
        if (args.size() != 1) {
            throw new AnalysisException("Function default_value needs 1 arg");
        }
        if (!column.isAllowNull() && args.get(0) == null) {
            throw new AnalysisException("Column is not null, column: " + column.getName());
        }
        if (args.get(0) != null) {
            ColumnDef.validateDefaultValue(column.getOriginType(), args.get(0), column.getDefaultValueExprDef());
        }
    }

    private static void validateMd5sum(List<String> args, Map<String, String> columnNameMap) throws AnalysisException {
        for (int i = 0; i < args.size(); ++i) {
            String argColumn = args.get(i);
            if (!columnNameMap.containsKey(argColumn)) {
                throw new AnalysisException("Column is not in sources, column: " + argColumn);
            }
            args.set(i, columnNameMap.get(argColumn));
        }
    }

    private static void validateReplaceValue(List<String> args, Column column) throws AnalysisException {
        String replaceValue = null;
        if (args.size() == 1) {
            replaceValue = column.getDefaultValue();
            if (replaceValue == null) {
                throw new AnalysisException("Column " + column.getName() + " has no default value");
            }
            args.add(replaceValue);
        } else if (args.size() == 2) {
            replaceValue = args.get(1);
        } else {
            throw new AnalysisException("Function replace_value need 1 or 2 args");
        }
        if (!column.isAllowNull() && replaceValue == null) {
            throw new AnalysisException("Column is not null, column: " + column.getName());
        }
        if (replaceValue != null) {
            ColumnDef.validateDefaultValue(column.getOriginType(), replaceValue, column.getDefaultValueExprDef());
        }
    }

    private static void validateHllHash(List<String> args, Map<String, String> columnNameMap) throws AnalysisException {
        for (int i = 0; i < args.size(); ++i) {
            String argColumn = args.get(i);
            if (!columnNameMap.containsKey(argColumn)) {
                throw new AnalysisException("Column is not in sources, column: " + argColumn);
            }
            args.set(i, columnNameMap.get(argColumn));
        }
    }

    private static void validateNowFunction(Column mappingColumn) throws AnalysisException {
        if (!mappingColumn.getOriginType().equals(Type.DATE) && !mappingColumn.getOriginType().equals(Type.DATETIME)) {
            throw new AnalysisException("Now() function is only support for DATE/DATETIME column");
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public PartitionNames getPartitionNames() {
        return this.partitionNames;
    }

    public Expr getPrecdingFilterExpr() {
        return this.precedingFilterExpr;
    }

    public Expr getWhereExpr() {
        return this.whereExpr;
    }

    public LoadTask.MergeType getMergeType() {
        if (this.mergeType == null) {
            return LoadTask.MergeType.APPEND;
        }
        return this.mergeType;
    }

    public Expr getDeleteCondition() {
        return this.deleteCondition;
    }

    public List<String> getFilePaths() {
        return this.filePaths;
    }

    public List<String> getFileFieldNames() {
        if (this.fileFieldNames == null || this.fileFieldNames.isEmpty()) {
            return null;
        }
        return this.fileFieldNames;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public List<String> getColumnsFromPath() {
        return this.columnsFromPath;
    }

    public String getColumnSeparator() {
        if (this.columnSeparator == null) {
            return null;
        }
        return this.columnSeparator.getSeparator();
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public TNetworkAddress getBeAddr() {
        return this.beAddr;
    }

    public void setBeAddr(TNetworkAddress addr) {
        this.beAddr = addr;
    }

    public String getLineDelimiter() {
        if (this.lineDelimiter == null) {
            return null;
        }
        return this.lineDelimiter.getSeparator();
    }

    public void setLineDelimiter(Separator lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    public String getSequenceCol() {
        return this.sequenceCol;
    }

    public void setColumnDef(String columnDef) {
        this.columnDef = columnDef;
    }

    public boolean hasSequenceCol() {
        return !Strings.isNullOrEmpty((String)this.sequenceCol);
    }

    public List<Long> getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(List<Long> fileSize) {
        this.fileSize = fileSize;
    }

    public long getBackendId() {
        return this.backendId;
    }

    public void setBackendId(long backendId) {
        this.backendId = backendId;
    }

    public boolean isStripOuterArray() {
        return this.stripOuterArray;
    }

    public void setStripOuterArray(boolean stripOuterArray) {
        this.stripOuterArray = stripOuterArray;
    }

    public boolean isFuzzyParse() {
        return this.fuzzyParse;
    }

    public void setFuzzyParse(boolean fuzzyParse) {
        this.fuzzyParse = fuzzyParse;
    }

    public boolean isNumAsString() {
        return this.numAsString;
    }

    public void setNumAsString(boolean numAsString) {
        this.numAsString = numAsString;
    }

    public String getJsonPaths() {
        return this.jsonPaths;
    }

    public void setJsonPaths(String jsonPaths) {
        this.jsonPaths = jsonPaths;
    }

    public String getJsonRoot() {
        return this.jsonRoot;
    }

    public void setJsonRoot(String jsonRoot) {
        this.jsonRoot = jsonRoot;
    }

    @Deprecated
    public void addColumnMapping(String functionName, Pair<String, List<String>> pair) {
        if (Strings.isNullOrEmpty((String)functionName) || pair == null) {
            return;
        }
        this.columnToHadoopFunction.put(functionName, pair);
    }

    public Map<String, Pair<String, List<String>>> getColumnToHadoopFunction() {
        return this.columnToHadoopFunction;
    }

    public List<ImportColumnDesc> getParsedColumnExprList() {
        return this.parsedColumnExprList;
    }

    public void setIsHadoopLoad(boolean isHadoopLoad) {
        this.isHadoopLoad = isHadoopLoad;
    }

    public boolean isHadoopLoad() {
        return this.isHadoopLoad;
    }

    public String getSrcTableName() {
        return this.srcTableName;
    }

    public boolean isLoadFromTable() {
        return !Strings.isNullOrEmpty((String)this.srcTableName);
    }

    private void analyzeColumns() throws AnalysisException {
        ImportColumnDesc importColumnDesc;
        if ((this.fileFieldNames == null || this.fileFieldNames.isEmpty()) && this.columnsFromPath != null && !this.columnsFromPath.isEmpty()) {
            throw new AnalysisException("Can not specify columns_from_path without column_list");
        }
        TreeSet<String> columnNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (this.fileFieldNames != null && !this.fileFieldNames.isEmpty()) {
            for (String columnName : this.fileFieldNames) {
                if (!columnNames.add(columnName)) {
                    throw new AnalysisException("Duplicate column: " + columnName);
                }
                importColumnDesc = new ImportColumnDesc(columnName, null);
                this.parsedColumnExprList.add(importColumnDesc);
            }
        }
        if (this.columnsFromPath != null && !this.columnsFromPath.isEmpty()) {
            if (this.isHadoopLoad) {
                throw new AnalysisException("Hadoop load does not support specifying columns from path");
            }
            for (String columnName : this.columnsFromPath) {
                if (!columnNames.add(columnName)) {
                    throw new AnalysisException("Duplicate column: " + columnName);
                }
                importColumnDesc = new ImportColumnDesc(columnName, null);
                this.parsedColumnExprList.add(importColumnDesc);
            }
        }
        if (this.columnMappingList == null || this.columnMappingList.isEmpty()) {
            return;
        }
        TreeSet<String> columnMappingNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Expr columnExpr : this.columnMappingList) {
            if (!(columnExpr instanceof BinaryPredicate)) {
                throw new AnalysisException("Mapping function expr only support the column or eq binary predicate. Expr: " + columnExpr.toSql());
            }
            BinaryPredicate predicate = (BinaryPredicate)columnExpr;
            if (predicate.getOp() != BinaryPredicate.Operator.EQ) {
                throw new AnalysisException("Mapping function expr only support the column or eq binary predicate. The mapping operator error, op: " + (Object)((Object)predicate.getOp()));
            }
            Expr child0 = (Expr)predicate.getChild(0);
            if (!(child0 instanceof SlotRef)) {
                throw new AnalysisException("Mapping function expr only support the column or eq binary predicate. The mapping column error. column: " + child0.toSql());
            }
            String column = ((SlotRef)child0).getColumnName();
            if (!columnMappingNames.add(column)) {
                throw new AnalysisException("Duplicate column mapping: " + column);
            }
            Expr child1 = (Expr)predicate.getChild(1);
            if (this.isHadoopLoad && !(child1 instanceof FunctionCallExpr)) {
                throw new AnalysisException("Hadoop load only supports the designated function. The error mapping function is:" + child1.toSql());
            }
            ImportColumnDesc importColumnDesc2 = new ImportColumnDesc(column, child1);
            this.parsedColumnExprList.add(importColumnDesc2);
            if (!(child1 instanceof FunctionCallExpr)) continue;
            this.analyzeColumnToHadoopFunction(column, child1);
        }
    }

    private void analyzeMultiLoadColumns() throws AnalysisException {
        ImportColumnsStmt columnsStmt;
        if (this.columnDef == null || this.columnDef.isEmpty()) {
            return;
        }
        String columnsSQL = "COLUMNS (" + this.columnDef + ")";
        SqlParser parser = new SqlParser(new SqlScanner(new StringReader(columnsSQL)));
        try {
            columnsStmt = (ImportColumnsStmt)SqlParserUtils.getFirstStmt(parser);
        }
        catch (Error e) {
            LOG.warn("error happens when parsing columns, sql={}", (Object)columnsSQL, (Object)e);
            throw new AnalysisException("failed to parsing columns' header, maybe contain unsupported character");
        }
        catch (AnalysisException e) {
            LOG.warn("analyze columns' statement failed, sql={}, error={}", (Object)columnsSQL, (Object)parser.getErrorMsg(columnsSQL), (Object)e);
            String errorMessage = parser.getErrorMsg(columnsSQL);
            if (errorMessage == null) {
                throw e;
            }
            throw new AnalysisException(errorMessage, e);
        }
        catch (Exception e) {
            LOG.warn("failed to parse columns header, sql={}", (Object)columnsSQL, (Object)e);
            throw new AnalysisException("parse columns header failed", e);
        }
        if (columnsStmt.getColumns() != null && !columnsStmt.getColumns().isEmpty()) {
            this.parsedColumnExprList = columnsStmt.getColumns();
        }
    }

    private void analyzeColumnToHadoopFunction(String columnName, Expr child1) throws AnalysisException {
        Preconditions.checkState((boolean)(child1 instanceof FunctionCallExpr));
        FunctionCallExpr functionCallExpr = (FunctionCallExpr)child1;
        String functionName = functionCallExpr.getFnName().getFunction();
        if (!HADOOP_SUPPORT_FUNCTION_NAMES.contains(functionName.toLowerCase())) {
            return;
        }
        List<Expr> paramExprs = functionCallExpr.getParams().exprs();
        ArrayList args = Lists.newArrayList();
        for (Expr paramExpr : paramExprs) {
            if (paramExpr instanceof SlotRef) {
                SlotRef slot = (SlotRef)paramExpr;
                args.add(slot.getColumnName());
                continue;
            }
            if (paramExpr instanceof StringLiteral) {
                StringLiteral literal = (StringLiteral)paramExpr;
                args.add(literal.getValue());
                continue;
            }
            if (paramExpr instanceof NullLiteral) {
                args.add(null);
                continue;
            }
            if (!this.isHadoopLoad) continue;
            throw new AnalysisException("Mapping function args error, arg: " + paramExpr.toSql());
        }
        Pair<String, ArrayList> functionPair = new Pair<String, ArrayList>(functionName, args);
        this.columnToHadoopFunction.put(columnName, functionPair);
    }

    private void analyzeSequenceCol(String fullDbName) throws AnalysisException {
        Database db = Catalog.getCurrentCatalog().getDbOrAnalysisException(fullDbName);
        OlapTable olapTable = db.getOlapTableOrAnalysisException(this.tableName);
        if (!this.hasSequenceCol() && !olapTable.hasSequenceCol().booleanValue()) {
            return;
        }
        if (olapTable.hasSequenceCol().booleanValue() && !this.hasSequenceCol()) {
            throw new AnalysisException("Table " + olapTable.getName() + " has sequence column, need to specify the sequence column");
        }
        if (this.hasSequenceCol() && !olapTable.hasSequenceCol().booleanValue()) {
            throw new AnalysisException("There is no sequence column in the table " + olapTable.getName());
        }
        boolean hasSourceSequenceCol = false;
        if (!this.parsedColumnExprList.isEmpty()) {
            for (ImportColumnDesc importColumnDesc : this.parsedColumnExprList) {
                if (!importColumnDesc.getColumnName().equals(this.sequenceCol)) continue;
                hasSourceSequenceCol = true;
                break;
            }
        } else {
            List<Column> columns = olapTable.getBaseSchema();
            for (Column column : columns) {
                if (!column.getName().equals(this.sequenceCol)) continue;
                hasSourceSequenceCol = true;
                break;
            }
        }
        if (!hasSourceSequenceCol) {
            throw new AnalysisException("There is no sequence column " + this.sequenceCol + " in the " + olapTable.getName() + " or the COLUMNS and SET clause");
        }
    }

    private void analyzeProperties() throws AnalysisException {
        TreeMap analysisMap = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        analysisMap.putAll(this.properties);
        if (analysisMap.containsKey("line_delimiter")) {
            this.lineDelimiter = new Separator((String)analysisMap.get("line_delimiter"));
            this.lineDelimiter.analyze();
        }
        if (analysisMap.containsKey("fuzzy_parse")) {
            this.fuzzyParse = Boolean.parseBoolean((String)analysisMap.get("fuzzy_parse"));
        }
        if (analysisMap.containsKey("strip_outer_array")) {
            this.stripOuterArray = Boolean.parseBoolean((String)analysisMap.get("strip_outer_array"));
        }
        if (analysisMap.containsKey("jsonpaths")) {
            this.jsonPaths = (String)analysisMap.get("jsonpaths");
        }
        if (analysisMap.containsKey("json_root")) {
            this.jsonRoot = (String)analysisMap.get("json_root");
        }
        if (analysisMap.containsKey("num_as_string")) {
            this.numAsString = Boolean.parseBoolean((String)analysisMap.get("num_as_string"));
        }
    }

    private void checkLoadPriv(String fullDbName) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.tableName)) {
            throw new AnalysisException("No table name in load statement.");
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), fullDbName, this.tableName, PrivPredicate.LOAD)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "LOAD", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), fullDbName + ": " + this.tableName);
        }
        if (this.isLoadFromTable() && !Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), fullDbName, this.srcTableName, PrivPredicate.SELECT)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "SELECT", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), fullDbName + ": " + this.srcTableName);
        }
    }

    public void analyze(String fullDbName) throws AnalysisException {
        if (this.mergeType != LoadTask.MergeType.MERGE && this.deleteCondition != null) {
            throw new AnalysisException("not support DELETE ON clause when merge type is not MERGE.");
        }
        if (this.mergeType == LoadTask.MergeType.MERGE && this.deleteCondition == null) {
            throw new AnalysisException("Excepted DELETE ON clause when merge type is MERGE.");
        }
        if (this.mergeType != LoadTask.MergeType.APPEND && this.isNegative) {
            throw new AnalysisException("not support MERGE or DELETE with NEGATIVE.");
        }
        this.checkLoadPriv(fullDbName);
        this.analyzeWithoutCheckPriv(fullDbName);
        if (this.isNegative && this.mergeType != LoadTask.MergeType.APPEND) {
            throw new AnalysisException("Negative is only used when merge type is append.");
        }
    }

    public void analyzeWithoutCheckPriv(String fullDbName) throws AnalysisException {
        if (!this.isLoadFromTable()) {
            if (this.filePaths == null || this.filePaths.isEmpty()) {
                throw new AnalysisException("No file path in load statement.");
            }
            for (int i = 0; i < this.filePaths.size(); ++i) {
                this.filePaths.set(i, this.filePaths.get(i).trim());
            }
        }
        if (this.columnSeparator != null) {
            this.columnSeparator.analyze();
        }
        if (this.partitionNames != null) {
            this.partitionNames.analyze(null);
        }
        this.analyzeColumns();
        this.analyzeMultiLoadColumns();
        this.analyzeSequenceCol(fullDbName);
        if (this.properties != null) {
            this.analyzeProperties();
        }
    }

    public void fillColumnInfoIfNotSpecified(List<Column> baseSchema) {
        if (this.fileFieldNames != null && !this.fileFieldNames.isEmpty()) {
            return;
        }
        this.fileFieldNames = Lists.newArrayList();
        TreeSet mappingColNames = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (ImportColumnDesc importColumnDesc : this.parsedColumnExprList) {
            mappingColNames.add(importColumnDesc.getColumnName());
        }
        for (Column column : baseSchema) {
            if (!mappingColNames.contains(column.getName())) {
                this.parsedColumnExprList.add(new ImportColumnDesc(column.getName(), null));
            }
            this.fileFieldNames.add(column.getName());
        }
        LOG.debug("after fill column info. columns: {}, parsed column exprs: {}", this.fileFieldNames, this.parsedColumnExprList);
    }

    public String toSql() {
        StringBuilder sb = new StringBuilder();
        if (this.isLoadFromTable()) {
            sb.append(this.mergeType.toString());
            sb.append(" DATA FROM TABLE ").append(this.srcTableName);
        } else {
            sb.append(this.mergeType.toString());
            sb.append(" DATA INFILE (");
            Joiner.on((String)", ").appendTo(sb, (Iterable)Lists.transform(this.filePaths, (Function)new Function<String, String>(){

                public String apply(String s) {
                    return "'" + s + "'";
                }
            })).append(")");
        }
        if (this.isNegative) {
            sb.append(" NEGATIVE");
        }
        sb.append(" INTO TABLE ").append(this.tableName);
        if (this.partitionNames != null) {
            sb.append(" ");
            sb.append(this.partitionNames.toSql());
        }
        if (this.columnSeparator != null) {
            sb.append(" COLUMNS TERMINATED BY ").append(this.columnSeparator.toSql());
        }
        if (this.columnsFromPath != null && !this.columnsFromPath.isEmpty()) {
            sb.append(" COLUMNS FROM PATH AS (");
            Joiner.on((String)", ").appendTo(sb, this.columnsFromPath).append(")");
        }
        if (this.fileFieldNames != null && !this.fileFieldNames.isEmpty()) {
            sb.append(" (");
            Joiner.on((String)", ").appendTo(sb, this.fileFieldNames).append(")");
        }
        if (this.columnMappingList != null && !this.columnMappingList.isEmpty()) {
            sb.append(" SET (");
            Joiner.on((String)", ").appendTo(sb, (Iterable)Lists.transform(this.columnMappingList, (Function)new Function<Expr, Object>(){

                public Object apply(Expr expr) {
                    return expr.toSql();
                }
            })).append(")");
        }
        if (this.whereExpr != null) {
            sb.append(" WHERE ").append(this.whereExpr.toSql());
        }
        if (this.deleteCondition != null && this.mergeType == LoadTask.MergeType.MERGE) {
            sb.append(" DELETE ON ").append(this.deleteCondition.toSql());
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

